/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.examples;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.concurrent.Future;
import org.apache.hc.client5.http.async.methods.AbstractBinPushConsumer;
import org.apache.hc.client5.http.async.methods.AbstractCharResponseConsumer;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClients;
import org.apache.hc.core5.function.Supplier;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.message.BasicHttpRequest;
import org.apache.hc.core5.http.message.StatusLine;
import org.apache.hc.core5.http.nio.AsyncPushConsumer;
import org.apache.hc.core5.http.nio.AsyncRequestProducer;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.http.nio.support.BasicRequestProducer;
import org.apache.hc.core5.http.support.BasicRequestBuilder;
import org.apache.hc.core5.http2.HttpVersionPolicy;
import org.apache.hc.core5.http2.config.H2Config;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.util.Timeout;

public class AsyncClientH2ServerPush {
    public static void main(String[] args) throws Exception {
        IOReactorConfig ioReactorConfig = IOReactorConfig.custom().setSoTimeout(Timeout.ofSeconds((long)5L)).build();
        H2Config h2Config = H2Config.custom().setPushEnabled(true).build();
        CloseableHttpAsyncClient client = HttpAsyncClients.custom().setIOReactorConfig(ioReactorConfig).setVersionPolicy(HttpVersionPolicy.FORCE_HTTP_2).setH2Config(h2Config).build();
        client.start();
        client.register("*", (Supplier)new Supplier<AsyncPushConsumer>(){

            public AsyncPushConsumer get() {
                return new AbstractBinPushConsumer(){

                    protected void start(HttpRequest promise, HttpResponse response, ContentType contentType) throws HttpException, IOException {
                        System.out.println(promise.getPath() + " (push)->" + new StatusLine(response));
                    }

                    protected int capacityIncrement() {
                        return Integer.MAX_VALUE;
                    }

                    protected void data(ByteBuffer data, boolean endOfStream) throws IOException {
                    }

                    protected void completed() {
                    }

                    public void failed(Exception cause) {
                        System.out.println("(push)->" + cause);
                    }

                    public void releaseResources() {
                    }
                };
            }
        });
        final BasicHttpRequest request = BasicRequestBuilder.get((String)"https://nghttp2.org/httpbin/").build();
        System.out.println("Executing request " + request);
        Future future = client.execute((AsyncRequestProducer)new BasicRequestProducer((HttpRequest)request, null), (AsyncResponseConsumer)new AbstractCharResponseConsumer<Void>(){

            protected void start(HttpResponse response, ContentType contentType) throws HttpException, IOException {
                System.out.println(request + "->" + new StatusLine(response));
            }

            protected int capacityIncrement() {
                return Integer.MAX_VALUE;
            }

            protected void data(CharBuffer data, boolean endOfStream) throws IOException {
            }

            protected Void buildResult() throws IOException {
                return null;
            }

            public void failed(Exception cause) {
                System.out.println(request + "->" + cause);
            }

            public void releaseResources() {
            }
        }, null);
        future.get();
        System.out.println("Shutting down");
        client.close(CloseMode.GRACEFUL);
    }
}

