/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.examples;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hc.client5.http.async.AsyncExecCallback;
import org.apache.hc.client5.http.async.AsyncExecChain;
import org.apache.hc.client5.http.async.AsyncExecChainHandler;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.async.methods.SimpleRequestBuilder;
import org.apache.hc.client5.http.impl.ChainElement;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClients;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.impl.BasicEntityDetails;
import org.apache.hc.core5.http.message.BasicHttpResponse;
import org.apache.hc.core5.http.message.StatusLine;
import org.apache.hc.core5.http.nio.AsyncDataConsumer;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.util.Timeout;

public class AsyncClientInterceptors {
    public static void main(String[] args) throws Exception {
        IOReactorConfig ioReactorConfig = IOReactorConfig.custom().setSoTimeout(Timeout.ofSeconds((long)5L)).build();
        CloseableHttpAsyncClient client = HttpAsyncClients.custom().setIOReactorConfig(ioReactorConfig).addRequestInterceptorFirst(new HttpRequestInterceptor(){
            private final AtomicLong count = new AtomicLong(0L);

            public void process(HttpRequest request, EntityDetails entity, HttpContext context) throws HttpException, IOException {
                request.setHeader("request-id", (Object)Long.toString(this.count.incrementAndGet()));
            }
        }).addExecInterceptorAfter(ChainElement.PROTOCOL.name(), "custom", new AsyncExecChainHandler(){

            public void execute(HttpRequest request, AsyncEntityProducer requestEntityProducer, AsyncExecChain.Scope scope, AsyncExecChain chain, AsyncExecCallback asyncExecCallback) throws HttpException, IOException {
                Header idHeader = request.getFirstHeader("request-id");
                if (idHeader != null && "13".equalsIgnoreCase(idHeader.getValue())) {
                    BasicHttpResponse response = new BasicHttpResponse(404, "Oppsie");
                    ByteBuffer content = ByteBuffer.wrap("bad luck".getBytes(StandardCharsets.US_ASCII));
                    AsyncDataConsumer asyncDataConsumer = asyncExecCallback.handleResponse((HttpResponse)response, (EntityDetails)new BasicEntityDetails((long)content.remaining(), ContentType.TEXT_PLAIN));
                    asyncDataConsumer.consume(content);
                    asyncDataConsumer.streamEnd(null);
                } else {
                    chain.proceed(request, requestEntityProducer, scope, asyncExecCallback);
                }
            }
        }).build();
        client.start();
        String requestUri = "http://httpbin.org/get";
        for (int i = 0; i < 20; ++i) {
            final SimpleHttpRequest request = SimpleRequestBuilder.get((String)"http://httpbin.org/get").build();
            System.out.println("Executing request " + request);
            Future future = client.execute(request, (FutureCallback)new FutureCallback<SimpleHttpResponse>(){

                public void completed(SimpleHttpResponse response) {
                    System.out.println(request + "->" + new StatusLine((HttpResponse)response));
                    System.out.println(response.getBody());
                }

                public void failed(Exception ex) {
                    System.out.println(request + "->" + ex);
                }

                public void cancelled() {
                    System.out.println(request + " cancelled");
                }
            });
            future.get();
        }
        System.out.println("Shutting down");
        client.close(CloseMode.GRACEFUL);
    }
}

