/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.examples;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.InputStreamEntity;

public class ClientChunkEncodedPost {
    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.out.println("File path not given");
            System.exit(1);
        }
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            HttpPost httppost = new HttpPost("http://httpbin.org/post");
            File file = new File(args[0]);
            InputStreamEntity reqEntity = new InputStreamEntity((InputStream)new FileInputStream(file), -1L, ContentType.APPLICATION_OCTET_STREAM);
            httppost.setEntity((HttpEntity)reqEntity);
            System.out.println("Executing request " + httppost.getMethod() + " " + httppost.getUri());
            try (CloseableHttpResponse response = httpclient.execute((ClassicHttpRequest)httppost);){
                System.out.println("----------------------------------------");
                System.out.println(response.getCode() + " " + response.getReasonPhrase());
                System.out.println(EntityUtils.toString((HttpEntity)response.getEntity()));
            }
        }
    }
}

