/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.examples;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hc.client5.http.classic.ExecChain;
import org.apache.hc.client5.http.classic.ExecChainHandler;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.ChainElement;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.message.BasicClassicHttpResponse;
import org.apache.hc.core5.http.protocol.HttpContext;

public class ClientInterceptors {
    public static void main(String[] args) throws Exception {
        try (CloseableHttpClient httpclient = HttpClients.custom().addRequestInterceptorFirst(new HttpRequestInterceptor(){
            private final AtomicLong count = new AtomicLong(0L);

            public void process(HttpRequest request, EntityDetails entity, HttpContext context) throws HttpException, IOException {
                request.setHeader("request-id", (Object)Long.toString(this.count.incrementAndGet()));
            }
        }).addExecInterceptorAfter(ChainElement.PROTOCOL.name(), "custom", new ExecChainHandler(){

            public ClassicHttpResponse execute(ClassicHttpRequest request, ExecChain.Scope scope, ExecChain chain) throws IOException, HttpException {
                Header idHeader = request.getFirstHeader("request-id");
                if (idHeader != null && "13".equalsIgnoreCase(idHeader.getValue())) {
                    BasicClassicHttpResponse response = new BasicClassicHttpResponse(404, "Oppsie");
                    response.setEntity((HttpEntity)new StringEntity("bad luck", ContentType.TEXT_PLAIN));
                    return response;
                }
                return chain.proceed(request, scope);
            }
        }).build();){
            for (int i = 0; i < 20; ++i) {
                HttpGet httpget = new HttpGet("http://httpbin.org/get");
                System.out.println("Executing request " + httpget.getMethod() + " " + httpget.getUri());
                try (CloseableHttpResponse response = httpclient.execute((ClassicHttpRequest)httpget);){
                    System.out.println("----------------------------------------");
                    System.out.println(response.getCode() + " " + response.getReasonPhrase());
                    System.out.println(EntityUtils.toString((HttpEntity)response.getEntity()));
                    continue;
                }
            }
        }
    }
}

