/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.examples;

import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.auth.BasicScheme;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.protocol.HttpContext;

public class ClientPreemptiveBasicAuthentication {
    public static void main(String[] args) throws Exception {
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            BasicScheme basicAuth = new BasicScheme();
            basicAuth.initPreemptive((Credentials)new UsernamePasswordCredentials("user", "passwd".toCharArray()));
            HttpHost target = new HttpHost("http", "httpbin.org", 80);
            HttpClientContext localContext = HttpClientContext.create();
            localContext.resetAuthExchange(target, (AuthScheme)basicAuth);
            HttpGet httpget = new HttpGet("http://httpbin.org/hidden-basic-auth/user/passwd");
            System.out.println("Executing request " + httpget.getMethod() + " " + httpget.getUri());
            for (int i = 0; i < 3; ++i) {
                try (CloseableHttpResponse response = httpclient.execute((ClassicHttpRequest)httpget, (HttpContext)localContext);){
                    System.out.println("----------------------------------------");
                    System.out.println(response.getCode() + " " + response.getReasonPhrase());
                    System.out.println(EntityUtils.toString((HttpEntity)response.getEntity()));
                    continue;
                }
            }
        }
    }
}

