/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.examples;

import org.apache.hc.client5.http.auth.AuthExchange;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.auth.DigestScheme;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.protocol.HttpContext;

public class ClientPreemptiveDigestAuthentication {
    public static void main(String[] args) throws Exception {
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            HttpHost target = new HttpHost("http", "httpbin.org", 80);
            HttpClientContext localContext = HttpClientContext.create();
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(new AuthScope(target), (Credentials)new UsernamePasswordCredentials("user", "passwd".toCharArray()));
            localContext.setCredentialsProvider((CredentialsProvider)credentialsProvider);
            HttpGet httpget = new HttpGet("http://httpbin.org/digest-auth/auth/user/passwd");
            System.out.println("Executing request " + httpget.getMethod() + " " + httpget.getUri());
            for (int i = 0; i < 3; ++i) {
                try (CloseableHttpResponse response = httpclient.execute(target, (ClassicHttpRequest)httpget, (HttpContext)localContext);){
                    AuthScheme authScheme;
                    System.out.println("----------------------------------------");
                    System.out.println(response.getCode() + " " + response.getReasonPhrase());
                    EntityUtils.consume((HttpEntity)response.getEntity());
                    AuthExchange authExchange = localContext.getAuthExchange(target);
                    if (authExchange == null || !((authScheme = authExchange.getAuthScheme()) instanceof DigestScheme)) continue;
                    DigestScheme digestScheme = (DigestScheme)authScheme;
                    System.out.println("Nonce: " + digestScheme.getNonce() + "; count: " + digestScheme.getNounceCount());
                    continue;
                }
            }
        }
    }
}

