/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.examples;

import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.io.entity.EntityUtils;

public class ClientProxyAuthentication {
    public static void main(String[] args) throws Exception {
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(new AuthScope("localhost", 8888), (Credentials)new UsernamePasswordCredentials("squid", "squid".toCharArray()));
        credsProvider.setCredentials(new AuthScope("httpbin.org", 80), (Credentials)new UsernamePasswordCredentials("user", "passwd".toCharArray()));
        try (CloseableHttpClient httpclient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();){
            HttpHost target = new HttpHost("http", "httpbin.org", 80);
            HttpHost proxy = new HttpHost("localhost", 8888);
            RequestConfig config = RequestConfig.custom().setProxy(proxy).build();
            HttpGet httpget = new HttpGet("/basic-auth/user/passwd");
            httpget.setConfig(config);
            System.out.println("Executing request " + httpget.getMethod() + " " + httpget.getUri() + " via " + proxy);
            try (CloseableHttpResponse response = httpclient.execute(target, (ClassicHttpRequest)httpget);){
                System.out.println("----------------------------------------");
                System.out.println(response.getCode() + " " + response.getReasonPhrase());
                System.out.println(EntityUtils.toString((HttpEntity)response.getEntity()));
            }
        }
    }
}

