/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.examples;

import java.io.IOException;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.EntityUtils;

public class ClientWithResponseHandler {
    public static void main(String[] args) throws Exception {
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            HttpGet httpget = new HttpGet("http://httpbin.org/get");
            System.out.println("Executing request " + httpget.getMethod() + " " + httpget.getUri());
            HttpClientResponseHandler<String> responseHandler = new HttpClientResponseHandler<String>(){

                public String handleResponse(ClassicHttpResponse response) throws IOException {
                    int status = response.getCode();
                    if (status >= 200 && status < 300) {
                        HttpEntity entity = response.getEntity();
                        try {
                            return entity != null ? EntityUtils.toString((HttpEntity)entity) : null;
                        }
                        catch (ParseException ex) {
                            throw new ClientProtocolException((Throwable)ex);
                        }
                    }
                    throw new ClientProtocolException("Unexpected response status: " + status);
                }
            };
            String responseBody = (String)httpclient.execute((ClassicHttpRequest)httpget, (HttpClientResponseHandler)responseHandler);
            System.out.println("----------------------------------------");
            System.out.println(responseBody);
        }
    }
}

