/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl;

import org.apache.hc.client5.http.impl.ProtocolSupport;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.message.BasicHttpRequest;
import org.apache.hc.core5.net.URIAuthority;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class TestProtocolSupport {
    @Test
    public void testGetRequestUri() {
        BasicHttpRequest request = new BasicHttpRequest(Method.GET, "");
        Assert.assertThat((Object)ProtocolSupport.getRequestUri((HttpRequest)request), (Matcher)CoreMatchers.equalTo((Object)"/"));
        request.setAuthority(new URIAuthority("testUser", "localhost", 8080));
        Assert.assertThat((Object)ProtocolSupport.getRequestUri((HttpRequest)request), (Matcher)CoreMatchers.equalTo((Object)"http://testUser@localhost:8080/"));
        request.setScheme("https");
        Assert.assertThat((Object)ProtocolSupport.getRequestUri((HttpRequest)request), (Matcher)CoreMatchers.equalTo((Object)"https://testUser@localhost:8080/"));
        request.setPath("blah");
        Assert.assertThat((Object)ProtocolSupport.getRequestUri((HttpRequest)request), (Matcher)CoreMatchers.equalTo((Object)"https://testUser@localhost:8080/blah"));
        request.setPath("/blah/blah");
        Assert.assertThat((Object)ProtocolSupport.getRequestUri((HttpRequest)request), (Matcher)CoreMatchers.equalTo((Object)"https://testUser@localhost:8080/blah/blah"));
    }
}

