/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.auth;

import java.util.List;
import org.apache.hc.client5.http.NameValuePairMatcher;
import org.apache.hc.client5.http.auth.AuthChallenge;
import org.apache.hc.client5.http.auth.ChallengeType;
import org.apache.hc.client5.http.impl.auth.AuthChallengeParser;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.message.ParserCursor;
import org.apache.hc.core5.util.CharArrayBuffer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestAuthChallengeParser {
    private AuthChallengeParser parser;

    @Before
    public void setUp() throws Exception {
        this.parser = new AuthChallengeParser();
    }

    @Test
    public void testParseTokenTerminatedByBlank() throws Exception {
        CharArrayBuffer buffer = new CharArrayBuffer(64);
        buffer.append("aaabbbbccc ");
        ParserCursor cursor = new ParserCursor(0, buffer.length());
        Assert.assertThat((Object)this.parser.parseToken((CharSequence)buffer, cursor), (Matcher)CoreMatchers.equalTo((Object)"aaabbbbccc"));
    }

    @Test
    public void testParseTokenTerminatedByComma() throws Exception {
        CharArrayBuffer buffer = new CharArrayBuffer(64);
        buffer.append("aaabbbbccc, ");
        ParserCursor cursor = new ParserCursor(0, buffer.length());
        Assert.assertThat((Object)this.parser.parseToken((CharSequence)buffer, cursor), (Matcher)CoreMatchers.equalTo((Object)"aaabbbbccc"));
    }

    @Test
    public void testParseTokenTerminatedByEndOfStream() throws Exception {
        CharArrayBuffer buffer = new CharArrayBuffer(64);
        buffer.append("aaabbbbccc");
        ParserCursor cursor = new ParserCursor(0, buffer.length());
        Assert.assertThat((Object)this.parser.parseToken((CharSequence)buffer, cursor), (Matcher)CoreMatchers.equalTo((Object)"aaabbbbccc"));
    }

    @Test
    public void testParsePaddedToken68() throws Exception {
        CharArrayBuffer buffer = new CharArrayBuffer(64);
        buffer.append("aaabbbbccc==== ");
        ParserCursor cursor = new ParserCursor(0, buffer.length());
        Assert.assertThat((Object)this.parser.parseToken((CharSequence)buffer, cursor), (Matcher)CoreMatchers.equalTo((Object)"aaabbbbccc===="));
        Assert.assertThat((Object)cursor.atEnd(), (Matcher)CoreMatchers.equalTo((Object)false));
        Assert.assertThat((Object)Character.valueOf(buffer.charAt(cursor.getPos())), (Matcher)CoreMatchers.equalTo((Object)Character.valueOf(' ')));
    }

    @Test
    public void testParsePaddedToken68SingleEqual() throws Exception {
        CharArrayBuffer buffer = new CharArrayBuffer(64);
        buffer.append("aaabbbbccc=");
        ParserCursor cursor = new ParserCursor(0, buffer.length());
        Assert.assertThat((Object)this.parser.parseToken((CharSequence)buffer, cursor), (Matcher)CoreMatchers.equalTo((Object)"aaabbbbccc="));
        Assert.assertThat((Object)cursor.atEnd(), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void testParsePaddedToken68MultipleEquals() throws Exception {
        CharArrayBuffer buffer = new CharArrayBuffer(16);
        buffer.append("aaabbbbccc======");
        ParserCursor cursor = new ParserCursor(0, buffer.length());
        Assert.assertThat((Object)this.parser.parseToken((CharSequence)buffer, cursor), (Matcher)CoreMatchers.equalTo((Object)"aaabbbbccc======"));
        Assert.assertThat((Object)cursor.atEnd(), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void testParsePaddedToken68TerminatedByComma() throws Exception {
        CharArrayBuffer buffer = new CharArrayBuffer(64);
        buffer.append("aaabbbbccc====,");
        ParserCursor cursor = new ParserCursor(0, buffer.length());
        Assert.assertThat((Object)this.parser.parseToken((CharSequence)buffer, cursor), (Matcher)CoreMatchers.equalTo((Object)"aaabbbbccc===="));
        Assert.assertThat((Object)cursor.atEnd(), (Matcher)CoreMatchers.equalTo((Object)false));
        Assert.assertThat((Object)Character.valueOf(buffer.charAt(cursor.getPos())), (Matcher)CoreMatchers.equalTo((Object)Character.valueOf(',')));
    }

    @Test
    public void testParseTokenTerminatedByParameter() throws Exception {
        CharArrayBuffer buffer = new CharArrayBuffer(64);
        buffer.append("aaabbbbccc=blah");
        ParserCursor cursor = new ParserCursor(0, buffer.length());
        Assert.assertThat((Object)this.parser.parseToken((CharSequence)buffer, cursor), (Matcher)CoreMatchers.equalTo((Object)"aaabbbbccc"));
        Assert.assertThat((Object)cursor.atEnd(), (Matcher)CoreMatchers.equalTo((Object)false));
        Assert.assertThat((Object)Character.valueOf(buffer.charAt(cursor.getPos())), (Matcher)CoreMatchers.equalTo((Object)Character.valueOf('=')));
    }

    @Test
    public void testParseBasicAuthChallenge() throws Exception {
        CharArrayBuffer buffer = new CharArrayBuffer(64);
        buffer.append("Basic realm=blah");
        ParserCursor cursor = new ParserCursor(0, buffer.length());
        List challenges = this.parser.parse(ChallengeType.TARGET, (CharSequence)buffer, cursor);
        Assert.assertNotNull((Object)challenges);
        Assert.assertEquals((long)1L, (long)challenges.size());
        AuthChallenge challenge1 = (AuthChallenge)challenges.get(0);
        Assert.assertEquals((Object)"Basic", (Object)challenge1.getSchemeName());
        Assert.assertEquals(null, (Object)challenge1.getValue());
        List params = challenge1.getParams();
        Assert.assertNotNull((Object)params);
        Assert.assertEquals((long)1L, (long)params.size());
        Assert.assertThat(params.get(0), NameValuePairMatcher.equals("realm", "blah"));
    }

    @Test
    public void testParseAuthChallengeWithBlanks() throws Exception {
        CharArrayBuffer buffer = new CharArrayBuffer(64);
        buffer.append("   Basic  realm = blah   ");
        ParserCursor cursor = new ParserCursor(0, buffer.length());
        List challenges = this.parser.parse(ChallengeType.TARGET, (CharSequence)buffer, cursor);
        Assert.assertNotNull((Object)challenges);
        Assert.assertEquals((long)1L, (long)challenges.size());
        AuthChallenge challenge1 = (AuthChallenge)challenges.get(0);
        Assert.assertEquals((Object)"Basic", (Object)challenge1.getSchemeName());
        Assert.assertEquals(null, (Object)challenge1.getValue());
        List params = challenge1.getParams();
        Assert.assertNotNull((Object)params);
        Assert.assertEquals((long)1L, (long)params.size());
        Assert.assertThat(params.get(0), NameValuePairMatcher.equals("realm", "blah"));
    }

    @Test
    public void testParseMultipleAuthChallenge() throws Exception {
        CharArrayBuffer buffer = new CharArrayBuffer(64);
        buffer.append("This  xxxxxxxxxxxxxxxxxxxxxx, That yyyyyyyyyyyyyyyyyyyyyy  ");
        ParserCursor cursor = new ParserCursor(0, buffer.length());
        List challenges = this.parser.parse(ChallengeType.TARGET, (CharSequence)buffer, cursor);
        Assert.assertNotNull((Object)challenges);
        Assert.assertEquals((long)2L, (long)challenges.size());
        AuthChallenge challenge1 = (AuthChallenge)challenges.get(0);
        Assert.assertEquals((Object)"This", (Object)challenge1.getSchemeName());
        Assert.assertEquals((Object)"xxxxxxxxxxxxxxxxxxxxxx", (Object)challenge1.getValue());
        Assert.assertNull((Object)challenge1.getParams());
        AuthChallenge challenge2 = (AuthChallenge)challenges.get(1);
        Assert.assertEquals((Object)"That", (Object)challenge2.getSchemeName());
        Assert.assertEquals((Object)"yyyyyyyyyyyyyyyyyyyyyy", (Object)challenge2.getValue());
        Assert.assertNull((Object)challenge2.getParams());
    }

    @Test
    public void testParseMultipleAuthChallengeWithParams() throws Exception {
        CharArrayBuffer buffer = new CharArrayBuffer(64);
        buffer.append("Basic realm=blah, param1 = this, param2=that, Basic realm=\"\\\"yada\\\"\", this, that=,this-and-that  ");
        ParserCursor cursor = new ParserCursor(0, buffer.length());
        List challenges = this.parser.parse(ChallengeType.TARGET, (CharSequence)buffer, cursor);
        Assert.assertNotNull((Object)challenges);
        Assert.assertEquals((long)2L, (long)challenges.size());
        AuthChallenge challenge1 = (AuthChallenge)challenges.get(0);
        Assert.assertEquals((Object)"Basic", (Object)challenge1.getSchemeName());
        Assert.assertEquals(null, (Object)challenge1.getValue());
        List params1 = challenge1.getParams();
        Assert.assertNotNull((Object)params1);
        Assert.assertEquals((long)3L, (long)params1.size());
        Assert.assertThat(params1.get(0), NameValuePairMatcher.equals("realm", "blah"));
        Assert.assertThat(params1.get(1), NameValuePairMatcher.equals("param1", "this"));
        Assert.assertThat(params1.get(2), NameValuePairMatcher.equals("param2", "that"));
        AuthChallenge challenge2 = (AuthChallenge)challenges.get(1);
        Assert.assertEquals((Object)"Basic", (Object)challenge2.getSchemeName());
        Assert.assertEquals(null, (Object)challenge2.getValue());
        List params2 = challenge2.getParams();
        Assert.assertNotNull((Object)params2);
        Assert.assertEquals((long)4L, (long)params2.size());
        Assert.assertThat(params2.get(0), NameValuePairMatcher.equals("realm", "\"yada\""));
        Assert.assertThat(params2.get(1), NameValuePairMatcher.equals("this", null));
        Assert.assertThat(params2.get(2), NameValuePairMatcher.equals("that", ""));
        Assert.assertThat(params2.get(3), NameValuePairMatcher.equals("this-and-that", null));
    }

    @Test
    public void testParseMultipleAuthChallengeWithParamsContainingComma() throws Exception {
        CharArrayBuffer buffer = new CharArrayBuffer(64);
        buffer.append("Basic realm=blah, param1 = \"this, param2=that\", Basic realm=\"\\\"yada,,,,\\\"\"");
        ParserCursor cursor = new ParserCursor(0, buffer.length());
        List challenges = this.parser.parse(ChallengeType.TARGET, (CharSequence)buffer, cursor);
        Assert.assertNotNull((Object)challenges);
        Assert.assertEquals((long)2L, (long)challenges.size());
        AuthChallenge challenge1 = (AuthChallenge)challenges.get(0);
        Assert.assertEquals((Object)"Basic", (Object)challenge1.getSchemeName());
        Assert.assertEquals(null, (Object)challenge1.getValue());
        List params1 = challenge1.getParams();
        Assert.assertNotNull((Object)params1);
        Assert.assertEquals((long)2L, (long)params1.size());
        Assert.assertThat(params1.get(0), NameValuePairMatcher.equals("realm", "blah"));
        Assert.assertThat(params1.get(1), NameValuePairMatcher.equals("param1", "this, param2=that"));
        AuthChallenge challenge2 = (AuthChallenge)challenges.get(1);
        Assert.assertEquals((Object)"Basic", (Object)challenge2.getSchemeName());
        Assert.assertEquals(null, (Object)challenge2.getValue());
        List params2 = challenge2.getParams();
        Assert.assertNotNull((Object)params2);
        Assert.assertEquals((long)1L, (long)params2.size());
        Assert.assertThat(params2.get(0), NameValuePairMatcher.equals("realm", "\"yada,,,,\""));
    }

    @Test
    public void testParseEmptyAuthChallenge1() throws Exception {
        CharArrayBuffer buffer = new CharArrayBuffer(64);
        buffer.append("This");
        ParserCursor cursor = new ParserCursor(0, buffer.length());
        List challenges = this.parser.parse(ChallengeType.TARGET, (CharSequence)buffer, cursor);
        Assert.assertNotNull((Object)challenges);
        Assert.assertEquals((long)1L, (long)challenges.size());
        AuthChallenge challenge1 = (AuthChallenge)challenges.get(0);
        Assert.assertEquals((Object)"This", (Object)challenge1.getSchemeName());
        Assert.assertEquals(null, (Object)challenge1.getValue());
        Assert.assertNull((Object)challenge1.getParams());
    }

    @Test(expected=ParseException.class)
    public void testParseMalformedAuthChallenge1() throws Exception {
        CharArrayBuffer buffer = new CharArrayBuffer(64);
        buffer.append("This , ");
        ParserCursor cursor = new ParserCursor(0, buffer.length());
        this.parser.parse(ChallengeType.TARGET, (CharSequence)buffer, cursor);
    }

    @Test(expected=ParseException.class)
    public void testParseMalformedAuthChallenge2() throws Exception {
        CharArrayBuffer buffer = new CharArrayBuffer(64);
        buffer.append("This = that");
        ParserCursor cursor = new ParserCursor(0, buffer.length());
        this.parser.parse(ChallengeType.TARGET, (CharSequence)buffer, cursor);
    }

    @Test(expected=ParseException.class)
    public void testParseMalformedAuthChallenge3() throws Exception {
        CharArrayBuffer buffer = new CharArrayBuffer(64);
        buffer.append("blah blah blah");
        ParserCursor cursor = new ParserCursor(0, buffer.length());
        this.parser.parse(ChallengeType.TARGET, (CharSequence)buffer, cursor);
    }

    @Test
    public void testParseValidAuthChallenge1() throws Exception {
        CharArrayBuffer buffer = new CharArrayBuffer(64);
        buffer.append("blah blah");
        ParserCursor cursor = new ParserCursor(0, buffer.length());
        List challenges = this.parser.parse(ChallengeType.TARGET, (CharSequence)buffer, cursor);
        Assert.assertNotNull((Object)challenges);
        Assert.assertEquals((long)1L, (long)challenges.size());
        AuthChallenge challenge1 = (AuthChallenge)challenges.get(0);
        Assert.assertEquals((Object)"blah", (Object)challenge1.getSchemeName());
        Assert.assertEquals((Object)"blah", (Object)challenge1.getValue());
        Assert.assertNull((Object)challenge1.getParams());
    }

    @Test
    public void testParseValidAuthChallenge2() throws Exception {
        CharArrayBuffer buffer = new CharArrayBuffer(64);
        buffer.append("blah blah, blah");
        ParserCursor cursor = new ParserCursor(0, buffer.length());
        List challenges = this.parser.parse(ChallengeType.TARGET, (CharSequence)buffer, cursor);
        Assert.assertNotNull((Object)challenges);
        Assert.assertEquals((long)1L, (long)challenges.size());
        AuthChallenge challenge1 = (AuthChallenge)challenges.get(0);
        Assert.assertEquals((Object)"blah", (Object)challenge1.getSchemeName());
        Assert.assertEquals(null, (Object)challenge1.getValue());
        List params1 = challenge1.getParams();
        Assert.assertNotNull((Object)params1);
        Assert.assertEquals((long)2L, (long)params1.size());
        Assert.assertThat(params1.get(0), NameValuePairMatcher.equals("blah", null));
        Assert.assertThat(params1.get(1), NameValuePairMatcher.equals("blah", null));
    }

    @Test
    public void testParseEmptyNTLMAuthChallenge() throws Exception {
        CharArrayBuffer buffer = new CharArrayBuffer(64);
        buffer.append("NTLM");
        ParserCursor cursor = new ParserCursor(0, buffer.length());
        List challenges = this.parser.parse(ChallengeType.TARGET, (CharSequence)buffer, cursor);
        Assert.assertNotNull((Object)challenges);
        Assert.assertEquals((long)1L, (long)challenges.size());
        AuthChallenge challenge1 = (AuthChallenge)challenges.get(0);
        Assert.assertEquals((Object)"NTLM", (Object)challenge1.getSchemeName());
        Assert.assertEquals(null, (Object)challenge1.getValue());
    }

    @Test
    public void testParseParameterAndToken68AuthChallengeMix() throws Exception {
        CharArrayBuffer buffer = new CharArrayBuffer(64);
        buffer.append("scheme1 aaaa  , scheme2 aaaa==,  scheme3 aaaa=aaaa, scheme4 aaaa=");
        ParserCursor cursor = new ParserCursor(0, buffer.length());
        List challenges = this.parser.parse(ChallengeType.TARGET, (CharSequence)buffer, cursor);
        Assert.assertNotNull((Object)challenges);
        Assert.assertEquals((long)4L, (long)challenges.size());
        AuthChallenge challenge1 = (AuthChallenge)challenges.get(0);
        Assert.assertThat((Object)challenge1.getSchemeName(), (Matcher)CoreMatchers.equalTo((Object)"scheme1"));
        Assert.assertThat((Object)challenge1.getValue(), (Matcher)CoreMatchers.equalTo((Object)"aaaa"));
        Assert.assertThat((Object)challenge1.getParams(), (Matcher)CoreMatchers.nullValue());
        AuthChallenge challenge2 = (AuthChallenge)challenges.get(1);
        Assert.assertThat((Object)challenge2.getSchemeName(), (Matcher)CoreMatchers.equalTo((Object)"scheme2"));
        Assert.assertThat((Object)challenge2.getValue(), (Matcher)CoreMatchers.equalTo((Object)"aaaa=="));
        Assert.assertThat((Object)challenge2.getParams(), (Matcher)CoreMatchers.nullValue());
        AuthChallenge challenge3 = (AuthChallenge)challenges.get(2);
        Assert.assertThat((Object)challenge3.getSchemeName(), (Matcher)CoreMatchers.equalTo((Object)"scheme3"));
        Assert.assertThat((Object)challenge3.getValue(), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)challenge3.getParams(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)challenge3.getParams().size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat(challenge3.getParams().get(0), NameValuePairMatcher.equals("aaaa", "aaaa"));
        AuthChallenge challenge4 = (AuthChallenge)challenges.get(3);
        Assert.assertThat((Object)challenge4.getSchemeName(), (Matcher)CoreMatchers.equalTo((Object)"scheme4"));
        Assert.assertThat((Object)challenge4.getValue(), (Matcher)CoreMatchers.equalTo((Object)"aaaa="));
        Assert.assertThat((Object)challenge4.getParams(), (Matcher)CoreMatchers.nullValue());
    }
}

