/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.classic;

import java.util.Random;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.classic.BackoffManager;
import org.apache.hc.client5.http.impl.classic.AIMDBackoffManager;
import org.apache.hc.client5.http.impl.classic.Clock;
import org.apache.hc.client5.http.impl.classic.MockClock;
import org.apache.hc.client5.http.impl.classic.MockConnPoolControl;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.pool.ConnPoolControl;
import org.apache.hc.core5.util.TimeValue;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestAIMDBackoffManager {
    private AIMDBackoffManager impl;
    private MockConnPoolControl connPerRoute;
    private HttpRoute route;
    private MockClock clock;

    @Before
    public void setUp() {
        this.connPerRoute = new MockConnPoolControl();
        this.route = new HttpRoute(new HttpHost("localhost", 80));
        this.clock = new MockClock();
        this.impl = new AIMDBackoffManager((ConnPoolControl)this.connPerRoute, (Clock)this.clock);
        this.impl.setPerHostConnectionCap(10);
    }

    @Test
    public void isABackoffManager() {
        Assert.assertTrue((boolean)(this.impl instanceof BackoffManager));
    }

    @Test
    public void halvesConnectionsOnBackoff() {
        this.connPerRoute.setMaxPerRoute(this.route, 4);
        this.impl.backOff(this.route);
        Assert.assertEquals((long)2L, (long)this.connPerRoute.getMaxPerRoute(this.route));
    }

    @Test
    public void doesNotBackoffBelowOneConnection() {
        this.connPerRoute.setMaxPerRoute(this.route, 1);
        this.impl.backOff(this.route);
        Assert.assertEquals((long)1L, (long)this.connPerRoute.getMaxPerRoute(this.route));
    }

    @Test
    public void increasesByOneOnProbe() {
        this.connPerRoute.setMaxPerRoute(this.route, 2);
        this.impl.probe(this.route);
        Assert.assertEquals((long)3L, (long)this.connPerRoute.getMaxPerRoute(this.route));
    }

    @Test
    public void doesNotIncreaseBeyondPerHostMaxOnProbe() {
        this.connPerRoute.setDefaultMaxPerRoute(5);
        this.connPerRoute.setMaxPerRoute(this.route, 5);
        this.impl.setPerHostConnectionCap(5);
        this.impl.probe(this.route);
        Assert.assertEquals((long)5L, (long)this.connPerRoute.getMaxPerRoute(this.route));
    }

    @Test
    public void backoffDoesNotAdjustDuringCoolDownPeriod() {
        this.connPerRoute.setMaxPerRoute(this.route, 4);
        long now = System.currentTimeMillis();
        this.clock.setCurrentTime(now);
        this.impl.backOff(this.route);
        long max = this.connPerRoute.getMaxPerRoute(this.route);
        this.clock.setCurrentTime(now + 1L);
        this.impl.backOff(this.route);
        Assert.assertEquals((long)max, (long)this.connPerRoute.getMaxPerRoute(this.route));
    }

    @Test
    public void backoffStillAdjustsAfterCoolDownPeriod() {
        this.connPerRoute.setMaxPerRoute(this.route, 8);
        long now = System.currentTimeMillis();
        this.clock.setCurrentTime(now);
        this.impl.backOff(this.route);
        long max = this.connPerRoute.getMaxPerRoute(this.route);
        this.clock.setCurrentTime(now + 10000L);
        this.impl.backOff(this.route);
        Assert.assertTrue((max == 1L || max > (long)this.connPerRoute.getMaxPerRoute(this.route) ? 1 : 0) != 0);
    }

    @Test
    public void probeDoesNotAdjustDuringCooldownPeriod() {
        this.connPerRoute.setMaxPerRoute(this.route, 4);
        long now = System.currentTimeMillis();
        this.clock.setCurrentTime(now);
        this.impl.probe(this.route);
        long max = this.connPerRoute.getMaxPerRoute(this.route);
        this.clock.setCurrentTime(now + 1L);
        this.impl.probe(this.route);
        Assert.assertEquals((long)max, (long)this.connPerRoute.getMaxPerRoute(this.route));
    }

    @Test
    public void probeStillAdjustsAfterCoolDownPeriod() {
        this.connPerRoute.setMaxPerRoute(this.route, 8);
        long now = System.currentTimeMillis();
        this.clock.setCurrentTime(now);
        this.impl.probe(this.route);
        long max = this.connPerRoute.getMaxPerRoute(this.route);
        this.clock.setCurrentTime(now + 10000L);
        this.impl.probe(this.route);
        Assert.assertTrue((max < (long)this.connPerRoute.getMaxPerRoute(this.route) ? 1 : 0) != 0);
    }

    @Test
    public void willBackoffImmediatelyEvenAfterAProbe() {
        this.connPerRoute.setMaxPerRoute(this.route, 8);
        long now = System.currentTimeMillis();
        this.clock.setCurrentTime(now);
        this.impl.probe(this.route);
        long max = this.connPerRoute.getMaxPerRoute(this.route);
        this.clock.setCurrentTime(now + 1L);
        this.impl.backOff(this.route);
        Assert.assertTrue(((long)this.connPerRoute.getMaxPerRoute(this.route) < max ? 1 : 0) != 0);
    }

    @Test
    public void backOffFactorIsConfigurable() {
        this.connPerRoute.setMaxPerRoute(this.route, 10);
        this.impl.setBackoffFactor(0.9);
        this.impl.backOff(this.route);
        Assert.assertEquals((long)9L, (long)this.connPerRoute.getMaxPerRoute(this.route));
    }

    @Test
    public void coolDownPeriodIsConfigurable() {
        long cd = new Random().nextLong() / 2L;
        if (cd < 0L) {
            cd *= -1L;
        }
        if (cd < 1L) {
            ++cd;
        }
        long now = System.currentTimeMillis();
        this.impl.setCoolDown(TimeValue.ofMilliseconds((long)cd));
        this.clock.setCurrentTime(now);
        this.impl.probe(this.route);
        int max0 = this.connPerRoute.getMaxPerRoute(this.route);
        this.clock.setCurrentTime(now);
        this.impl.probe(this.route);
        Assert.assertEquals((long)max0, (long)this.connPerRoute.getMaxPerRoute(this.route));
        this.clock.setCurrentTime(now + cd + 1L);
        this.impl.probe(this.route);
        Assert.assertTrue((max0 < this.connPerRoute.getMaxPerRoute(this.route) ? 1 : 0) != 0);
    }
}

