/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.classic;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import org.apache.hc.client5.http.AuthenticationStrategy;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.RouteInfo;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.ChallengeType;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.ExecChain;
import org.apache.hc.client5.http.classic.ExecRuntime;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.entity.EntityBuilder;
import org.apache.hc.client5.http.impl.TunnelRefusedException;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.auth.BasicScheme;
import org.apache.hc.client5.http.impl.classic.ConnectExec;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.message.BasicClassicHttpResponse;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestConnectExec {
    @Mock
    private ConnectionReuseStrategy reuseStrategy;
    @Mock
    private HttpProcessor proxyHttpProcessor;
    @Mock
    private AuthenticationStrategy proxyAuthStrategy;
    @Mock
    private ExecRuntime execRuntime;
    @Mock
    private ExecChain execChain;
    private ConnectExec exec;
    private HttpHost target;
    private HttpHost proxy;

    @Before
    public void setup() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.exec = new ConnectExec(this.reuseStrategy, this.proxyHttpProcessor, this.proxyAuthStrategy);
        this.target = new HttpHost("foo", 80);
        this.proxy = new HttpHost("bar", 8888);
    }

    @Test
    public void testExecAcquireConnection() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpClientContext context = new HttpClientContext();
        HttpGet request = new HttpGet("http://bar/test");
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(200, "OK");
        response.setEntity(EntityBuilder.create().setStream((InputStream)new ByteArrayInputStream(new byte[0])).build());
        context.setUserToken((Object)"Blah");
        Mockito.when((Object)this.execRuntime.isEndpointAcquired()).thenReturn((Object)false);
        Mockito.when((Object)this.execRuntime.execute((String)Mockito.eq((Object)"test"), (ClassicHttpRequest)Mockito.same((Object)request), (HttpClientContext)Mockito.any())).thenReturn((Object)response);
        Mockito.when((Object)this.reuseStrategy.keepAlive((HttpRequest)Mockito.same((Object)request), (HttpResponse)Mockito.same((Object)response), (HttpContext)Mockito.any())).thenReturn((Object)false);
        ExecChain.Scope scope = new ExecChain.Scope("test", route, (ClassicHttpRequest)request, this.execRuntime, context);
        this.exec.execute((ClassicHttpRequest)request, scope, this.execChain);
        ((ExecRuntime)Mockito.verify((Object)this.execRuntime)).acquireEndpoint("test", route, (Object)"Blah", context);
        ((ExecRuntime)Mockito.verify((Object)this.execRuntime)).connectEndpoint(context);
    }

    @Test
    public void testEstablishDirectRoute() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpClientContext context = new HttpClientContext();
        HttpGet request = new HttpGet("http://bar/test");
        ConnectionState connectionState = new ConnectionState();
        ((ExecRuntime)Mockito.doAnswer((Answer)connectionState.connectAnswer()).when((Object)this.execRuntime)).connectEndpoint((HttpClientContext)Mockito.any());
        Mockito.when((Object)this.execRuntime.isEndpointConnected()).thenAnswer(connectionState.isConnectedAnswer());
        ExecChain.Scope scope = new ExecChain.Scope("test", route, (ClassicHttpRequest)request, this.execRuntime, context);
        this.exec.execute((ClassicHttpRequest)request, scope, this.execChain);
        ((ExecRuntime)Mockito.verify((Object)this.execRuntime)).connectEndpoint(context);
        ((ExecRuntime)Mockito.verify((Object)this.execRuntime, (VerificationMode)Mockito.never())).execute(Mockito.anyString(), (ClassicHttpRequest)Mockito.any(), (HttpClientContext)Mockito.any());
    }

    @Test
    public void testEstablishRouteDirectProxy() throws Exception {
        HttpRoute route = new HttpRoute(this.target, null, this.proxy, false);
        HttpClientContext context = new HttpClientContext();
        HttpGet request = new HttpGet("http://bar/test");
        ConnectionState connectionState = new ConnectionState();
        ((ExecRuntime)Mockito.doAnswer((Answer)connectionState.connectAnswer()).when((Object)this.execRuntime)).connectEndpoint((HttpClientContext)Mockito.any());
        Mockito.when((Object)this.execRuntime.isEndpointConnected()).thenAnswer(connectionState.isConnectedAnswer());
        ExecChain.Scope scope = new ExecChain.Scope("test", route, (ClassicHttpRequest)request, this.execRuntime, context);
        this.exec.execute((ClassicHttpRequest)request, scope, this.execChain);
        ((ExecRuntime)Mockito.verify((Object)this.execRuntime)).connectEndpoint(context);
        ((ExecRuntime)Mockito.verify((Object)this.execRuntime, (VerificationMode)Mockito.never())).execute(Mockito.anyString(), (ClassicHttpRequest)Mockito.any(), (HttpClientContext)Mockito.any());
    }

    @Test
    public void testEstablishRouteViaProxyTunnel() throws Exception {
        HttpRoute route = new HttpRoute(this.target, null, this.proxy, true);
        HttpClientContext context = new HttpClientContext();
        HttpGet request = new HttpGet("http://bar/test");
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(200, "OK");
        ConnectionState connectionState = new ConnectionState();
        ((ExecRuntime)Mockito.doAnswer((Answer)connectionState.connectAnswer()).when((Object)this.execRuntime)).connectEndpoint((HttpClientContext)Mockito.any());
        Mockito.when((Object)this.execRuntime.isEndpointConnected()).thenAnswer(connectionState.isConnectedAnswer());
        Mockito.when((Object)this.execRuntime.execute(Mockito.anyString(), (ClassicHttpRequest)Mockito.any(), (HttpClientContext)Mockito.any())).thenReturn((Object)response);
        ExecChain.Scope scope = new ExecChain.Scope("test", route, (ClassicHttpRequest)request, this.execRuntime, context);
        this.exec.execute((ClassicHttpRequest)request, scope, this.execChain);
        ((ExecRuntime)Mockito.verify((Object)this.execRuntime)).connectEndpoint(context);
        ArgumentCaptor reqCaptor = ArgumentCaptor.forClass(ClassicHttpRequest.class);
        ((ExecRuntime)Mockito.verify((Object)this.execRuntime)).execute(Mockito.anyString(), (ClassicHttpRequest)reqCaptor.capture(), (HttpClientContext)Mockito.same((Object)context));
        HttpRequest connect = (HttpRequest)reqCaptor.getValue();
        Assert.assertNotNull((Object)connect);
        Assert.assertEquals((Object)"CONNECT", (Object)connect.getMethod());
        Assert.assertEquals((Object)HttpVersion.HTTP_1_1, (Object)connect.getVersion());
        Assert.assertEquals((Object)"foo:80", (Object)connect.getRequestUri());
    }

    @Test(expected=HttpException.class)
    public void testEstablishRouteViaProxyTunnelUnexpectedResponse() throws Exception {
        HttpRoute route = new HttpRoute(this.target, null, this.proxy, true);
        HttpClientContext context = new HttpClientContext();
        HttpGet request = new HttpGet("http://bar/test");
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(101, "Lost");
        ConnectionState connectionState = new ConnectionState();
        ((ExecRuntime)Mockito.doAnswer((Answer)connectionState.connectAnswer()).when((Object)this.execRuntime)).connectEndpoint((HttpClientContext)Mockito.any());
        Mockito.when((Object)this.execRuntime.isEndpointConnected()).thenAnswer(connectionState.isConnectedAnswer());
        Mockito.when((Object)this.execRuntime.execute(Mockito.anyString(), (ClassicHttpRequest)Mockito.any(), (HttpClientContext)Mockito.any())).thenReturn((Object)response);
        ExecChain.Scope scope = new ExecChain.Scope("test", route, (ClassicHttpRequest)request, this.execRuntime, context);
        this.exec.execute((ClassicHttpRequest)request, scope, this.execChain);
    }

    @Test(expected=HttpException.class)
    public void testEstablishRouteViaProxyTunnelFailure() throws Exception {
        HttpRoute route = new HttpRoute(this.target, null, this.proxy, true);
        HttpClientContext context = new HttpClientContext();
        HttpGet request = new HttpGet("http://bar/test");
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(500, "Boom");
        response.setEntity((HttpEntity)new StringEntity("Ka-boom"));
        ConnectionState connectionState = new ConnectionState();
        ((ExecRuntime)Mockito.doAnswer((Answer)connectionState.connectAnswer()).when((Object)this.execRuntime)).connectEndpoint((HttpClientContext)Mockito.any());
        Mockito.when((Object)this.execRuntime.isEndpointConnected()).thenAnswer(connectionState.isConnectedAnswer());
        Mockito.when((Object)this.execRuntime.execute(Mockito.anyString(), (ClassicHttpRequest)Mockito.any(), (HttpClientContext)Mockito.any())).thenReturn((Object)response);
        ExecChain.Scope scope = new ExecChain.Scope("test", route, (ClassicHttpRequest)request, this.execRuntime, context);
        try {
            this.exec.execute((ClassicHttpRequest)request, scope, this.execChain);
        }
        catch (TunnelRefusedException ex) {
            Assert.assertEquals((Object)"Ka-boom", (Object)ex.getResponseMessage());
            ((ExecRuntime)Mockito.verify((Object)this.execRuntime)).disconnectEndpoint();
            ((ExecRuntime)Mockito.verify((Object)this.execRuntime)).discardEndpoint();
            throw ex;
        }
    }

    @Test
    public void testEstablishRouteViaProxyTunnelRetryOnAuthChallengePersistentConnection() throws Exception {
        HttpRoute route = new HttpRoute(this.target, null, this.proxy, true);
        HttpClientContext context = new HttpClientContext();
        HttpGet request = new HttpGet("http://bar/test");
        BasicClassicHttpResponse response1 = new BasicClassicHttpResponse(407, "Huh?");
        response1.setHeader("Proxy-Authenticate", (Object)"Basic realm=test");
        InputStream inStream1 = (InputStream)Mockito.spy((Object)new ByteArrayInputStream(new byte[]{1, 2, 3}));
        response1.setEntity(EntityBuilder.create().setStream(inStream1).build());
        BasicClassicHttpResponse response2 = new BasicClassicHttpResponse(200, "OK");
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(new AuthScope(this.proxy), (Credentials)new UsernamePasswordCredentials("user", "pass".toCharArray()));
        context.setCredentialsProvider((CredentialsProvider)credentialsProvider);
        ConnectionState connectionState = new ConnectionState();
        ((ExecRuntime)Mockito.doAnswer((Answer)connectionState.connectAnswer()).when((Object)this.execRuntime)).connectEndpoint((HttpClientContext)Mockito.any());
        Mockito.when((Object)this.execRuntime.isEndpointConnected()).thenAnswer(connectionState.isConnectedAnswer());
        Mockito.when((Object)this.reuseStrategy.keepAlive((HttpRequest)Mockito.same((Object)request), (HttpResponse)Mockito.any(), (HttpContext)Mockito.any())).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.execRuntime.execute(Mockito.anyString(), (ClassicHttpRequest)Mockito.any(), (HttpClientContext)Mockito.any())).thenReturn((Object)response1, (Object[])new ClassicHttpResponse[]{response2});
        Mockito.when((Object)this.proxyAuthStrategy.select((ChallengeType)Mockito.eq((Object)ChallengeType.PROXY), (Map)Mockito.any(), (HttpContext)Mockito.any())).thenReturn(Collections.singletonList(new BasicScheme()));
        ExecChain.Scope scope = new ExecChain.Scope("test", route, (ClassicHttpRequest)request, this.execRuntime, context);
        this.exec.execute((ClassicHttpRequest)request, scope, this.execChain);
        ((ExecRuntime)Mockito.verify((Object)this.execRuntime)).connectEndpoint(context);
        ((InputStream)Mockito.verify((Object)inStream1)).close();
    }

    @Test
    public void testEstablishRouteViaProxyTunnelRetryOnAuthChallengeNonPersistentConnection() throws Exception {
        HttpRoute route = new HttpRoute(this.target, null, this.proxy, true);
        HttpClientContext context = new HttpClientContext();
        HttpGet request = new HttpGet("http://bar/test");
        BasicClassicHttpResponse response1 = new BasicClassicHttpResponse(407, "Huh?");
        response1.setHeader("Proxy-Authenticate", (Object)"Basic realm=test");
        InputStream inStream1 = (InputStream)Mockito.spy((Object)new ByteArrayInputStream(new byte[]{1, 2, 3}));
        response1.setEntity(EntityBuilder.create().setStream(inStream1).build());
        BasicClassicHttpResponse response2 = new BasicClassicHttpResponse(200, "OK");
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(new AuthScope(this.proxy), (Credentials)new UsernamePasswordCredentials("user", "pass".toCharArray()));
        context.setCredentialsProvider((CredentialsProvider)credentialsProvider);
        ConnectionState connectionState = new ConnectionState();
        ((ExecRuntime)Mockito.doAnswer((Answer)connectionState.connectAnswer()).when((Object)this.execRuntime)).connectEndpoint((HttpClientContext)Mockito.any());
        Mockito.when((Object)this.execRuntime.isEndpointConnected()).thenAnswer(connectionState.isConnectedAnswer());
        Mockito.when((Object)this.reuseStrategy.keepAlive((HttpRequest)Mockito.same((Object)request), (HttpResponse)Mockito.any(), (HttpContext)Mockito.any())).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)this.execRuntime.execute(Mockito.anyString(), (ClassicHttpRequest)Mockito.any(), (HttpClientContext)Mockito.any())).thenReturn((Object)response1, (Object[])new ClassicHttpResponse[]{response2});
        Mockito.when((Object)this.proxyAuthStrategy.select((ChallengeType)Mockito.eq((Object)ChallengeType.PROXY), (Map)Mockito.any(), (HttpContext)Mockito.any())).thenReturn(Collections.singletonList(new BasicScheme()));
        ExecChain.Scope scope = new ExecChain.Scope("test", route, (ClassicHttpRequest)request, this.execRuntime, context);
        this.exec.execute((ClassicHttpRequest)request, scope, this.execChain);
        ((ExecRuntime)Mockito.verify((Object)this.execRuntime)).connectEndpoint(context);
        ((InputStream)Mockito.verify((Object)inStream1, (VerificationMode)Mockito.never())).close();
        ((ExecRuntime)Mockito.verify((Object)this.execRuntime)).disconnectEndpoint();
    }

    @Test(expected=HttpException.class)
    public void testEstablishRouteViaProxyTunnelMultipleHops() throws Exception {
        HttpHost proxy1 = new HttpHost("this", 8888);
        HttpHost proxy2 = new HttpHost("that", 8888);
        HttpRoute route = new HttpRoute(this.target, null, new HttpHost[]{proxy1, proxy2}, true, RouteInfo.TunnelType.TUNNELLED, RouteInfo.LayerType.LAYERED);
        HttpClientContext context = new HttpClientContext();
        HttpGet request = new HttpGet("http://bar/test");
        ConnectionState connectionState = new ConnectionState();
        ((ExecRuntime)Mockito.doAnswer((Answer)connectionState.connectAnswer()).when((Object)this.execRuntime)).connectEndpoint((HttpClientContext)Mockito.any());
        Mockito.when((Object)this.execRuntime.isEndpointConnected()).thenAnswer(connectionState.isConnectedAnswer());
        ExecChain.Scope scope = new ExecChain.Scope("test", route, (ClassicHttpRequest)request, this.execRuntime, context);
        this.exec.execute((ClassicHttpRequest)request, scope, this.execChain);
    }

    static class ConnectionState {
        private boolean connected;

        ConnectionState() {
        }

        public Answer connectAnswer() {
            return new Answer(){

                public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                    ConnectionState.this.connected = true;
                    return null;
                }
            };
        }

        public Answer<Boolean> isConnectedAnswer() {
            return new Answer<Boolean>(){

                public Boolean answer(InvocationOnMock invocationOnMock) throws Throwable {
                    return ConnectionState.this.connected;
                }
            };
        }
    }
}

