/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.classic;

import java.io.IOException;
import org.apache.hc.client5.http.async.AsyncExecCallback;
import org.apache.hc.client5.http.async.AsyncExecChain;
import org.apache.hc.client5.http.async.AsyncExecChainHandler;
import org.apache.hc.client5.http.impl.async.HttpAsyncClients;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.junit.Test;

public class TestHttpAsyncClientBuilder {
    @Test
    public void testAddInterceptorFirstDoesNotThrow() throws IOException {
        HttpAsyncClients.custom().addExecInterceptorFirst("first", (AsyncExecChainHandler)NopExecChainHandler.INSTANCE).build().close();
    }

    @Test
    public void testAddInterceptorLastDoesNotThrow() throws IOException {
        HttpAsyncClients.custom().addExecInterceptorLast("last", (AsyncExecChainHandler)NopExecChainHandler.INSTANCE).build().close();
    }

    @Test
    public void testH2AddInterceptorFirstDoesNotThrow() throws IOException {
        HttpAsyncClients.customHttp2().addExecInterceptorFirst("first", (AsyncExecChainHandler)NopExecChainHandler.INSTANCE).build().close();
    }

    @Test
    public void testH2AddInterceptorLastDoesNotThrow() throws IOException {
        HttpAsyncClients.customHttp2().addExecInterceptorLast("last", (AsyncExecChainHandler)NopExecChainHandler.INSTANCE).build().close();
    }

    static enum NopExecChainHandler implements AsyncExecChainHandler
    {
        INSTANCE;


        public void execute(HttpRequest request, AsyncEntityProducer entityProducer, AsyncExecChain.Scope scope, AsyncExecChain chain, AsyncExecCallback asyncExecCallback) throws HttpException, IOException {
            chain.proceed(request, entityProducer, scope, asyncExecCallback);
        }
    }
}

