/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.classic;

import java.io.IOException;
import org.apache.hc.client5.http.classic.ExecChain;
import org.apache.hc.client5.http.classic.ExecChainHandler;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.impl.bootstrap.HttpServer;
import org.apache.hc.core5.http.impl.bootstrap.ServerBootstrap;
import org.apache.hc.core5.http.io.HttpRequestHandler;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.io.CloseMode;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestHttpClientBuilderInterceptors {
    private HttpServer localServer;
    private String uri;
    private CloseableHttpClient httpClient;

    @Before
    public void before() throws Exception {
        this.localServer = ServerBootstrap.bootstrap().register("/test", new HttpRequestHandler(){

            public void handle(ClassicHttpRequest request, ClassicHttpResponse response, HttpContext context) throws HttpException, IOException {
                Header testInterceptorHeader = request.getHeader("X-Test-Interceptor");
                if (testInterceptorHeader != null) {
                    response.setHeader(testInterceptorHeader);
                }
                response.setCode(200);
            }
        }).create();
        this.localServer.start();
        this.uri = "http://localhost:" + this.localServer.getLocalPort() + "/test";
        PoolingHttpClientConnectionManager cm = PoolingHttpClientConnectionManagerBuilder.create().setMaxConnPerRoute(5).build();
        this.httpClient = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)cm).addExecInterceptorLast("test-interceptor", new ExecChainHandler(){

            public ClassicHttpResponse execute(ClassicHttpRequest request, ExecChain.Scope scope, ExecChain chain) throws IOException, HttpException {
                request.setHeader("X-Test-Interceptor", (Object)"active");
                return chain.proceed(request, scope);
            }
        }).build();
    }

    @After
    public void after() throws Exception {
        this.httpClient.close(CloseMode.IMMEDIATE);
        this.localServer.stop();
    }

    @Test
    public void testAddExecInterceptorLastShouldBeExecuted() throws IOException, HttpException {
        HttpPost request = new HttpPost(this.uri);
        CloseableHttpResponse response = this.httpClient.execute((ClassicHttpRequest)request);
        Assert.assertEquals((long)200L, (long)response.getCode());
        Header testFilterHeader = response.getHeader("X-Test-Interceptor");
        Assert.assertNotNull((Object)testFilterHeader);
    }
}

