/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.classic;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import org.apache.hc.client5.http.ConnectionKeepAliveStrategy;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.UserTokenHandler;
import org.apache.hc.client5.http.classic.ExecChain;
import org.apache.hc.client5.http.classic.ExecRuntime;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.entity.EntityBuilder;
import org.apache.hc.client5.http.impl.ConnectionShutdownException;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.MainClientExec;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.message.BasicClassicHttpResponse;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.TimeValue;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestMainClientExec {
    @Mock
    private HttpClientConnectionManager connectionManager;
    @Mock
    private ConnectionReuseStrategy reuseStrategy;
    @Mock
    private ConnectionKeepAliveStrategy keepAliveStrategy;
    @Mock
    private UserTokenHandler userTokenHandler;
    @Mock
    private ExecRuntime endpoint;
    private MainClientExec mainClientExec;
    private HttpHost target;

    @Before
    public void setup() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.mainClientExec = new MainClientExec(this.connectionManager, this.reuseStrategy, this.keepAliveStrategy, this.userTokenHandler);
        this.target = new HttpHost("foo", 80);
    }

    @Test
    public void testExecRequestNonPersistentConnection() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpClientContext context = new HttpClientContext();
        HttpGet request = new HttpGet("http://bar/test");
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(200, "OK");
        response.setEntity(EntityBuilder.create().setStream((InputStream)new ByteArrayInputStream(new byte[0])).build());
        Mockito.when((Object)this.endpoint.isEndpointAcquired()).thenReturn((Object)false);
        Mockito.when((Object)this.endpoint.execute(Mockito.anyString(), (ClassicHttpRequest)Mockito.same((Object)request), (HttpClientContext)Mockito.any())).thenReturn((Object)response);
        Mockito.when((Object)this.reuseStrategy.keepAlive((HttpRequest)Mockito.same((Object)request), (HttpResponse)Mockito.same((Object)response), (HttpContext)Mockito.any())).thenReturn((Object)false);
        ExecChain.Scope scope = new ExecChain.Scope("test", route, (ClassicHttpRequest)request, this.endpoint, context);
        ClassicHttpResponse finalResponse = this.mainClientExec.execute((ClassicHttpRequest)request, scope, null);
        ((ExecRuntime)Mockito.verify((Object)this.endpoint)).execute("test", (ClassicHttpRequest)request, context);
        ((ExecRuntime)Mockito.verify((Object)this.endpoint, (VerificationMode)Mockito.times((int)1))).markConnectionNonReusable();
        ((ExecRuntime)Mockito.verify((Object)this.endpoint, (VerificationMode)Mockito.never())).releaseEndpoint();
        Assert.assertNull((Object)context.getUserToken());
        Assert.assertNotNull((Object)finalResponse);
        Assert.assertTrue((boolean)(finalResponse instanceof CloseableHttpResponse));
    }

    @Test
    public void testExecRequestNonPersistentConnectionNoResponseEntity() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpClientContext context = new HttpClientContext();
        HttpGet request = new HttpGet("http://bar/test");
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(200, "OK");
        response.setEntity(null);
        Mockito.when((Object)this.endpoint.isEndpointAcquired()).thenReturn((Object)false);
        Mockito.when((Object)this.endpoint.execute(Mockito.anyString(), (ClassicHttpRequest)Mockito.same((Object)request), (HttpClientContext)Mockito.any())).thenReturn((Object)response);
        Mockito.when((Object)this.reuseStrategy.keepAlive((HttpRequest)Mockito.same((Object)request), (HttpResponse)Mockito.same((Object)response), (HttpContext)Mockito.any())).thenReturn((Object)false);
        ExecChain.Scope scope = new ExecChain.Scope("test", route, (ClassicHttpRequest)request, this.endpoint, context);
        ClassicHttpResponse finalResponse = this.mainClientExec.execute((ClassicHttpRequest)request, scope, null);
        ((ExecRuntime)Mockito.verify((Object)this.endpoint)).execute("test", (ClassicHttpRequest)request, context);
        ((ExecRuntime)Mockito.verify((Object)this.endpoint)).markConnectionNonReusable();
        ((ExecRuntime)Mockito.verify((Object)this.endpoint)).releaseEndpoint();
        Assert.assertNotNull((Object)finalResponse);
        Assert.assertTrue((boolean)(finalResponse instanceof CloseableHttpResponse));
    }

    @Test
    public void testExecRequestPersistentConnection() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpClientContext context = new HttpClientContext();
        HttpGet request = new HttpGet("http://bar/test");
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(200, "OK");
        response.setEntity(EntityBuilder.create().setStream((InputStream)new ByteArrayInputStream(new byte[0])).build());
        ConnectionState connectionState = new ConnectionState();
        ((ExecRuntime)Mockito.doAnswer((Answer)connectionState.connectAnswer()).when((Object)this.endpoint)).connectEndpoint((HttpClientContext)Mockito.any());
        Mockito.when((Object)this.endpoint.isEndpointConnected()).thenAnswer(connectionState.isConnectedAnswer());
        Mockito.when((Object)this.endpoint.execute(Mockito.anyString(), (ClassicHttpRequest)Mockito.same((Object)request), (HttpClientContext)Mockito.any())).thenReturn((Object)response);
        Mockito.when((Object)this.reuseStrategy.keepAlive((HttpRequest)Mockito.same((Object)request), (HttpResponse)Mockito.same((Object)response), (HttpContext)Mockito.any())).thenReturn((Object)true);
        Mockito.when((Object)this.keepAliveStrategy.getKeepAliveDuration((HttpResponse)Mockito.same((Object)response), (HttpContext)Mockito.any())).thenReturn((Object)TimeValue.ofMilliseconds((long)678L));
        ExecChain.Scope scope = new ExecChain.Scope("test", route, (ClassicHttpRequest)request, this.endpoint, context);
        ClassicHttpResponse finalResponse = this.mainClientExec.execute((ClassicHttpRequest)request, scope, null);
        ((ExecRuntime)Mockito.verify((Object)this.endpoint)).execute("test", (ClassicHttpRequest)request, context);
        ((ExecRuntime)Mockito.verify((Object)this.endpoint)).markConnectionReusable(null, TimeValue.ofMilliseconds((long)678L));
        ((ExecRuntime)Mockito.verify((Object)this.endpoint, (VerificationMode)Mockito.never())).releaseEndpoint();
        Assert.assertNotNull((Object)finalResponse);
        Assert.assertTrue((boolean)(finalResponse instanceof CloseableHttpResponse));
    }

    @Test
    public void testExecRequestPersistentConnectionNoResponseEntity() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpClientContext context = new HttpClientContext();
        HttpGet request = new HttpGet("http://bar/test");
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(200, "OK");
        ConnectionState connectionState = new ConnectionState();
        ((ExecRuntime)Mockito.doAnswer((Answer)connectionState.connectAnswer()).when((Object)this.endpoint)).connectEndpoint((HttpClientContext)Mockito.any());
        Mockito.when((Object)this.endpoint.isEndpointConnected()).thenAnswer(connectionState.isConnectedAnswer());
        Mockito.when((Object)this.endpoint.execute(Mockito.anyString(), (ClassicHttpRequest)Mockito.same((Object)request), (HttpClientContext)Mockito.any())).thenReturn((Object)response);
        Mockito.when((Object)this.reuseStrategy.keepAlive((HttpRequest)Mockito.same((Object)request), (HttpResponse)Mockito.same((Object)response), (HttpContext)Mockito.any())).thenReturn((Object)true);
        Mockito.when((Object)this.keepAliveStrategy.getKeepAliveDuration((HttpResponse)Mockito.same((Object)response), (HttpContext)Mockito.any())).thenReturn((Object)TimeValue.ofMilliseconds((long)678L));
        ExecChain.Scope scope = new ExecChain.Scope("test", route, (ClassicHttpRequest)request, this.endpoint, context);
        ClassicHttpResponse finalResponse = this.mainClientExec.execute((ClassicHttpRequest)request, scope, null);
        ((ExecRuntime)Mockito.verify((Object)this.endpoint)).execute("test", (ClassicHttpRequest)request, context);
        ((ExecRuntime)Mockito.verify((Object)this.endpoint)).releaseEndpoint();
        Assert.assertNotNull((Object)finalResponse);
        Assert.assertTrue((boolean)(finalResponse instanceof CloseableHttpResponse));
    }

    @Test
    public void testExecRequestConnectionRelease() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpClientContext context = new HttpClientContext();
        HttpGet request = new HttpGet("http://bar/test");
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(200, "OK");
        response.setEntity(EntityBuilder.create().setStream((InputStream)new ByteArrayInputStream(new byte[0])).build());
        ConnectionState connectionState = new ConnectionState();
        ((ExecRuntime)Mockito.doAnswer((Answer)connectionState.connectAnswer()).when((Object)this.endpoint)).connectEndpoint((HttpClientContext)Mockito.any());
        Mockito.when((Object)this.endpoint.isEndpointConnected()).thenAnswer(connectionState.isConnectedAnswer());
        Mockito.when((Object)this.endpoint.execute(Mockito.anyString(), (ClassicHttpRequest)Mockito.same((Object)request), (HttpClientContext)Mockito.any())).thenReturn((Object)response);
        Mockito.when((Object)this.reuseStrategy.keepAlive((HttpRequest)Mockito.same((Object)request), (HttpResponse)Mockito.same((Object)response), (HttpContext)Mockito.any())).thenReturn((Object)Boolean.FALSE);
        ExecChain.Scope scope = new ExecChain.Scope("test", route, (ClassicHttpRequest)request, this.endpoint, context);
        ClassicHttpResponse finalResponse = this.mainClientExec.execute((ClassicHttpRequest)request, scope, null);
        ((ExecRuntime)Mockito.verify((Object)this.endpoint, (VerificationMode)Mockito.times((int)1))).execute("test", (ClassicHttpRequest)request, context);
        ((ExecRuntime)Mockito.verify((Object)this.endpoint, (VerificationMode)Mockito.never())).disconnectEndpoint();
        ((ExecRuntime)Mockito.verify((Object)this.endpoint, (VerificationMode)Mockito.never())).releaseEndpoint();
        Assert.assertNotNull((Object)finalResponse);
        Assert.assertTrue((boolean)(finalResponse instanceof CloseableHttpResponse));
        finalResponse.close();
        ((ExecRuntime)Mockito.verify((Object)this.endpoint)).disconnectEndpoint();
        ((ExecRuntime)Mockito.verify((Object)this.endpoint)).discardEndpoint();
    }

    @Test(expected=InterruptedIOException.class)
    public void testExecConnectionShutDown() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpClientContext context = new HttpClientContext();
        HttpGet request = new HttpGet("http://bar/test");
        Mockito.when((Object)this.endpoint.execute(Mockito.anyString(), (ClassicHttpRequest)Mockito.same((Object)request), (HttpClientContext)Mockito.any())).thenThrow(new Throwable[]{new ConnectionShutdownException()});
        ExecChain.Scope scope = new ExecChain.Scope("test", route, (ClassicHttpRequest)request, this.endpoint, context);
        try {
            this.mainClientExec.execute((ClassicHttpRequest)request, scope, null);
        }
        catch (Exception ex) {
            ((ExecRuntime)Mockito.verify((Object)this.endpoint)).discardEndpoint();
            throw ex;
        }
    }

    @Test(expected=RuntimeException.class)
    public void testExecRuntimeException() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpClientContext context = new HttpClientContext();
        HttpGet request = new HttpGet("http://bar/test");
        Mockito.when((Object)this.endpoint.execute(Mockito.anyString(), (ClassicHttpRequest)Mockito.same((Object)request), (HttpClientContext)Mockito.any())).thenThrow(new Throwable[]{new RuntimeException("Ka-boom")});
        ExecChain.Scope scope = new ExecChain.Scope("test", route, (ClassicHttpRequest)request, this.endpoint, context);
        try {
            this.mainClientExec.execute((ClassicHttpRequest)request, scope, null);
        }
        catch (Exception ex) {
            ((ExecRuntime)Mockito.verify((Object)this.endpoint)).discardEndpoint();
            throw ex;
        }
    }

    @Test(expected=HttpException.class)
    public void testExecHttpException() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpClientContext context = new HttpClientContext();
        HttpGet request = new HttpGet("http://bar/test");
        Mockito.when((Object)this.endpoint.execute(Mockito.anyString(), (ClassicHttpRequest)Mockito.same((Object)request), (HttpClientContext)Mockito.any())).thenThrow(new Throwable[]{new HttpException("Ka-boom")});
        ExecChain.Scope scope = new ExecChain.Scope("test", route, (ClassicHttpRequest)request, this.endpoint, context);
        try {
            this.mainClientExec.execute((ClassicHttpRequest)request, scope, null);
        }
        catch (Exception ex) {
            ((ExecRuntime)Mockito.verify((Object)this.endpoint)).discardEndpoint();
            throw ex;
        }
    }

    @Test(expected=IOException.class)
    public void testExecIOException() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpClientContext context = new HttpClientContext();
        HttpGet request = new HttpGet("http://bar/test");
        Mockito.when((Object)this.endpoint.execute(Mockito.anyString(), (ClassicHttpRequest)Mockito.same((Object)request), (HttpClientContext)Mockito.any())).thenThrow(new Throwable[]{new IOException("Ka-boom")});
        ExecChain.Scope scope = new ExecChain.Scope("test", route, (ClassicHttpRequest)request, this.endpoint, context);
        try {
            this.mainClientExec.execute((ClassicHttpRequest)request, scope, null);
        }
        catch (Exception ex) {
            ((ExecRuntime)Mockito.verify((Object)this.endpoint)).discardEndpoint();
            throw ex;
        }
    }

    static class ConnectionState {
        private boolean connected;

        ConnectionState() {
        }

        public Answer connectAnswer() {
            return new Answer(){

                public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                    ConnectionState.this.connected = true;
                    return null;
                }
            };
        }

        public Answer<Boolean> isConnectedAnswer() {
            return new Answer<Boolean>(){

                public Boolean answer(InvocationOnMock invocationOnMock) throws Throwable {
                    return ConnectionState.this.connected;
                }
            };
        }
    }
}

