/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cookie;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Calendar;
import java.util.List;
import org.apache.hc.client5.http.cookie.BasicCookieStore;
import org.apache.hc.client5.http.cookie.Cookie;
import org.apache.hc.client5.http.impl.cookie.BasicClientCookie;
import org.junit.Assert;
import org.junit.Test;

public class TestBasicCookieStore {
    @Test
    public void testBasics() throws Exception {
        BasicCookieStore store = new BasicCookieStore();
        store.addCookie((Cookie)new BasicClientCookie("name1", "value1"));
        store.addCookies((Cookie[])new BasicClientCookie[]{new BasicClientCookie("name2", "value2")});
        List list = store.getCookies();
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)"name1", (Object)((Cookie)list.get(0)).getName());
        Assert.assertEquals((Object)"name2", (Object)((Cookie)list.get(1)).getName());
        store.clear();
        list = store.getCookies();
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)0L, (long)list.size());
    }

    @Test
    public void testExpiredCookie() throws Exception {
        BasicCookieStore store = new BasicCookieStore();
        BasicClientCookie cookie = new BasicClientCookie("name1", "value1");
        Calendar c = Calendar.getInstance();
        c.add(6, -10);
        cookie.setExpiryDate(c.getTime());
        store.addCookie((Cookie)cookie);
        List list = store.getCookies();
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)0L, (long)list.size());
    }

    @Test
    public void testSerialization() throws Exception {
        BasicCookieStore orig = new BasicCookieStore();
        orig.addCookie((Cookie)new BasicClientCookie("name1", "value1"));
        orig.addCookie((Cookie)new BasicClientCookie("name2", "value2"));
        ByteArrayOutputStream outbuffer = new ByteArrayOutputStream();
        ObjectOutputStream outStream = new ObjectOutputStream(outbuffer);
        outStream.writeObject(orig);
        outStream.close();
        byte[] raw = outbuffer.toByteArray();
        ByteArrayInputStream inBuffer = new ByteArrayInputStream(raw);
        ObjectInputStream inStream = new ObjectInputStream(inBuffer);
        BasicCookieStore clone = (BasicCookieStore)inStream.readObject();
        List expected = orig.getCookies();
        List clones = clone.getCookies();
        Assert.assertNotNull((Object)expected);
        Assert.assertNotNull((Object)clones);
        Assert.assertEquals((long)expected.size(), (long)clones.size());
        for (int i = 0; i < expected.size(); ++i) {
            Assert.assertEquals((Object)((Cookie)expected.get(i)).getName(), (Object)((Cookie)clones.get(i)).getName());
            Assert.assertEquals((Object)((Cookie)expected.get(i)).getValue(), (Object)((Cookie)clones.get(i)).getValue());
        }
    }
}

