/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cookie;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import org.apache.hc.client5.http.cookie.CommonCookieAttributeHandler;
import org.apache.hc.client5.http.cookie.Cookie;
import org.apache.hc.client5.http.cookie.CookieOrigin;
import org.apache.hc.client5.http.impl.cookie.BasicClientCookie;
import org.apache.hc.client5.http.impl.cookie.BasicDomainHandler;
import org.apache.hc.client5.http.impl.cookie.PublicSuffixDomainFilter;
import org.apache.hc.client5.http.psl.PublicSuffixList;
import org.apache.hc.client5.http.psl.PublicSuffixListParser;
import org.apache.hc.client5.http.psl.PublicSuffixMatcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestPublicSuffixListParser {
    private static final String SOURCE_FILE = "suffixlist.txt";
    private PublicSuffixDomainFilter filter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void setUp() throws Exception {
        PublicSuffixList suffixList;
        ClassLoader classLoader = this.getClass().getClassLoader();
        Assert.assertNotNull((Object)in);
        try (InputStream in = classLoader.getResourceAsStream(SOURCE_FILE);){
            PublicSuffixListParser parser = new PublicSuffixListParser();
            suffixList = parser.parse((Reader)new InputStreamReader(in, StandardCharsets.UTF_8));
        }
        PublicSuffixMatcher matcher = new PublicSuffixMatcher((Collection)suffixList.getRules(), (Collection)suffixList.getExceptions());
        this.filter = new PublicSuffixDomainFilter((CommonCookieAttributeHandler)new BasicDomainHandler(), matcher);
    }

    @Test
    public void testParse() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        cookie.setAttribute("domain", ".jp");
        cookie.setDomain(".jp");
        Assert.assertFalse((boolean)this.filter.match((Cookie)cookie, new CookieOrigin("apache.jp", 80, "/stuff", false)));
        cookie.setDomain(".ac.jp");
        Assert.assertFalse((boolean)this.filter.match((Cookie)cookie, new CookieOrigin("apache.ac.jp", 80, "/stuff", false)));
        cookie.setDomain(".any.tokyo.jp");
        Assert.assertFalse((boolean)this.filter.match((Cookie)cookie, new CookieOrigin("apache.any.tokyo.jp", 80, "/stuff", false)));
        cookie.setDomain(".metro.tokyo.jp");
        Assert.assertTrue((boolean)this.filter.match((Cookie)cookie, new CookieOrigin("apache.metro.tokyo.jp", 80, "/stuff", false)));
    }

    @Test
    public void testParseLocal() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        cookie.setDomain("localhost");
        cookie.setAttribute("domain", "localhost");
        Assert.assertTrue((boolean)this.filter.match((Cookie)cookie, new CookieOrigin("localhost", 80, "/stuff", false)));
        cookie.setDomain("somehost");
        cookie.setAttribute("domain", "somehost");
        Assert.assertTrue((boolean)this.filter.match((Cookie)cookie, new CookieOrigin("somehost", 80, "/stuff", false)));
        cookie.setDomain(".localdomain");
        cookie.setAttribute("domain", ".localdomain");
        Assert.assertTrue((boolean)this.filter.match((Cookie)cookie, new CookieOrigin("somehost.localdomain", 80, "/stuff", false)));
        cookie.setDomain(".local.");
        cookie.setAttribute("domain", ".local.");
        Assert.assertTrue((boolean)this.filter.match((Cookie)cookie, new CookieOrigin("somehost.local.", 80, "/stuff", false)));
        cookie.setDomain(".localhost.");
        cookie.setAttribute("domain", ".localhost.");
        Assert.assertTrue((boolean)this.filter.match((Cookie)cookie, new CookieOrigin("somehost.localhost.", 80, "/stuff", false)));
        cookie.setDomain(".local");
        cookie.setAttribute("domain", ".local");
        Assert.assertTrue((boolean)this.filter.match((Cookie)cookie, new CookieOrigin("somehost.local", 80, "/stuff", false)));
        cookie.setDomain(".blah");
        cookie.setAttribute("domain", ".blah");
        Assert.assertTrue((boolean)this.filter.match((Cookie)cookie, new CookieOrigin("somehost.blah", 80, "/stuff", false)));
    }

    @Test
    public void testUnicode() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        cookie.setDomain(".h\u00e5.no");
        Assert.assertFalse((boolean)this.filter.match((Cookie)cookie, new CookieOrigin("apache.h\u00e5.no", 80, "/stuff", false)));
        cookie.setDomain(".xn--h-2fa.no");
        Assert.assertFalse((boolean)this.filter.match((Cookie)cookie, new CookieOrigin("apache.xn--h-2fa.no", 80, "/stuff", false)));
        cookie.setDomain(".h\u00e5.no");
        Assert.assertFalse((boolean)this.filter.match((Cookie)cookie, new CookieOrigin("apache.xn--h-2fa.no", 80, "/stuff", false)));
        cookie.setDomain(".xn--h-2fa.no");
        Assert.assertFalse((boolean)this.filter.match((Cookie)cookie, new CookieOrigin("apache.h\u00e5.no", 80, "/stuff", false)));
    }
}

