/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cookie;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hc.client5.http.cookie.CommonCookieAttributeHandler;
import org.apache.hc.client5.http.cookie.Cookie;
import org.apache.hc.client5.http.cookie.CookieOrigin;
import org.apache.hc.client5.http.cookie.MalformedCookieException;
import org.apache.hc.client5.http.cookie.SetCookie;
import org.apache.hc.client5.http.impl.cookie.BasicClientCookie;
import org.apache.hc.client5.http.impl.cookie.RFC6265CookieSpec;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.message.BasicHeader;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestRFC6265CookieSpec {
    @Test
    public void testParseCookieBasics() throws Exception {
        CommonCookieAttributeHandler h1 = (CommonCookieAttributeHandler)Mockito.mock(CommonCookieAttributeHandler.class);
        Mockito.when((Object)h1.getAttributeName()).thenReturn((Object)"this");
        CommonCookieAttributeHandler h2 = (CommonCookieAttributeHandler)Mockito.mock(CommonCookieAttributeHandler.class);
        Mockito.when((Object)h2.getAttributeName()).thenReturn((Object)"that");
        RFC6265CookieSpec cookiespec = new RFC6265CookieSpec(new CommonCookieAttributeHandler[]{h1, h2});
        BasicHeader header = new BasicHeader("Set-Cookie", (Object)"name = value ; this = stuff;");
        CookieOrigin origin = new CookieOrigin("host", 80, "/path/", true);
        List cookies = cookiespec.parse((Header)header, origin);
        Assert.assertEquals((long)1L, (long)cookies.size());
        Cookie cookie = (Cookie)cookies.get(0);
        Assert.assertEquals((Object)"name", (Object)cookie.getName());
        Assert.assertEquals((Object)"value", (Object)cookie.getValue());
        Assert.assertEquals((Object)"/path", (Object)cookie.getPath());
        Assert.assertEquals((Object)"host", (Object)cookie.getDomain());
        Assert.assertEquals((Object)"stuff", (Object)cookie.getAttribute("this"));
        Assert.assertEquals(null, (Object)cookie.getAttribute("that"));
        ((CommonCookieAttributeHandler)Mockito.verify((Object)h1)).parse((SetCookie)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"stuff"));
        ((CommonCookieAttributeHandler)Mockito.verify((Object)h2, (VerificationMode)Mockito.never())).parse((SetCookie)ArgumentMatchers.any(), ArgumentMatchers.anyString());
    }

    @Test
    public void testParseCookieQuotedValue() throws Exception {
        RFC6265CookieSpec cookiespec = new RFC6265CookieSpec(new CommonCookieAttributeHandler[0]);
        BasicHeader header = new BasicHeader("Set-Cookie", (Object)"name = \" one, two, three; four \" ; this = stuff;");
        CookieOrigin origin = new CookieOrigin("host", 80, "/path/", true);
        List cookies = cookiespec.parse((Header)header, origin);
        Assert.assertEquals((long)1L, (long)cookies.size());
        Cookie cookie = (Cookie)cookies.get(0);
        Assert.assertEquals((Object)"name", (Object)cookie.getName());
        Assert.assertEquals((Object)" one, two, three; four ", (Object)cookie.getValue());
        Assert.assertEquals((Object)"stuff", (Object)cookie.getAttribute("this"));
    }

    @Test(expected=MalformedCookieException.class)
    public void testParseCookieWrongHeader() throws Exception {
        RFC6265CookieSpec cookiespec = new RFC6265CookieSpec(new CommonCookieAttributeHandler[0]);
        BasicHeader header = new BasicHeader("Set-Cookie2", (Object)"blah");
        CookieOrigin origin = new CookieOrigin("host", 80, "/path/", true);
        cookiespec.parse((Header)header, origin);
    }

    @Test
    public void testParseCookieMissingName() throws Exception {
        RFC6265CookieSpec cookiespec = new RFC6265CookieSpec(new CommonCookieAttributeHandler[0]);
        BasicHeader header = new BasicHeader("Set-Cookie", (Object)"=blah ; this = stuff;");
        CookieOrigin origin = new CookieOrigin("host", 80, "/path/", true);
        List cookies = cookiespec.parse((Header)header, origin);
        Assert.assertEquals((long)0L, (long)cookies.size());
    }

    @Test
    public void testParseCookieMissingValue1() throws Exception {
        RFC6265CookieSpec cookiespec = new RFC6265CookieSpec(new CommonCookieAttributeHandler[0]);
        BasicHeader header = new BasicHeader("Set-Cookie", (Object)"blah");
        CookieOrigin origin = new CookieOrigin("host", 80, "/path/", true);
        List cookies = cookiespec.parse((Header)header, origin);
        Assert.assertEquals((long)0L, (long)cookies.size());
    }

    @Test(expected=MalformedCookieException.class)
    public void testParseCookieMissingValue2() throws Exception {
        RFC6265CookieSpec cookiespec = new RFC6265CookieSpec(new CommonCookieAttributeHandler[0]);
        BasicHeader header = new BasicHeader("Set-Cookie", (Object)"blah;");
        CookieOrigin origin = new CookieOrigin("host", 80, "/path/", true);
        cookiespec.parse((Header)header, origin);
    }

    @Test
    public void testParseCookieEmptyValue() throws Exception {
        RFC6265CookieSpec cookiespec = new RFC6265CookieSpec(new CommonCookieAttributeHandler[0]);
        BasicHeader header = new BasicHeader("Set-Cookie", (Object)"blah=;");
        CookieOrigin origin = new CookieOrigin("host", 80, "/path/", true);
        List cookies = cookiespec.parse((Header)header, origin);
        Assert.assertEquals((long)1L, (long)cookies.size());
        Cookie cookie = (Cookie)cookies.get(0);
        Assert.assertEquals((Object)"blah", (Object)cookie.getName());
        Assert.assertEquals((Object)"", (Object)cookie.getValue());
    }

    @Test
    public void testParseCookieWithAttributes() throws Exception {
        CommonCookieAttributeHandler h1 = (CommonCookieAttributeHandler)Mockito.mock(CommonCookieAttributeHandler.class);
        Mockito.when((Object)h1.getAttributeName()).thenReturn((Object)"this");
        CommonCookieAttributeHandler h2 = (CommonCookieAttributeHandler)Mockito.mock(CommonCookieAttributeHandler.class);
        Mockito.when((Object)h2.getAttributeName()).thenReturn((Object)"that");
        RFC6265CookieSpec cookiespec = new RFC6265CookieSpec(new CommonCookieAttributeHandler[]{h1, h2});
        BasicHeader header = new BasicHeader("Set-Cookie", (Object)"name = value ; p1 = v ; p2 = v,0; p3 ; p4");
        CookieOrigin origin = new CookieOrigin("host", 80, "/path/", true);
        List cookies = cookiespec.parse((Header)header, origin);
        Assert.assertEquals((long)1L, (long)cookies.size());
        Cookie cookie = (Cookie)cookies.get(0);
        Assert.assertEquals((Object)"name", (Object)cookie.getName());
        Assert.assertEquals((Object)"value", (Object)cookie.getValue());
        Assert.assertEquals((Object)"v", (Object)cookie.getAttribute("p1"));
        Assert.assertEquals((Object)"v,0", (Object)cookie.getAttribute("p2"));
        Assert.assertTrue((boolean)cookie.containsAttribute("p3"));
        Assert.assertTrue((boolean)cookie.containsAttribute("p4"));
        Assert.assertFalse((boolean)cookie.containsAttribute("p5"));
    }

    @Test
    public void testParseCookieWithAttributes2() throws Exception {
        CommonCookieAttributeHandler h1 = (CommonCookieAttributeHandler)Mockito.mock(CommonCookieAttributeHandler.class);
        Mockito.when((Object)h1.getAttributeName()).thenReturn((Object)"this");
        CommonCookieAttributeHandler h2 = (CommonCookieAttributeHandler)Mockito.mock(CommonCookieAttributeHandler.class);
        Mockito.when((Object)h2.getAttributeName()).thenReturn((Object)"that");
        RFC6265CookieSpec cookiespec = new RFC6265CookieSpec(new CommonCookieAttributeHandler[]{h1, h2});
        BasicHeader header = new BasicHeader("Set-Cookie", (Object)"name = value ; p1 = v");
        CookieOrigin origin = new CookieOrigin("host", 80, "/path/", true);
        List cookies = cookiespec.parse((Header)header, origin);
        Assert.assertEquals((long)1L, (long)cookies.size());
        Cookie cookie = (Cookie)cookies.get(0);
        Assert.assertEquals((Object)"name", (Object)cookie.getName());
        Assert.assertEquals((Object)"value", (Object)cookie.getValue());
        Assert.assertEquals((Object)"v", (Object)cookie.getAttribute("p1"));
    }

    @Test
    public void testParseCookieWithAttributes3() throws Exception {
        CommonCookieAttributeHandler h1 = (CommonCookieAttributeHandler)Mockito.mock(CommonCookieAttributeHandler.class);
        Mockito.when((Object)h1.getAttributeName()).thenReturn((Object)"this");
        CommonCookieAttributeHandler h2 = (CommonCookieAttributeHandler)Mockito.mock(CommonCookieAttributeHandler.class);
        Mockito.when((Object)h2.getAttributeName()).thenReturn((Object)"that");
        RFC6265CookieSpec cookiespec = new RFC6265CookieSpec(new CommonCookieAttributeHandler[]{h1, h2});
        BasicHeader header = new BasicHeader("Set-Cookie", (Object)"name = value ; p1 =");
        CookieOrigin origin = new CookieOrigin("host", 80, "/path/", true);
        List cookies = cookiespec.parse((Header)header, origin);
        Assert.assertEquals((long)1L, (long)cookies.size());
        Cookie cookie = (Cookie)cookies.get(0);
        Assert.assertEquals((Object)"name", (Object)cookie.getName());
        Assert.assertEquals((Object)"value", (Object)cookie.getValue());
        Assert.assertEquals((Object)"", (Object)cookie.getAttribute("p1"));
    }

    @Test
    public void testValidateCookieBasics() throws Exception {
        CommonCookieAttributeHandler h1 = (CommonCookieAttributeHandler)Mockito.mock(CommonCookieAttributeHandler.class);
        Mockito.when((Object)h1.getAttributeName()).thenReturn((Object)"this");
        CommonCookieAttributeHandler h2 = (CommonCookieAttributeHandler)Mockito.mock(CommonCookieAttributeHandler.class);
        Mockito.when((Object)h2.getAttributeName()).thenReturn((Object)"that");
        RFC6265CookieSpec cookiespec = new RFC6265CookieSpec(new CommonCookieAttributeHandler[]{h1, h2});
        CookieOrigin origin = new CookieOrigin("host", 80, "/path/", true);
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        cookiespec.validate((Cookie)cookie, origin);
        ((CommonCookieAttributeHandler)Mockito.verify((Object)h1)).validate((Cookie)cookie, origin);
        ((CommonCookieAttributeHandler)Mockito.verify((Object)h2)).validate((Cookie)cookie, origin);
    }

    @Test
    public void testMatchCookie() throws Exception {
        CommonCookieAttributeHandler h1 = (CommonCookieAttributeHandler)Mockito.mock(CommonCookieAttributeHandler.class);
        Mockito.when((Object)h1.getAttributeName()).thenReturn((Object)"this");
        CommonCookieAttributeHandler h2 = (CommonCookieAttributeHandler)Mockito.mock(CommonCookieAttributeHandler.class);
        Mockito.when((Object)h2.getAttributeName()).thenReturn((Object)"that");
        RFC6265CookieSpec cookiespec = new RFC6265CookieSpec(new CommonCookieAttributeHandler[]{h1, h2});
        CookieOrigin origin = new CookieOrigin("host", 80, "/path/", true);
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        Mockito.when((Object)h1.match((Cookie)cookie, origin)).thenReturn((Object)true);
        Mockito.when((Object)h2.match((Cookie)cookie, origin)).thenReturn((Object)true);
        Assert.assertTrue((boolean)cookiespec.match((Cookie)cookie, origin));
        ((CommonCookieAttributeHandler)Mockito.verify((Object)h1)).match((Cookie)cookie, origin);
        ((CommonCookieAttributeHandler)Mockito.verify((Object)h2)).match((Cookie)cookie, origin);
    }

    @Test
    public void testMatchCookieNoMatch() throws Exception {
        CommonCookieAttributeHandler h1 = (CommonCookieAttributeHandler)Mockito.mock(CommonCookieAttributeHandler.class);
        Mockito.when((Object)h1.getAttributeName()).thenReturn((Object)"this");
        CommonCookieAttributeHandler h2 = (CommonCookieAttributeHandler)Mockito.mock(CommonCookieAttributeHandler.class);
        Mockito.when((Object)h2.getAttributeName()).thenReturn((Object)"that");
        RFC6265CookieSpec cookiespec = new RFC6265CookieSpec(new CommonCookieAttributeHandler[]{h1, h2});
        CookieOrigin origin = new CookieOrigin("host", 80, "/path/", true);
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        Mockito.when((Object)h1.match((Cookie)cookie, origin)).thenReturn((Object)false);
        Mockito.when((Object)h2.match((Cookie)cookie, origin)).thenReturn((Object)false);
        Assert.assertFalse((boolean)cookiespec.match((Cookie)cookie, origin));
        ((CommonCookieAttributeHandler)Mockito.verify((Object)h1)).match((Cookie)cookie, origin);
        ((CommonCookieAttributeHandler)Mockito.verify((Object)h2, (VerificationMode)Mockito.never())).match((Cookie)cookie, origin);
    }

    @Test
    public void testFormatCookiesBasics() throws Exception {
        BasicClientCookie cookie1 = new BasicClientCookie("name1", "value");
        RFC6265CookieSpec cookiespec = new RFC6265CookieSpec(new CommonCookieAttributeHandler[0]);
        List headers = cookiespec.formatCookies(Collections.singletonList(cookie1));
        Assert.assertNotNull((Object)headers);
        Assert.assertEquals((long)1L, (long)headers.size());
        Header header = (Header)headers.get(0);
        Assert.assertEquals((Object)"Cookie", (Object)header.getName());
        Assert.assertEquals((Object)"name1=value", (Object)header.getValue());
    }

    @Test
    public void testFormatCookiesIllegalCharsInValue() throws Exception {
        BasicClientCookie cookie1 = new BasicClientCookie("name1", "value");
        BasicClientCookie cookie2 = new BasicClientCookie("name2", "some value");
        BasicClientCookie cookie3 = new BasicClientCookie("name3", "\"\\\"");
        RFC6265CookieSpec cookiespec = new RFC6265CookieSpec(new CommonCookieAttributeHandler[0]);
        List headers = cookiespec.formatCookies(Arrays.asList(cookie1, cookie2, cookie3));
        Assert.assertNotNull((Object)headers);
        Assert.assertEquals((long)1L, (long)headers.size());
        Header header = (Header)headers.get(0);
        Assert.assertEquals((Object)"Cookie", (Object)header.getName());
        Assert.assertEquals((Object)"name1=value; name2=\"some value\"; name3=\"\\\"\\\\\\\"\"", (Object)header.getValue());
    }

    @Test
    public void testParseCookieMultipleAttributes() throws Exception {
        CommonCookieAttributeHandler h1 = (CommonCookieAttributeHandler)Mockito.mock(CommonCookieAttributeHandler.class);
        Mockito.when((Object)h1.getAttributeName()).thenReturn((Object)"this");
        RFC6265CookieSpec cookiespec = new RFC6265CookieSpec(new CommonCookieAttributeHandler[]{h1});
        BasicHeader header = new BasicHeader("Set-Cookie", (Object)"name = value ; this = stuff; this = morestuff;");
        CookieOrigin origin = new CookieOrigin("host", 80, "/path/", true);
        cookiespec.parse((Header)header, origin);
        ((CommonCookieAttributeHandler)Mockito.verify((Object)h1)).parse((SetCookie)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"morestuff"));
        ((CommonCookieAttributeHandler)Mockito.verify((Object)h1, (VerificationMode)Mockito.times((int)1))).parse((SetCookie)ArgumentMatchers.any(), ArgumentMatchers.anyString());
    }

    @Test
    public void testParseCookieMaxAgeOverExpires() throws Exception {
        CommonCookieAttributeHandler h1 = (CommonCookieAttributeHandler)Mockito.mock(CommonCookieAttributeHandler.class);
        Mockito.when((Object)h1.getAttributeName()).thenReturn((Object)"Expires");
        CommonCookieAttributeHandler h2 = (CommonCookieAttributeHandler)Mockito.mock(CommonCookieAttributeHandler.class);
        Mockito.when((Object)h2.getAttributeName()).thenReturn((Object)"Max-Age");
        RFC6265CookieSpec cookiespec = new RFC6265CookieSpec(new CommonCookieAttributeHandler[]{h1, h2});
        BasicHeader header = new BasicHeader("Set-Cookie", (Object)"name = value ; expires = stuff; max-age = otherstuff;");
        CookieOrigin origin = new CookieOrigin("host", 80, "/path/", true);
        cookiespec.parse((Header)header, origin);
        ((CommonCookieAttributeHandler)Mockito.verify((Object)h1, (VerificationMode)Mockito.never())).parse((SetCookie)ArgumentMatchers.any(), ArgumentMatchers.anyString());
        ((CommonCookieAttributeHandler)Mockito.verify((Object)h2)).parse((SetCookie)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"otherstuff"));
    }
}

