/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.io;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.apache.hc.client5.http.DnsResolver;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.impl.io.BasicHttpClientConnectionManager;
import org.apache.hc.client5.http.io.ConnectionEndpoint;
import org.apache.hc.client5.http.io.LeaseRequest;
import org.apache.hc.client5.http.io.ManagedHttpClientConnection;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.socket.ConnectionSocketFactory;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.config.Lookup;
import org.apache.hc.core5.http.io.HttpConnectionFactory;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class TestBasicHttpClientConnectionManager {
    @Mock
    private ManagedHttpClientConnection conn;
    @Mock
    private HttpConnectionFactory<ManagedHttpClientConnection> connFactory;
    @Mock
    private Lookup<ConnectionSocketFactory> socketFactoryRegistry;
    @Mock
    private ConnectionSocketFactory plainSocketFactory;
    @Mock
    private LayeredConnectionSocketFactory sslSocketFactory;
    @Mock
    private Socket socket;
    @Mock
    private SchemePortResolver schemePortResolver;
    @Mock
    private DnsResolver dnsResolver;
    private BasicHttpClientConnectionManager mgr;

    @Before
    public void setup() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.mgr = new BasicHttpClientConnectionManager(this.socketFactoryRegistry, this.connFactory, this.schemePortResolver, this.dnsResolver);
    }

    @Test
    public void testLeaseReleaseNonReusable() throws Exception {
        HttpHost target = new HttpHost("localhost", 80);
        HttpRoute route = new HttpRoute(target);
        Mockito.when((Object)this.connFactory.createConnection((Socket)Mockito.any())).thenReturn((Object)this.conn);
        LeaseRequest connRequest1 = this.mgr.lease("some-id", route, null);
        ConnectionEndpoint endpoint1 = connRequest1.get(Timeout.ZERO_MILLISECONDS);
        Assert.assertNotNull((Object)endpoint1);
        Assert.assertFalse((boolean)endpoint1.isConnected());
        this.mgr.release(endpoint1, null, TimeValue.ofMilliseconds((long)100L));
        Assert.assertNull((Object)this.mgr.getRoute());
        Assert.assertNull((Object)this.mgr.getState());
        LeaseRequest connRequest2 = this.mgr.lease("some-id", route, null);
        ConnectionEndpoint conn2 = connRequest2.get(Timeout.ZERO_MILLISECONDS);
        Assert.assertNotNull((Object)conn2);
        Assert.assertFalse((boolean)conn2.isConnected());
        ((HttpConnectionFactory)Mockito.verify(this.connFactory, (VerificationMode)Mockito.times((int)2))).createConnection((Socket)Mockito.any());
    }

    @Test
    public void testLeaseReleaseReusable() throws Exception {
        HttpHost target = new HttpHost("somehost", 80);
        HttpRoute route = new HttpRoute(target);
        Mockito.when((Object)this.connFactory.createConnection((Socket)Mockito.any())).thenReturn((Object)this.conn);
        LeaseRequest connRequest1 = this.mgr.lease("some-id", route, null);
        ConnectionEndpoint endpoint1 = connRequest1.get(Timeout.ZERO_MILLISECONDS);
        Assert.assertNotNull((Object)endpoint1);
        ((HttpConnectionFactory)Mockito.verify(this.connFactory, (VerificationMode)Mockito.times((int)1))).createConnection((Socket)Mockito.any());
        Mockito.when((Object)this.conn.isOpen()).thenReturn((Object)Boolean.TRUE);
        this.mgr.release(endpoint1, null, TimeValue.ofMilliseconds((long)100L));
        Assert.assertEquals((Object)route, (Object)this.mgr.getRoute());
        Assert.assertEquals(null, (Object)this.mgr.getState());
        LeaseRequest connRequest2 = this.mgr.lease("some-id", route, null);
        ConnectionEndpoint conn2 = connRequest2.get(Timeout.ZERO_MILLISECONDS);
        Assert.assertNotNull((Object)conn2);
        Assert.assertTrue((boolean)conn2.isConnected());
        ((HttpConnectionFactory)Mockito.verify(this.connFactory, (VerificationMode)Mockito.times((int)1))).createConnection((Socket)Mockito.any());
    }

    @Test
    public void testLeaseReleaseReusableWithState() throws Exception {
        HttpHost target = new HttpHost("somehost", 80);
        HttpRoute route = new HttpRoute(target);
        Mockito.when((Object)this.connFactory.createConnection((Socket)Mockito.any())).thenReturn((Object)this.conn);
        LeaseRequest connRequest1 = this.mgr.lease("some-id", route, (Object)"some state");
        ConnectionEndpoint endpoint1 = connRequest1.get(Timeout.ZERO_MILLISECONDS);
        Assert.assertNotNull((Object)endpoint1);
        ((HttpConnectionFactory)Mockito.verify(this.connFactory, (VerificationMode)Mockito.times((int)1))).createConnection((Socket)Mockito.any());
        Mockito.when((Object)this.conn.isOpen()).thenReturn((Object)Boolean.TRUE);
        this.mgr.release(endpoint1, (Object)"some other state", TimeValue.ofMilliseconds((long)10000L));
        Assert.assertEquals((Object)route, (Object)this.mgr.getRoute());
        Assert.assertEquals((Object)"some other state", (Object)this.mgr.getState());
        LeaseRequest connRequest2 = this.mgr.lease("some-id", route, (Object)"some other state");
        ConnectionEndpoint conn2 = connRequest2.get(Timeout.ZERO_MILLISECONDS);
        Assert.assertNotNull((Object)conn2);
        Assert.assertTrue((boolean)conn2.isConnected());
        ((HttpConnectionFactory)Mockito.verify(this.connFactory, (VerificationMode)Mockito.times((int)1))).createConnection((Socket)Mockito.any());
    }

    @Test
    public void testLeaseDifferentRoute() throws Exception {
        HttpHost target1 = new HttpHost("somehost", 80);
        HttpRoute route1 = new HttpRoute(target1);
        Mockito.when((Object)this.connFactory.createConnection((Socket)Mockito.any())).thenReturn((Object)this.conn);
        LeaseRequest connRequest1 = this.mgr.lease("some-id", route1, null);
        ConnectionEndpoint endpoint1 = connRequest1.get(Timeout.ZERO_MILLISECONDS);
        Assert.assertNotNull((Object)endpoint1);
        ((HttpConnectionFactory)Mockito.verify(this.connFactory, (VerificationMode)Mockito.times((int)1))).createConnection((Socket)Mockito.any());
        Mockito.when((Object)this.conn.isOpen()).thenReturn((Object)Boolean.TRUE, (Object[])new Boolean[]{Boolean.FALSE});
        this.mgr.release(endpoint1, null, TimeValue.NEG_ONE_MILLISECOND);
        Assert.assertEquals((Object)route1, (Object)this.mgr.getRoute());
        Assert.assertEquals(null, (Object)this.mgr.getState());
        HttpHost target2 = new HttpHost("otherhost", 80);
        HttpRoute route2 = new HttpRoute(target2);
        LeaseRequest connRequest2 = this.mgr.lease("some-id", route2, null);
        ConnectionEndpoint conn2 = connRequest2.get(Timeout.ZERO_MILLISECONDS);
        Assert.assertNotNull((Object)conn2);
        Assert.assertFalse((boolean)conn2.isConnected());
        ((ManagedHttpClientConnection)Mockito.verify((Object)this.conn)).close(CloseMode.GRACEFUL);
        ((HttpConnectionFactory)Mockito.verify(this.connFactory, (VerificationMode)Mockito.times((int)2))).createConnection((Socket)Mockito.any());
    }

    @Test
    public void testLeaseExpired() throws Exception {
        HttpHost target = new HttpHost("somehost", 80);
        HttpRoute route = new HttpRoute(target);
        Mockito.when((Object)this.connFactory.createConnection((Socket)Mockito.any())).thenReturn((Object)this.conn);
        LeaseRequest connRequest1 = this.mgr.lease("some-id", route, null);
        ConnectionEndpoint endpoint1 = connRequest1.get(Timeout.ZERO_MILLISECONDS);
        Assert.assertNotNull((Object)endpoint1);
        ((HttpConnectionFactory)Mockito.verify(this.connFactory, (VerificationMode)Mockito.times((int)1))).createConnection((Socket)Mockito.any());
        Mockito.when((Object)this.conn.isOpen()).thenReturn((Object)Boolean.TRUE, (Object[])new Boolean[]{Boolean.FALSE});
        this.mgr.release(endpoint1, null, TimeValue.ofMilliseconds((long)10L));
        Assert.assertEquals((Object)route, (Object)this.mgr.getRoute());
        Assert.assertEquals(null, (Object)this.mgr.getState());
        Thread.sleep(50L);
        LeaseRequest connRequest2 = this.mgr.lease("some-id", route, null);
        ConnectionEndpoint conn2 = connRequest2.get(Timeout.ZERO_MILLISECONDS);
        Assert.assertNotNull((Object)conn2);
        Assert.assertFalse((boolean)conn2.isConnected());
        ((ManagedHttpClientConnection)Mockito.verify((Object)this.conn)).close(CloseMode.GRACEFUL);
        ((HttpConnectionFactory)Mockito.verify(this.connFactory, (VerificationMode)Mockito.times((int)2))).createConnection((Socket)Mockito.any());
    }

    @Test(expected=NullPointerException.class)
    public void testReleaseInvalidArg() throws Exception {
        this.mgr.release(null, null, TimeValue.NEG_ONE_MILLISECOND);
    }

    @Test(expected=IllegalStateException.class)
    public void testReleaseAnotherConnection() throws Exception {
        ConnectionEndpoint wrongCon = (ConnectionEndpoint)Mockito.mock(ConnectionEndpoint.class);
        this.mgr.release(wrongCon, null, TimeValue.NEG_ONE_MILLISECOND);
    }

    @Test
    public void testShutdown() throws Exception {
        HttpHost target = new HttpHost("somehost", 80);
        HttpRoute route = new HttpRoute(target);
        Mockito.when((Object)this.connFactory.createConnection((Socket)Mockito.any())).thenReturn((Object)this.conn);
        LeaseRequest connRequest1 = this.mgr.lease("some-id", route, null);
        ConnectionEndpoint endpoint1 = connRequest1.get(Timeout.ZERO_MILLISECONDS);
        Assert.assertNotNull((Object)endpoint1);
        ((HttpConnectionFactory)Mockito.verify(this.connFactory, (VerificationMode)Mockito.times((int)1))).createConnection((Socket)Mockito.any());
        Mockito.when((Object)this.conn.isOpen()).thenReturn((Object)Boolean.TRUE);
        this.mgr.release(endpoint1, null, TimeValue.NEG_ONE_MILLISECOND);
        this.mgr.close();
        ((ManagedHttpClientConnection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)1))).close(CloseMode.GRACEFUL);
        try {
            LeaseRequest connRequest2 = this.mgr.lease("some-id", route, null);
            connRequest2.get(Timeout.ZERO_MILLISECONDS);
            Assert.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException ex) {
            // empty catch block
        }
        this.mgr.closeExpired();
        this.mgr.closeIdle(TimeValue.ZERO_MILLISECONDS);
        this.mgr.close();
        ((ManagedHttpClientConnection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)1))).close(CloseMode.GRACEFUL);
    }

    @Test
    public void testCloseExpired() throws Exception {
        HttpHost target = new HttpHost("somehost", 80);
        HttpRoute route = new HttpRoute(target);
        Mockito.when((Object)this.connFactory.createConnection((Socket)Mockito.any())).thenReturn((Object)this.conn);
        LeaseRequest connRequest1 = this.mgr.lease("some-id", route, null);
        ConnectionEndpoint endpoint1 = connRequest1.get(Timeout.ZERO_MILLISECONDS);
        Assert.assertNotNull((Object)endpoint1);
        ((HttpConnectionFactory)Mockito.verify(this.connFactory, (VerificationMode)Mockito.times((int)1))).createConnection((Socket)Mockito.any());
        Mockito.when((Object)this.conn.isOpen()).thenReturn((Object)Boolean.TRUE, (Object[])new Boolean[]{Boolean.FALSE});
        this.mgr.release(endpoint1, null, TimeValue.ofMilliseconds((long)10L));
        Assert.assertEquals((Object)route, (Object)this.mgr.getRoute());
        Assert.assertEquals(null, (Object)this.mgr.getState());
        Thread.sleep(50L);
        this.mgr.closeExpired();
        ((ManagedHttpClientConnection)Mockito.verify((Object)this.conn)).close(CloseMode.GRACEFUL);
    }

    @Test
    public void testCloseIdle() throws Exception {
        HttpHost target = new HttpHost("somehost", 80);
        HttpRoute route = new HttpRoute(target);
        Mockito.when((Object)this.connFactory.createConnection((Socket)Mockito.any())).thenReturn((Object)this.conn);
        LeaseRequest connRequest1 = this.mgr.lease("some-id", route, null);
        ConnectionEndpoint endpoint1 = connRequest1.get(Timeout.ZERO_MILLISECONDS);
        Assert.assertNotNull((Object)endpoint1);
        ((HttpConnectionFactory)Mockito.verify(this.connFactory, (VerificationMode)Mockito.times((int)1))).createConnection((Socket)Mockito.any());
        Mockito.when((Object)this.conn.isOpen()).thenReturn((Object)Boolean.TRUE, (Object[])new Boolean[]{Boolean.FALSE});
        this.mgr.release(endpoint1, null, TimeValue.NEG_ONE_MILLISECOND);
        Assert.assertEquals((Object)route, (Object)this.mgr.getRoute());
        Assert.assertEquals(null, (Object)this.mgr.getState());
        Thread.sleep(100L);
        this.mgr.closeIdle(TimeValue.ofMilliseconds((long)50L));
        ((ManagedHttpClientConnection)Mockito.verify((Object)this.conn)).close(CloseMode.GRACEFUL);
    }

    @Test(expected=IllegalStateException.class)
    public void testAlreadyLeased() throws Exception {
        HttpHost target = new HttpHost("somehost", 80);
        HttpRoute route = new HttpRoute(target);
        Mockito.when((Object)this.connFactory.createConnection((Socket)Mockito.any())).thenReturn((Object)this.conn);
        LeaseRequest connRequest1 = this.mgr.lease("some-id", route, null);
        ConnectionEndpoint endpoint1 = connRequest1.get(Timeout.ZERO_MILLISECONDS);
        Assert.assertNotNull((Object)endpoint1);
        this.mgr.release(endpoint1, null, TimeValue.ofMilliseconds((long)100L));
        this.mgr.getConnection(route, null);
        this.mgr.getConnection(route, null);
    }

    @Test
    public void testTargetConnect() throws Exception {
        HttpHost target = new HttpHost("https", "somehost", 443);
        InetAddress remote = InetAddress.getByAddress(new byte[]{10, 0, 0, 1});
        InetAddress local = InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
        HttpRoute route = new HttpRoute(target, local, true);
        Mockito.when((Object)this.connFactory.createConnection((Socket)Mockito.any())).thenReturn((Object)this.conn);
        LeaseRequest connRequest1 = this.mgr.lease("some-id", route, null);
        ConnectionEndpoint endpoint1 = connRequest1.get(Timeout.ZERO_MILLISECONDS);
        Assert.assertNotNull((Object)endpoint1);
        HttpClientContext context = HttpClientContext.create();
        SocketConfig sconfig = SocketConfig.custom().build();
        this.mgr.setSocketConfig(sconfig);
        Mockito.when((Object)this.dnsResolver.resolve("somehost")).thenReturn((Object)new InetAddress[]{remote});
        Mockito.when((Object)this.schemePortResolver.resolve(target)).thenReturn((Object)8443);
        Mockito.when((Object)this.socketFactoryRegistry.lookup("https")).thenReturn((Object)this.plainSocketFactory);
        Mockito.when((Object)this.plainSocketFactory.createSocket((HttpContext)Mockito.any())).thenReturn((Object)this.socket);
        Mockito.when((Object)this.plainSocketFactory.connectSocket((TimeValue)Mockito.any(), (Socket)Mockito.eq((Object)this.socket), (HttpHost)Mockito.any(), (InetSocketAddress)Mockito.any(), (InetSocketAddress)Mockito.any(), (HttpContext)Mockito.any())).thenReturn((Object)this.socket);
        this.mgr.connect(endpoint1, TimeValue.ofMilliseconds((long)123L), (HttpContext)context);
        ((DnsResolver)Mockito.verify((Object)this.dnsResolver, (VerificationMode)Mockito.times((int)1))).resolve("somehost");
        ((SchemePortResolver)Mockito.verify((Object)this.schemePortResolver, (VerificationMode)Mockito.times((int)1))).resolve(target);
        ((ConnectionSocketFactory)Mockito.verify((Object)this.plainSocketFactory, (VerificationMode)Mockito.times((int)1))).createSocket((HttpContext)context);
        ((ConnectionSocketFactory)Mockito.verify((Object)this.plainSocketFactory, (VerificationMode)Mockito.times((int)1))).connectSocket(TimeValue.ofMilliseconds((long)123L), this.socket, target, new InetSocketAddress(remote, 8443), new InetSocketAddress(local, 0), (HttpContext)context);
    }

    @Test
    public void testProxyConnectAndUpgrade() throws Exception {
        HttpHost target = new HttpHost("https", "somehost", 443);
        HttpHost proxy = new HttpHost("someproxy", 8080);
        InetAddress remote = InetAddress.getByAddress(new byte[]{10, 0, 0, 1});
        InetAddress local = InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
        HttpRoute route = new HttpRoute(target, local, proxy, true);
        Mockito.when((Object)this.connFactory.createConnection((Socket)Mockito.any())).thenReturn((Object)this.conn);
        LeaseRequest connRequest1 = this.mgr.lease("some-id", route, null);
        ConnectionEndpoint endpoint1 = connRequest1.get(Timeout.ZERO_MILLISECONDS);
        Assert.assertNotNull((Object)endpoint1);
        HttpClientContext context = HttpClientContext.create();
        SocketConfig sconfig = SocketConfig.custom().build();
        this.mgr.setSocketConfig(sconfig);
        Mockito.when((Object)this.dnsResolver.resolve("someproxy")).thenReturn((Object)new InetAddress[]{remote});
        Mockito.when((Object)this.schemePortResolver.resolve(proxy)).thenReturn((Object)8080);
        Mockito.when((Object)this.schemePortResolver.resolve(target)).thenReturn((Object)8443);
        Mockito.when((Object)this.socketFactoryRegistry.lookup("http")).thenReturn((Object)this.plainSocketFactory);
        Mockito.when((Object)this.socketFactoryRegistry.lookup("https")).thenReturn((Object)this.sslSocketFactory);
        Mockito.when((Object)this.plainSocketFactory.createSocket((HttpContext)Mockito.any())).thenReturn((Object)this.socket);
        Mockito.when((Object)this.plainSocketFactory.connectSocket((TimeValue)Mockito.any(), (Socket)Mockito.eq((Object)this.socket), (HttpHost)Mockito.any(), (InetSocketAddress)Mockito.any(), (InetSocketAddress)Mockito.any(), (HttpContext)Mockito.any())).thenReturn((Object)this.socket);
        this.mgr.connect(endpoint1, TimeValue.ofMilliseconds((long)123L), (HttpContext)context);
        ((DnsResolver)Mockito.verify((Object)this.dnsResolver, (VerificationMode)Mockito.times((int)1))).resolve("someproxy");
        ((SchemePortResolver)Mockito.verify((Object)this.schemePortResolver, (VerificationMode)Mockito.times((int)1))).resolve(proxy);
        ((ConnectionSocketFactory)Mockito.verify((Object)this.plainSocketFactory, (VerificationMode)Mockito.times((int)1))).createSocket((HttpContext)context);
        ((ConnectionSocketFactory)Mockito.verify((Object)this.plainSocketFactory, (VerificationMode)Mockito.times((int)1))).connectSocket(TimeValue.ofMilliseconds((long)123L), this.socket, proxy, new InetSocketAddress(remote, 8080), new InetSocketAddress(local, 0), (HttpContext)context);
        Mockito.when((Object)this.conn.getSocket()).thenReturn((Object)this.socket);
        this.mgr.upgrade(endpoint1, (HttpContext)context);
        ((SchemePortResolver)Mockito.verify((Object)this.schemePortResolver, (VerificationMode)Mockito.times((int)1))).resolve(target);
        ((LayeredConnectionSocketFactory)Mockito.verify((Object)this.sslSocketFactory, (VerificationMode)Mockito.times((int)1))).createLayeredSocket(this.socket, "somehost", 8443, (HttpContext)context);
    }
}

