/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.routing;

import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.routing.DefaultProxyRoutePlanner;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.message.BasicHttpRequest;
import org.apache.hc.core5.http.protocol.BasicHttpContext;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestDefaultProxyRoutePlanner {
    private HttpHost defaultProxy;
    private SchemePortResolver schemePortResolver;
    private DefaultProxyRoutePlanner routePlanner;

    @Before
    public void setup() {
        this.defaultProxy = new HttpHost("default.proxy.host", 8888);
        this.schemePortResolver = (SchemePortResolver)Mockito.mock(SchemePortResolver.class);
        this.routePlanner = new DefaultProxyRoutePlanner(this.defaultProxy, this.schemePortResolver);
    }

    @Test
    public void testDefaultProxyDirect() throws Exception {
        HttpHost target = new HttpHost("http", "somehost", 80);
        BasicHttpContext context = new BasicHttpContext();
        HttpRoute route = this.routePlanner.determineRoute(target, (HttpContext)context);
        Assert.assertEquals((Object)target, (Object)route.getTargetHost());
        Assert.assertEquals((Object)this.defaultProxy, (Object)route.getProxyHost());
        Assert.assertEquals((long)2L, (long)route.getHopCount());
        Assert.assertFalse((boolean)route.isSecure());
    }

    @Test
    public void testViaProxy() throws Exception {
        HttpHost target = new HttpHost("http", "somehost", 80);
        HttpHost proxy = new HttpHost("custom.proxy.host", 8080);
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        HttpClientContext context = HttpClientContext.create();
        context.setRequestConfig(RequestConfig.custom().setProxy(proxy).build());
        HttpRoute route = this.routePlanner.determineRoute(target, (HttpContext)context);
        Assert.assertEquals((Object)target, (Object)route.getTargetHost());
        Assert.assertEquals((Object)proxy, (Object)route.getProxyHost());
        Assert.assertEquals((long)2L, (long)route.getHopCount());
        Assert.assertFalse((boolean)route.isSecure());
    }
}

