/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.protocol;

import java.util.Date;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.RouteInfo;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.cookie.BasicCookieStore;
import org.apache.hc.client5.http.cookie.Cookie;
import org.apache.hc.client5.http.cookie.CookieOrigin;
import org.apache.hc.client5.http.cookie.CookieSpec;
import org.apache.hc.client5.http.cookie.CookieSpecFactory;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.impl.cookie.BasicClientCookie;
import org.apache.hc.client5.http.impl.cookie.IgnoreCookieSpecFactory;
import org.apache.hc.client5.http.impl.cookie.RFC6265CookieSpecFactory;
import org.apache.hc.client5.http.impl.cookie.RFC6265StrictSpec;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.protocol.RequestAddCookies;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.config.Lookup;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.message.BasicHttpRequest;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestRequestAddCookies {
    private HttpHost target;
    private CookieStore cookieStore;
    private Lookup<CookieSpecFactory> cookieSpecRegistry;

    @Before
    public void setUp() {
        this.target = new HttpHost("localhost.local", 80);
        this.cookieStore = new BasicCookieStore();
        BasicClientCookie cookie1 = new BasicClientCookie("name1", "value1");
        cookie1.setDomain("localhost.local");
        cookie1.setPath("/");
        this.cookieStore.addCookie((Cookie)cookie1);
        BasicClientCookie cookie2 = new BasicClientCookie("name2", "value2");
        cookie2.setDomain("localhost.local");
        cookie2.setPath("/");
        this.cookieStore.addCookie((Cookie)cookie2);
        this.cookieSpecRegistry = RegistryBuilder.create().register("relaxed", (Object)new RFC6265CookieSpecFactory(RFC6265CookieSpecFactory.CompatibilityLevel.RELAXED, null)).register("strict", (Object)new RFC6265CookieSpecFactory(RFC6265CookieSpecFactory.CompatibilityLevel.STRICT, null)).register("ignore", (Object)new IgnoreCookieSpecFactory()).build();
    }

    @Test(expected=NullPointerException.class)
    public void testRequestParameterCheck() throws Exception {
        HttpClientContext context = HttpClientContext.create();
        RequestAddCookies interceptor = new RequestAddCookies();
        interceptor.process(null, null, (HttpContext)context);
    }

    @Test(expected=NullPointerException.class)
    public void testContextParameterCheck() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        RequestAddCookies interceptor = new RequestAddCookies();
        interceptor.process((HttpRequest)request, null, null);
    }

    @Test
    public void testAddCookies() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        HttpRoute route = new HttpRoute(this.target, null, false);
        HttpClientContext context = HttpClientContext.create();
        context.setAttribute("http.route", (Object)route);
        context.setAttribute("http.cookie-store", (Object)this.cookieStore);
        context.setAttribute("http.cookiespec-registry", this.cookieSpecRegistry);
        RequestAddCookies interceptor = new RequestAddCookies();
        interceptor.process((HttpRequest)request, null, (HttpContext)context);
        Header[] headers = request.getHeaders("Cookie");
        Assert.assertNotNull((Object)headers);
        Assert.assertEquals((long)1L, (long)headers.length);
        Assert.assertEquals((Object)"name1=value1; name2=value2", (Object)headers[0].getValue());
        CookieOrigin cookieOrigin = context.getCookieOrigin();
        Assert.assertNotNull((Object)cookieOrigin);
        Assert.assertEquals((Object)this.target.getHostName(), (Object)cookieOrigin.getHost());
        Assert.assertEquals((long)this.target.getPort(), (long)cookieOrigin.getPort());
        Assert.assertEquals((Object)"/", (Object)cookieOrigin.getPath());
        Assert.assertFalse((boolean)cookieOrigin.isSecure());
    }

    @Test
    public void testCookiesForConnectRequest() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("CONNECT", "www.somedomain.com");
        HttpRoute route = new HttpRoute(this.target, null, false);
        HttpClientContext context = HttpClientContext.create();
        context.setAttribute("http.route", (Object)route);
        context.setAttribute("http.cookie-store", (Object)this.cookieStore);
        context.setAttribute("http.cookiespec-registry", this.cookieSpecRegistry);
        RequestAddCookies interceptor = new RequestAddCookies();
        interceptor.process((HttpRequest)request, null, (HttpContext)context);
        Header[] headers = request.getHeaders("Cookie");
        Assert.assertNotNull((Object)headers);
        Assert.assertEquals((long)0L, (long)headers.length);
    }

    @Test
    public void testNoCookieStore() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        HttpRoute route = new HttpRoute(this.target, null, false);
        HttpClientContext context = HttpClientContext.create();
        context.setAttribute("http.route", (Object)route);
        context.setAttribute("http.cookie-store", null);
        context.setAttribute("http.cookiespec-registry", this.cookieSpecRegistry);
        RequestAddCookies interceptor = new RequestAddCookies();
        interceptor.process((HttpRequest)request, null, (HttpContext)context);
        Header[] headers = request.getHeaders("Cookie");
        Assert.assertNotNull((Object)headers);
        Assert.assertEquals((long)0L, (long)headers.length);
    }

    @Test
    public void testNoCookieSpecRegistry() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        HttpRoute route = new HttpRoute(this.target, null, false);
        HttpClientContext context = HttpClientContext.create();
        context.setAttribute("http.route", (Object)route);
        context.setAttribute("http.cookie-store", (Object)this.cookieStore);
        context.setAttribute("http.cookiespec-registry", null);
        RequestAddCookies interceptor = new RequestAddCookies();
        interceptor.process((HttpRequest)request, null, (HttpContext)context);
        Header[] headers = request.getHeaders("Cookie");
        Assert.assertNotNull((Object)headers);
        Assert.assertEquals((long)0L, (long)headers.length);
    }

    @Test
    public void testNoHttpConnection() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        HttpClientContext context = HttpClientContext.create();
        context.setAttribute("http.connection-endpoint", null);
        context.setAttribute("http.cookie-store", (Object)this.cookieStore);
        context.setAttribute("http.cookiespec-registry", this.cookieSpecRegistry);
        RequestAddCookies interceptor = new RequestAddCookies();
        interceptor.process((HttpRequest)request, null, (HttpContext)context);
        Header[] headers = request.getHeaders("Cookie");
        Assert.assertNotNull((Object)headers);
        Assert.assertEquals((long)0L, (long)headers.length);
    }

    @Test
    public void testAddCookiesUsingExplicitCookieSpec() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        RequestConfig config = RequestConfig.custom().setCookieSpec("strict").build();
        HttpRoute route = new HttpRoute(this.target, null, false);
        HttpClientContext context = HttpClientContext.create();
        context.setAttribute("http.route", (Object)route);
        context.setAttribute("http.request-config", (Object)config);
        context.setAttribute("http.cookie-store", (Object)this.cookieStore);
        context.setAttribute("http.cookiespec-registry", this.cookieSpecRegistry);
        RequestAddCookies interceptor = new RequestAddCookies();
        interceptor.process((HttpRequest)request, null, (HttpContext)context);
        CookieSpec cookieSpec = context.getCookieSpec();
        Assert.assertTrue((boolean)(cookieSpec instanceof RFC6265StrictSpec));
        Header[] headers1 = request.getHeaders("Cookie");
        Assert.assertNotNull((Object)headers1);
        Assert.assertEquals((long)1L, (long)headers1.length);
        Assert.assertEquals((Object)"name1=value1; name2=value2", (Object)headers1[0].getValue());
    }

    @Test
    public void testAuthScopeInvalidRequestURI() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "crap:");
        HttpRoute route = new HttpRoute(this.target, null, false);
        HttpClientContext context = HttpClientContext.create();
        context.setAttribute("http.route", (Object)route);
        context.setAttribute("http.cookie-store", (Object)this.cookieStore);
        context.setAttribute("http.cookiespec-registry", this.cookieSpecRegistry);
        RequestAddCookies interceptor = new RequestAddCookies();
        interceptor.process((HttpRequest)request, null, (HttpContext)context);
    }

    @Test
    public void testAuthScopeRemotePortWhenDirect() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/stuff");
        this.target = new HttpHost("localhost.local");
        HttpRoute route = new HttpRoute(new HttpHost("localhost.local", 1234), null, false);
        HttpClientContext context = HttpClientContext.create();
        context.setAttribute("http.route", (Object)route);
        context.setAttribute("http.cookie-store", (Object)this.cookieStore);
        context.setAttribute("http.cookiespec-registry", this.cookieSpecRegistry);
        RequestAddCookies interceptor = new RequestAddCookies();
        interceptor.process((HttpRequest)request, null, (HttpContext)context);
        CookieOrigin cookieOrigin = context.getCookieOrigin();
        Assert.assertNotNull((Object)cookieOrigin);
        Assert.assertEquals((Object)this.target.getHostName(), (Object)cookieOrigin.getHost());
        Assert.assertEquals((long)1234L, (long)cookieOrigin.getPort());
        Assert.assertEquals((Object)"/stuff", (Object)cookieOrigin.getPath());
        Assert.assertFalse((boolean)cookieOrigin.isSecure());
    }

    @Test
    public void testAuthDefaultHttpPortWhenProxy() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/stuff");
        this.target = new HttpHost("localhost.local");
        HttpRoute route = new HttpRoute(new HttpHost("localhost.local", 80), null, new HttpHost("localhost", 8888), false);
        HttpClientContext context = HttpClientContext.create();
        context.setAttribute("http.route", (Object)route);
        context.setAttribute("http.cookie-store", (Object)this.cookieStore);
        context.setAttribute("http.cookiespec-registry", this.cookieSpecRegistry);
        RequestAddCookies interceptor = new RequestAddCookies();
        interceptor.process((HttpRequest)request, null, (HttpContext)context);
        CookieOrigin cookieOrigin = context.getCookieOrigin();
        Assert.assertNotNull((Object)cookieOrigin);
        Assert.assertEquals((Object)this.target.getHostName(), (Object)cookieOrigin.getHost());
        Assert.assertEquals((long)80L, (long)cookieOrigin.getPort());
        Assert.assertEquals((Object)"/stuff", (Object)cookieOrigin.getPath());
        Assert.assertFalse((boolean)cookieOrigin.isSecure());
    }

    @Test
    public void testAuthDefaultHttpsPortWhenProxy() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/stuff");
        this.target = new HttpHost("https", "localhost", -1);
        HttpRoute route = new HttpRoute(new HttpHost("https", "localhost", 443), null, new HttpHost("http", "localhost", 8888), true, RouteInfo.TunnelType.TUNNELLED, RouteInfo.LayerType.LAYERED);
        HttpClientContext context = HttpClientContext.create();
        context.setAttribute("http.route", (Object)route);
        context.setAttribute("http.cookie-store", (Object)this.cookieStore);
        context.setAttribute("http.cookiespec-registry", this.cookieSpecRegistry);
        RequestAddCookies interceptor = new RequestAddCookies();
        interceptor.process((HttpRequest)request, null, (HttpContext)context);
        CookieOrigin cookieOrigin = context.getCookieOrigin();
        Assert.assertNotNull((Object)cookieOrigin);
        Assert.assertEquals((Object)this.target.getHostName(), (Object)cookieOrigin.getHost());
        Assert.assertEquals((long)443L, (long)cookieOrigin.getPort());
        Assert.assertEquals((Object)"/stuff", (Object)cookieOrigin.getPath());
        Assert.assertTrue((boolean)cookieOrigin.isSecure());
    }

    @Test
    public void testExcludeExpiredCookies() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        BasicClientCookie cookie3 = new BasicClientCookie("name3", "value3");
        cookie3.setDomain("localhost.local");
        cookie3.setPath("/");
        cookie3.setExpiryDate(new Date(System.currentTimeMillis() + 100L));
        this.cookieStore.addCookie((Cookie)cookie3);
        Assert.assertEquals((long)3L, (long)this.cookieStore.getCookies().size());
        this.cookieStore = (CookieStore)Mockito.spy((Object)this.cookieStore);
        HttpRoute route = new HttpRoute(this.target, null, false);
        HttpClientContext context = HttpClientContext.create();
        context.setAttribute("http.route", (Object)route);
        context.setAttribute("http.cookie-store", (Object)this.cookieStore);
        context.setAttribute("http.cookiespec-registry", this.cookieSpecRegistry);
        Thread.sleep(200L);
        RequestAddCookies interceptor = new RequestAddCookies();
        interceptor.process((HttpRequest)request, null, (HttpContext)context);
        Header[] headers = request.getHeaders("Cookie");
        Assert.assertNotNull((Object)headers);
        Assert.assertEquals((long)1L, (long)headers.length);
        Assert.assertEquals((Object)"name1=value1; name2=value2", (Object)headers[0].getValue());
        ((CookieStore)Mockito.verify((Object)this.cookieStore, (VerificationMode)Mockito.times((int)1))).clearExpired((Date)ArgumentMatchers.any());
    }

    @Test
    public void testNoMatchingCookies() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        this.cookieStore.clear();
        BasicClientCookie cookie3 = new BasicClientCookie("name3", "value3");
        cookie3.setDomain("www.somedomain.com");
        cookie3.setPath("/");
        this.cookieStore.addCookie((Cookie)cookie3);
        HttpRoute route = new HttpRoute(this.target, null, false);
        HttpClientContext context = HttpClientContext.create();
        context.setAttribute("http.route", (Object)route);
        context.setAttribute("http.cookie-store", (Object)this.cookieStore);
        context.setAttribute("http.cookiespec-registry", this.cookieSpecRegistry);
        RequestAddCookies interceptor = new RequestAddCookies();
        interceptor.process((HttpRequest)request, null, (HttpContext)context);
        Header[] headers = request.getHeaders("Cookie");
        Assert.assertNotNull((Object)headers);
        Assert.assertEquals((long)0L, (long)headers.length);
    }

    private BasicClientCookie makeCookie(String name, String value, String domain, String path) {
        BasicClientCookie cookie = new BasicClientCookie(name, value);
        cookie.setDomain(domain);
        cookie.setPath(path);
        return cookie;
    }

    @Test
    public void testCookieOrder() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/foobar/yada/yada");
        this.cookieStore.clear();
        this.cookieStore.addCookie((Cookie)this.makeCookie("nomatch", "value", "localhost.local", "/noway"));
        this.cookieStore.addCookie((Cookie)this.makeCookie("name2", "value", "localhost.local", "/foobar/yada"));
        this.cookieStore.addCookie((Cookie)this.makeCookie("name3", "value", "localhost.local", "/foobar"));
        this.cookieStore.addCookie((Cookie)this.makeCookie("name1", "value", "localhost.local", "/foobar/yada/yada"));
        HttpRoute route = new HttpRoute(this.target, null, false);
        HttpClientContext context = HttpClientContext.create();
        context.setAttribute("http.route", (Object)route);
        context.setAttribute("http.cookie-store", (Object)this.cookieStore);
        context.setAttribute("http.cookiespec-registry", this.cookieSpecRegistry);
        RequestAddCookies interceptor = new RequestAddCookies();
        interceptor.process((HttpRequest)request, null, (HttpContext)context);
        Header[] headers1 = request.getHeaders("Cookie");
        Assert.assertNotNull((Object)headers1);
        Assert.assertEquals((long)1L, (long)headers1.length);
        Assert.assertEquals((Object)"name1=value; name2=value; name3=value", (Object)headers1[0].getValue());
    }
}

