/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.protocol;

import java.util.List;
import org.apache.hc.client5.http.cookie.BasicCookieStore;
import org.apache.hc.client5.http.cookie.Cookie;
import org.apache.hc.client5.http.cookie.CookieOrigin;
import org.apache.hc.client5.http.cookie.CookieSpec;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.impl.cookie.RFC6265LaxSpec;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.protocol.ResponseProcessCookies;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.message.BasicHttpResponse;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestResponseProcessCookies {
    private CookieOrigin cookieOrigin;
    private CookieSpec cookieSpec;
    private CookieStore cookieStore;

    @Before
    public void setUp() throws Exception {
        this.cookieOrigin = new CookieOrigin("localhost", 80, "/", false);
        this.cookieSpec = new RFC6265LaxSpec();
        this.cookieStore = new BasicCookieStore();
    }

    @Test(expected=NullPointerException.class)
    public void testResponseParameterCheck() throws Exception {
        HttpClientContext context = HttpClientContext.create();
        ResponseProcessCookies interceptor = new ResponseProcessCookies();
        interceptor.process(null, null, (HttpContext)context);
    }

    @Test(expected=NullPointerException.class)
    public void testContextParameterCheck() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse(200, "OK");
        ResponseProcessCookies interceptor = new ResponseProcessCookies();
        interceptor.process((HttpResponse)response, null, null);
    }

    @Test
    public void testParseCookies() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse(200, "OK");
        response.addHeader("Set-Cookie", (Object)"name1=value1");
        HttpClientContext context = HttpClientContext.create();
        context.setAttribute("http.cookie-origin", (Object)this.cookieOrigin);
        context.setAttribute("http.cookie-spec", (Object)this.cookieSpec);
        context.setAttribute("http.cookie-store", (Object)this.cookieStore);
        ResponseProcessCookies interceptor = new ResponseProcessCookies();
        interceptor.process((HttpResponse)response, null, (HttpContext)context);
        List cookies = this.cookieStore.getCookies();
        Assert.assertNotNull((Object)cookies);
        Assert.assertEquals((long)1L, (long)cookies.size());
        Cookie cookie = (Cookie)cookies.get(0);
        Assert.assertEquals((Object)"name1", (Object)cookie.getName());
        Assert.assertEquals((Object)"value1", (Object)cookie.getValue());
        Assert.assertEquals((Object)"localhost", (Object)cookie.getDomain());
        Assert.assertEquals((Object)"/", (Object)cookie.getPath());
    }

    @Test
    public void testNoCookieOrigin() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse(200, "OK");
        response.addHeader("Set-Cookie", (Object)"name1=value1");
        HttpClientContext context = HttpClientContext.create();
        context.setAttribute("http.cookie-origin", null);
        context.setAttribute("http.cookie-spec", (Object)this.cookieSpec);
        context.setAttribute("http.cookie-store", (Object)this.cookieStore);
        ResponseProcessCookies interceptor = new ResponseProcessCookies();
        interceptor.process((HttpResponse)response, null, (HttpContext)context);
        List cookies = this.cookieStore.getCookies();
        Assert.assertNotNull((Object)cookies);
        Assert.assertEquals((long)0L, (long)cookies.size());
    }

    @Test
    public void testNoCookieSpec() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse(200, "OK");
        response.addHeader("Set-Cookie", (Object)"name1=value1");
        HttpClientContext context = HttpClientContext.create();
        context.setAttribute("http.cookie-origin", (Object)this.cookieOrigin);
        context.setAttribute("http.cookie-spec", null);
        context.setAttribute("http.cookie-store", (Object)this.cookieStore);
        ResponseProcessCookies interceptor = new ResponseProcessCookies();
        interceptor.process((HttpResponse)response, null, (HttpContext)context);
        List cookies = this.cookieStore.getCookies();
        Assert.assertNotNull((Object)cookies);
        Assert.assertEquals((long)0L, (long)cookies.size());
    }

    @Test
    public void testNoCookieStore() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse(200, "OK");
        response.addHeader("Set-Cookie", (Object)"name1=value1");
        HttpClientContext context = HttpClientContext.create();
        context.setAttribute("http.cookie-origin", (Object)this.cookieOrigin);
        context.setAttribute("http.cookie-spec", (Object)this.cookieSpec);
        context.setAttribute("http.cookie-store", null);
        ResponseProcessCookies interceptor = new ResponseProcessCookies();
        interceptor.process((HttpResponse)response, null, (HttpContext)context);
        List cookies = this.cookieStore.getCookies();
        Assert.assertNotNull((Object)cookies);
        Assert.assertEquals((long)0L, (long)cookies.size());
    }
}

