/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.psl;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hc.client5.http.psl.DomainType;
import org.apache.hc.client5.http.psl.PublicSuffixList;
import org.apache.hc.client5.http.psl.PublicSuffixListParser;
import org.junit.Assert;
import org.junit.Test;

public class TestPublicSuffixListParser {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testParse() throws Exception {
        PublicSuffixList suffixList;
        ClassLoader classLoader = this.getClass().getClassLoader();
        Assert.assertNotNull((Object)in);
        try (InputStream in = classLoader.getResourceAsStream("suffixlist.txt");){
            PublicSuffixListParser parser = new PublicSuffixListParser();
            suffixList = parser.parse((Reader)new InputStreamReader(in, StandardCharsets.UTF_8));
        }
        Assert.assertNotNull((Object)suffixList);
        Assert.assertEquals(Arrays.asList("xx", "jp", "ac.jp", "*.tokyo.jp", "no", "h\u00e5.no"), (Object)suffixList.getRules());
        Assert.assertEquals(Collections.singletonList("metro.tokyo.jp"), (Object)suffixList.getExceptions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testParseByType() throws Exception {
        List suffixLists;
        ClassLoader classLoader = this.getClass().getClassLoader();
        Assert.assertNotNull((Object)in);
        try (InputStream in = classLoader.getResourceAsStream("suffixlist2.txt");){
            PublicSuffixListParser parser = new PublicSuffixListParser();
            suffixLists = parser.parseByType((Reader)new InputStreamReader(in, StandardCharsets.UTF_8));
        }
        Assert.assertNotNull((Object)suffixLists);
        Assert.assertEquals((long)2L, (long)suffixLists.size());
        PublicSuffixList publicSuffixList1 = (PublicSuffixList)suffixLists.get(0);
        Assert.assertNotNull((Object)publicSuffixList1);
        Assert.assertEquals((Object)DomainType.ICANN, (Object)publicSuffixList1.getType());
        Assert.assertEquals(Arrays.asList("jp", "ac.jp", "*.tokyo.jp"), (Object)publicSuffixList1.getRules());
        Assert.assertEquals(Collections.singletonList("metro.tokyo.jp"), (Object)publicSuffixList1.getExceptions());
        PublicSuffixList publicSuffixList2 = (PublicSuffixList)suffixLists.get(1);
        Assert.assertNotNull((Object)publicSuffixList2);
        Assert.assertEquals((Object)DomainType.PRIVATE, (Object)publicSuffixList2.getType());
        Assert.assertEquals(Arrays.asList("googleapis.com", "googlecode.com"), (Object)publicSuffixList2.getRules());
        Assert.assertEquals(Collections.emptyList(), (Object)publicSuffixList2.getExceptions());
    }
}

