/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.routing;

import java.net.InetAddress;
import java.util.HashSet;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.RouteInfo;
import org.apache.hc.core5.http.HttpHost;
import org.junit.Assert;
import org.junit.Test;

public class TestHttpRoute {
    public static final HttpHost TARGET1 = new HttpHost("target1.test.invalid", 80);
    public static final HttpHost TARGET2 = new HttpHost("target2.test.invalid", 8080);
    public static final HttpHost PROXY1 = new HttpHost("proxy1.test.invalid");
    public static final HttpHost PROXY2 = new HttpHost("proxy2.test.invalid", 1080);
    public static final HttpHost PROXY3 = new HttpHost("proxy3.test.invalid", 88);
    public static final InetAddress LOCAL41;
    public static final InetAddress LOCAL42;
    public static final InetAddress LOCAL61;
    public static final InetAddress LOCAL62;

    @Test
    public void testCstrFullRoute() {
        HttpHost[] chain3 = new HttpHost[]{PROXY1, PROXY2, PROXY3};
        HttpRoute route = new HttpRoute(TARGET1, LOCAL41, chain3, false, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        Assert.assertEquals((String)"wrong target", (Object)TARGET1, (Object)route.getTargetHost());
        Assert.assertEquals((String)"wrong local address", (Object)LOCAL41, (Object)route.getLocalAddress());
        Assert.assertEquals((String)"wrong proxy host", (Object)PROXY1, (Object)route.getProxyHost());
        Assert.assertEquals((String)"wrong hop count", (long)4L, (long)route.getHopCount());
        Assert.assertEquals((String)"wrong hop 0", (Object)PROXY1, (Object)route.getHopTarget(0));
        Assert.assertEquals((String)"wrong hop 1", (Object)PROXY2, (Object)route.getHopTarget(1));
        Assert.assertEquals((String)"wrong hop 2", (Object)PROXY3, (Object)route.getHopTarget(2));
        Assert.assertEquals((String)"wrong hop 3", (Object)TARGET1, (Object)route.getHopTarget(3));
        Assert.assertFalse((String)"wrong flag: secured", (boolean)route.isSecure());
        Assert.assertFalse((String)"wrong flag: tunnelled", (boolean)route.isTunnelled());
        Assert.assertFalse((String)"wrong flag: layered", (boolean)route.isLayered());
        String routestr = route.toString();
        Assert.assertTrue((String)"missing target in toString", (boolean)routestr.contains(TARGET1.getHostName()));
        Assert.assertTrue((String)"missing local address in toString", (boolean)routestr.contains(LOCAL41.toString()));
        Assert.assertTrue((String)"missing proxy 1 in toString", (boolean)routestr.contains(PROXY1.getHostName()));
        Assert.assertTrue((String)"missing proxy 2 in toString", (boolean)routestr.contains(PROXY2.getHostName()));
        Assert.assertTrue((String)"missing proxy 3 in toString", (boolean)routestr.contains(PROXY3.getHostName()));
    }

    @Test
    public void testCstrFullFlags() {
        HttpHost[] chain3 = new HttpHost[]{PROXY1, PROXY2, PROXY3};
        HttpRoute routefff = new HttpRoute(TARGET1, LOCAL41, chain3, false, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        HttpRoute routefft = new HttpRoute(TARGET1, LOCAL41, chain3, false, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.LAYERED);
        HttpRoute routeftf = new HttpRoute(TARGET1, LOCAL41, chain3, false, RouteInfo.TunnelType.TUNNELLED, RouteInfo.LayerType.PLAIN);
        HttpRoute routeftt = new HttpRoute(TARGET1, LOCAL41, chain3, false, RouteInfo.TunnelType.TUNNELLED, RouteInfo.LayerType.LAYERED);
        HttpRoute routetff = new HttpRoute(TARGET1, LOCAL41, chain3, true, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        HttpRoute routetft = new HttpRoute(TARGET1, LOCAL41, chain3, true, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.LAYERED);
        HttpRoute routettf = new HttpRoute(TARGET1, LOCAL41, chain3, true, RouteInfo.TunnelType.TUNNELLED, RouteInfo.LayerType.PLAIN);
        HttpRoute routettt = new HttpRoute(TARGET1, LOCAL41, chain3, true, RouteInfo.TunnelType.TUNNELLED, RouteInfo.LayerType.LAYERED);
        Assert.assertFalse((String)"routefff.secure", (boolean)routefff.isSecure());
        Assert.assertFalse((String)"routefff.tunnel", (boolean)routefff.isTunnelled());
        Assert.assertFalse((String)"routefff.layer", (boolean)routefff.isLayered());
        Assert.assertFalse((String)"routefft.secure", (boolean)routefft.isSecure());
        Assert.assertFalse((String)"routefft.tunnel", (boolean)routefft.isTunnelled());
        Assert.assertTrue((String)"routefft.layer", (boolean)routefft.isLayered());
        Assert.assertFalse((String)"routeftf.secure", (boolean)routeftf.isSecure());
        Assert.assertTrue((String)"routeftf.tunnel", (boolean)routeftf.isTunnelled());
        Assert.assertFalse((String)"routeftf.layer", (boolean)routeftf.isLayered());
        Assert.assertFalse((String)"routeftt.secure", (boolean)routeftt.isSecure());
        Assert.assertTrue((String)"routeftt.tunnel", (boolean)routeftt.isTunnelled());
        Assert.assertTrue((String)"routeftt.layer", (boolean)routeftt.isLayered());
        Assert.assertTrue((String)"routetff.secure", (boolean)routetff.isSecure());
        Assert.assertFalse((String)"routetff.tunnel", (boolean)routetff.isTunnelled());
        Assert.assertFalse((String)"routetff.layer", (boolean)routetff.isLayered());
        Assert.assertTrue((String)"routetft.secure", (boolean)routetft.isSecure());
        Assert.assertFalse((String)"routetft.tunnel", (boolean)routetft.isTunnelled());
        Assert.assertTrue((String)"routetft.layer", (boolean)routetft.isLayered());
        Assert.assertTrue((String)"routettf.secure", (boolean)routettf.isSecure());
        Assert.assertTrue((String)"routettf.tunnel", (boolean)routettf.isTunnelled());
        Assert.assertFalse((String)"routettf.layer", (boolean)routettf.isLayered());
        Assert.assertTrue((String)"routettt.secure", (boolean)routettt.isSecure());
        Assert.assertTrue((String)"routettt.tunnel", (boolean)routettt.isTunnelled());
        Assert.assertTrue((String)"routettt.layer", (boolean)routettt.isLayered());
        HashSet<HttpRoute> routes = new HashSet<HttpRoute>();
        routes.add(routefff);
        routes.add(routefft);
        routes.add(routeftf);
        routes.add(routeftt);
        routes.add(routetff);
        routes.add(routetft);
        routes.add(routettf);
        routes.add(routettt);
        Assert.assertEquals((String)"some flagged routes are equal", (long)8L, (long)routes.size());
        HashSet<Integer> routecodes = new HashSet<Integer>();
        routecodes.add(routefff.hashCode());
        routecodes.add(routefft.hashCode());
        routecodes.add(routeftf.hashCode());
        routecodes.add(routeftt.hashCode());
        routecodes.add(routetff.hashCode());
        routecodes.add(routetft.hashCode());
        routecodes.add(routettf.hashCode());
        routecodes.add(routettt.hashCode());
        Assert.assertEquals((String)"some flagged routes have same hashCode", (long)8L, (long)routecodes.size());
        HashSet<String> routestrings = new HashSet<String>();
        routestrings.add(routefff.toString());
        routestrings.add(routefft.toString());
        routestrings.add(routeftf.toString());
        routestrings.add(routeftt.toString());
        routestrings.add(routetff.toString());
        routestrings.add(routetft.toString());
        routestrings.add(routettf.toString());
        routestrings.add(routettt.toString());
        Assert.assertEquals((String)"some flagged route.toString() are equal", (long)8L, (long)routestrings.size());
    }

    @Test
    public void testInvalidArguments() {
        HttpHost[] chain1 = new HttpHost[]{PROXY1};
        HttpRoute route = new HttpRoute(TARGET1, null, chain1, false, RouteInfo.TunnelType.TUNNELLED, RouteInfo.LayerType.PLAIN);
        Assert.assertNotNull((Object)route);
        try {
            new HttpRoute(null, null, chain1, false, RouteInfo.TunnelType.TUNNELLED, RouteInfo.LayerType.PLAIN);
            Assert.fail((String)"missing target not detected");
        }
        catch (NullPointerException iax) {
            // empty catch block
        }
        try {
            new HttpRoute(TARGET1, null, (HttpHost[])null, false, RouteInfo.TunnelType.TUNNELLED, RouteInfo.LayerType.PLAIN);
            Assert.fail((String)"missing proxy for tunnel not detected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testNullEnums() {
        HttpRoute route = new HttpRoute(TARGET1, null, PROXY1, false, null, null);
        Assert.assertFalse((String)"default tunnelling", (boolean)route.isTunnelled());
        Assert.assertEquals((String)"untunnelled", (Object)RouteInfo.TunnelType.PLAIN, (Object)route.getTunnelType());
        Assert.assertFalse((String)"default layering", (boolean)route.isLayered());
        Assert.assertEquals((String)"unlayered", (Object)RouteInfo.LayerType.PLAIN, (Object)route.getLayerType());
    }

    @Test
    public void testEqualsHashcodeClone() throws CloneNotSupportedException {
        HttpHost[] chain0 = new HttpHost[]{};
        HttpHost[] chain1 = new HttpHost[]{PROXY1};
        HttpHost[] chain3 = new HttpHost[]{PROXY1, PROXY2, PROXY3};
        HttpHost[] chain4 = new HttpHost[]{PROXY1, PROXY3, PROXY2};
        HttpRoute route1a = new HttpRoute(TARGET1, LOCAL41, chain3, false, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        HttpRoute route1b = new HttpRoute(TARGET1, LOCAL41, chain3, false, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        HttpRoute route1c = (HttpRoute)route1a.clone();
        Assert.assertEquals((String)"1a 1a", (Object)route1a, (Object)route1a);
        Assert.assertEquals((String)"1a 1b", (Object)route1a, (Object)route1b);
        Assert.assertEquals((String)"1a 1c", (Object)route1a, (Object)route1c);
        Assert.assertEquals((String)"hashcode 1a", (long)route1a.hashCode(), (long)route1a.hashCode());
        Assert.assertEquals((String)"hashcode 1b", (long)route1a.hashCode(), (long)route1b.hashCode());
        Assert.assertEquals((String)"hashcode 1c", (long)route1a.hashCode(), (long)route1c.hashCode());
        Assert.assertEquals((String)"toString 1a", (Object)route1a.toString(), (Object)route1a.toString());
        Assert.assertEquals((String)"toString 1b", (Object)route1a.toString(), (Object)route1b.toString());
        Assert.assertEquals((String)"toString 1c", (Object)route1a.toString(), (Object)route1c.toString());
        HttpRoute route2a = new HttpRoute(TARGET2, LOCAL41, chain3, false, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        HttpRoute route2b = new HttpRoute(TARGET1, LOCAL42, chain3, false, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        HttpRoute route2c = new HttpRoute(TARGET1, LOCAL61, chain3, false, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        HttpRoute route2d = new HttpRoute(TARGET1, null, chain3, false, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        HttpRoute route2e = new HttpRoute(TARGET1, LOCAL41, (HttpHost[])null, false, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        HttpRoute route2f = new HttpRoute(TARGET1, LOCAL41, chain0, false, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        HttpRoute route2g = new HttpRoute(TARGET1, LOCAL41, chain1, false, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        HttpRoute route2h = new HttpRoute(TARGET1, LOCAL41, chain4, false, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        HttpRoute route2i = new HttpRoute(TARGET1, LOCAL41, chain3, true, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        HttpRoute route2j = new HttpRoute(TARGET1, LOCAL41, chain3, false, RouteInfo.TunnelType.TUNNELLED, RouteInfo.LayerType.PLAIN);
        HttpRoute route2k = new HttpRoute(TARGET1, LOCAL41, chain3, false, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.LAYERED);
        Assert.assertEquals((String)"2e 2f", (Object)route2e, (Object)route2f);
        Assert.assertEquals((String)"hashcode 2e 2f", (long)route2e.hashCode(), (long)route2f.hashCode());
        Assert.assertEquals((String)"toString 2e 2f", (Object)route2e.toString(), (Object)route2f.toString());
        Assert.assertFalse((String)"1a 2a", (boolean)route1a.equals((Object)route2a));
        Assert.assertFalse((String)"1a 2b", (boolean)route1a.equals((Object)route2b));
        Assert.assertFalse((String)"1a 2c", (boolean)route1a.equals((Object)route2c));
        Assert.assertFalse((String)"1a 2d", (boolean)route1a.equals((Object)route2d));
        Assert.assertFalse((String)"1a 2e", (boolean)route1a.equals((Object)route2e));
        Assert.assertFalse((String)"1a 2f", (boolean)route1a.equals((Object)route2f));
        Assert.assertFalse((String)"1a 2g", (boolean)route1a.equals((Object)route2g));
        Assert.assertFalse((String)"1a 2h", (boolean)route1a.equals((Object)route2h));
        Assert.assertFalse((String)"1a 2i", (boolean)route1a.equals((Object)route2i));
        Assert.assertFalse((String)"1a 2j", (boolean)route1a.equals((Object)route2j));
        Assert.assertFalse((String)"1a 2k", (boolean)route1a.equals((Object)route2k));
        Assert.assertFalse((String)"2a 1a", (boolean)route2a.equals((Object)route1a));
        Assert.assertFalse((String)"2b 1a", (boolean)route2b.equals((Object)route1a));
        Assert.assertFalse((String)"2c 1a", (boolean)route2c.equals((Object)route1a));
        Assert.assertFalse((String)"2d 1a", (boolean)route2d.equals((Object)route1a));
        Assert.assertFalse((String)"2e 1a", (boolean)route2e.equals((Object)route1a));
        Assert.assertFalse((String)"2f 1a", (boolean)route2f.equals((Object)route1a));
        Assert.assertFalse((String)"2g 1a", (boolean)route2g.equals((Object)route1a));
        Assert.assertFalse((String)"2h 1a", (boolean)route2h.equals((Object)route1a));
        Assert.assertFalse((String)"2i 1a", (boolean)route2i.equals((Object)route1a));
        Assert.assertFalse((String)"2j 1a", (boolean)route2j.equals((Object)route1a));
        Assert.assertFalse((String)"2k 1a", (boolean)route2k.equals((Object)route1a));
        Assert.assertFalse((String)"toString 1a 2a", (boolean)route1a.toString().equals(route2a.toString()));
        Assert.assertFalse((String)"toString 1a 2b", (boolean)route1a.toString().equals(route2b.toString()));
        Assert.assertFalse((String)"toString 1a 2c", (boolean)route1a.toString().equals(route2c.toString()));
        Assert.assertFalse((String)"toString 1a 2d", (boolean)route1a.toString().equals(route2d.toString()));
        Assert.assertFalse((String)"toString 1a 2e", (boolean)route1a.toString().equals(route2e.toString()));
        Assert.assertFalse((String)"toString 1a 2f", (boolean)route1a.toString().equals(route2f.toString()));
        Assert.assertFalse((String)"toString 1a 2g", (boolean)route1a.toString().equals(route2g.toString()));
        Assert.assertFalse((String)"toString 1a 2h", (boolean)route1a.toString().equals(route2h.toString()));
        Assert.assertFalse((String)"toString 1a 2i", (boolean)route1a.toString().equals(route2i.toString()));
        Assert.assertFalse((String)"toString 1a 2j", (boolean)route1a.toString().equals(route2j.toString()));
        Assert.assertFalse((String)"toString 1a 2k", (boolean)route1a.toString().equals(route2k.toString()));
        HashSet<HttpRoute> routes = new HashSet<HttpRoute>();
        routes.add(route1a);
        routes.add(route2a);
        routes.add(route2b);
        routes.add(route2c);
        routes.add(route2d);
        routes.add(route2e);
        routes.add(route2g);
        routes.add(route2h);
        routes.add(route2i);
        routes.add(route2j);
        routes.add(route2k);
        Assert.assertEquals((String)"some routes are equal", (long)11L, (long)routes.size());
        for (HttpRoute origin : routes) {
            HttpRoute cloned = (HttpRoute)origin.clone();
            Assert.assertEquals((String)("clone of " + origin), (Object)origin, (Object)cloned);
            Assert.assertTrue((String)("clone of " + origin), (boolean)routes.contains(cloned));
        }
        HashSet<String> routestrings = new HashSet<String>();
        routestrings.add(route1a.toString());
        routestrings.add(route2a.toString());
        routestrings.add(route2b.toString());
        routestrings.add(route2c.toString());
        routestrings.add(route2d.toString());
        routestrings.add(route2e.toString());
        routestrings.add(route2g.toString());
        routestrings.add(route2h.toString());
        routestrings.add(route2i.toString());
        routestrings.add(route2j.toString());
        routestrings.add(route2k.toString());
        Assert.assertEquals((String)"some route.toString() are equal", (long)11L, (long)routestrings.size());
        Assert.assertFalse((String)"route equals null", (boolean)route1a.equals(null));
        Assert.assertFalse((String)"route equals string", (boolean)route1a.equals((Object)"route1a"));
    }

    @Test
    public void testHopping() {
        HttpHost before;
        HttpHost beyond;
        HttpHost[] proxies = null;
        HttpRoute route = new HttpRoute(TARGET1, null, proxies, true, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        Assert.assertEquals((String)"A: hop count", (long)1L, (long)route.getHopCount());
        Assert.assertEquals((String)"A: hop 0", (Object)TARGET1, (Object)route.getHopTarget(0));
        try {
            beyond = route.getHopTarget(1);
            Assert.fail((String)("A: hop 1 is " + beyond));
        }
        catch (IllegalArgumentException iax) {
            // empty catch block
        }
        try {
            before = route.getHopTarget(-1);
            Assert.fail((String)("A: hop -1 is " + before));
        }
        catch (IllegalArgumentException iax) {
            // empty catch block
        }
        proxies = new HttpHost[]{PROXY3};
        route = new HttpRoute(TARGET1, LOCAL62, proxies, false, RouteInfo.TunnelType.TUNNELLED, RouteInfo.LayerType.PLAIN);
        Assert.assertEquals((String)"B: hop count", (long)2L, (long)route.getHopCount());
        Assert.assertEquals((String)"B: hop 0", (Object)PROXY3, (Object)route.getHopTarget(0));
        Assert.assertEquals((String)"B: hop 1", (Object)TARGET1, (Object)route.getHopTarget(1));
        try {
            beyond = route.getHopTarget(2);
            Assert.fail((String)("B: hop 2 is " + beyond));
        }
        catch (IllegalArgumentException iax) {
            // empty catch block
        }
        try {
            before = route.getHopTarget(-2);
            Assert.fail((String)("B: hop -2 is " + before));
        }
        catch (IllegalArgumentException iax) {
            // empty catch block
        }
        proxies = new HttpHost[]{PROXY3, PROXY1, PROXY2};
        route = new HttpRoute(TARGET1, LOCAL42, proxies, false, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.LAYERED);
        Assert.assertEquals((String)"C: hop count", (long)4L, (long)route.getHopCount());
        Assert.assertEquals((String)"C: hop 0", (Object)PROXY3, (Object)route.getHopTarget(0));
        Assert.assertEquals((String)"C: hop 1", (Object)PROXY1, (Object)route.getHopTarget(1));
        Assert.assertEquals((String)"C: hop 2", (Object)PROXY2, (Object)route.getHopTarget(2));
        Assert.assertEquals((String)"C: hop 3", (Object)TARGET1, (Object)route.getHopTarget(3));
        try {
            beyond = route.getHopTarget(4);
            Assert.fail((String)("C: hop 4 is " + beyond));
        }
        catch (IllegalArgumentException iax) {
            // empty catch block
        }
        try {
            before = route.getHopTarget(Integer.MIN_VALUE);
            Assert.fail((String)("C: hop -<min> is " + before));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testCstr1() {
        HttpRoute route = new HttpRoute(TARGET2);
        HttpRoute should = new HttpRoute(TARGET2, null, (HttpHost[])null, false, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        Assert.assertEquals((String)"bad convenience route", (Object)route, (Object)should);
    }

    @Test
    public void testCstr3() {
        HttpRoute route = new HttpRoute(TARGET2, LOCAL61, false);
        HttpRoute should = new HttpRoute(TARGET2, LOCAL61, (HttpHost[])null, false, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        Assert.assertEquals((String)"bad convenience route 3/insecure", (Object)route, (Object)should);
        route = new HttpRoute(TARGET2, null, true);
        should = new HttpRoute(TARGET2, null, (HttpHost[])null, true, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        Assert.assertEquals((String)"bad convenience route 3/secure", (Object)route, (Object)should);
    }

    @Test
    public void testCstr4() {
        HttpRoute route = new HttpRoute(TARGET2, null, PROXY2, false);
        HttpRoute should = new HttpRoute(TARGET2, null, new HttpHost[]{PROXY2}, false, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        Assert.assertEquals((String)"bad convenience route 4/insecure", (Object)route, (Object)should);
        route = new HttpRoute(TARGET2, LOCAL42, PROXY1, true);
        should = new HttpRoute(TARGET2, LOCAL42, new HttpHost[]{PROXY1}, true, RouteInfo.TunnelType.TUNNELLED, RouteInfo.LayerType.LAYERED);
        Assert.assertEquals((String)"bad convenience route 4/secure", (Object)route, (Object)should);
        try {
            new HttpRoute(TARGET1, LOCAL61, null, false);
            Assert.fail((String)"missing proxy not detected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testCstr6() {
        HttpRoute route = new HttpRoute(TARGET2, null, PROXY2, true, RouteInfo.TunnelType.TUNNELLED, RouteInfo.LayerType.PLAIN);
        HttpRoute should = new HttpRoute(TARGET2, null, new HttpHost[]{PROXY2}, true, RouteInfo.TunnelType.TUNNELLED, RouteInfo.LayerType.PLAIN);
        Assert.assertEquals((String)"bad convenience route 6/proxied", (Object)route, (Object)should);
        route = new HttpRoute(TARGET2, null, (HttpHost)null, true, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.LAYERED);
        should = new HttpRoute(TARGET2, null, (HttpHost[])null, true, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.LAYERED);
        Assert.assertEquals((String)"bad convenience route 6/direct", (Object)route, (Object)should);
    }

    @Test
    public void testImmutable() throws CloneNotSupportedException {
        HttpHost[] proxies = new HttpHost[]{PROXY1, PROXY2, PROXY3};
        HttpRoute route1 = new HttpRoute(TARGET1, null, proxies, false, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        HttpRoute route2 = (HttpRoute)route1.clone();
        HttpRoute route3 = new HttpRoute(TARGET1, null, (HttpHost[])proxies.clone(), false, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        proxies[1] = PROXY3;
        proxies[2] = PROXY2;
        Assert.assertEquals((String)"route differs from clone", (Object)route2, (Object)route1);
        Assert.assertEquals((String)"route was modified", (Object)route3, (Object)route1);
    }

    static {
        try {
            LOCAL41 = InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
            LOCAL42 = InetAddress.getByAddress(new byte[]{127, 0, 0, 2});
            LOCAL61 = InetAddress.getByAddress(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1});
            LOCAL62 = InetAddress.getByAddress(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2});
        }
        catch (Exception x) {
            throw new ExceptionInInitializerError(x);
        }
    }
}

