/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.ssl;

import java.util.Arrays;
import org.apache.hc.client5.http.ssl.DistinguishedNameParser;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDistinguishedNameParser {
    private DistinguishedNameParser impl;

    @Before
    public void setup() {
        this.impl = new DistinguishedNameParser();
    }

    @Test
    public void testParseBasic() throws Exception {
        Assert.assertThat((Object)this.impl.parse("cn=blah, ou=yada, o=booh"), (Matcher)CoreMatchers.equalTo(Arrays.asList(new BasicNameValuePair("cn", "blah"), new BasicNameValuePair("ou", "yada"), new BasicNameValuePair("o", "booh"))));
    }

    @Test
    public void testParseRepeatedElements() throws Exception {
        Assert.assertThat((Object)this.impl.parse("cn=blah, cn=yada, cn=booh"), (Matcher)CoreMatchers.equalTo(Arrays.asList(new BasicNameValuePair("cn", "blah"), new BasicNameValuePair("cn", "yada"), new BasicNameValuePair("cn", "booh"))));
    }

    @Test
    public void testParseBlanks() throws Exception {
        Assert.assertThat((Object)this.impl.parse("c = pampa ,  cn  =    blah    , ou = blah , o = blah"), (Matcher)CoreMatchers.equalTo(Arrays.asList(new BasicNameValuePair("c", "pampa"), new BasicNameValuePair("cn", "blah"), new BasicNameValuePair("ou", "blah"), new BasicNameValuePair("o", "blah"))));
    }

    @Test
    public void testParseQuotes() throws Exception {
        Assert.assertThat((Object)this.impl.parse("cn=\"blah\", ou=yada, o=booh"), (Matcher)CoreMatchers.equalTo(Arrays.asList(new BasicNameValuePair("cn", "blah"), new BasicNameValuePair("ou", "yada"), new BasicNameValuePair("o", "booh"))));
    }

    @Test
    public void testParseQuotes2() throws Exception {
        Assert.assertThat((Object)this.impl.parse("cn=\"blah  blah\", ou=yada, o=booh"), (Matcher)CoreMatchers.equalTo(Arrays.asList(new BasicNameValuePair("cn", "blah  blah"), new BasicNameValuePair("ou", "yada"), new BasicNameValuePair("o", "booh"))));
    }

    @Test
    public void testParseQuotes3() throws Exception {
        Assert.assertThat((Object)this.impl.parse("cn=\"blah, blah\", ou=yada, o=booh"), (Matcher)CoreMatchers.equalTo(Arrays.asList(new BasicNameValuePair("cn", "blah, blah"), new BasicNameValuePair("ou", "yada"), new BasicNameValuePair("o", "booh"))));
    }

    @Test
    public void testParseEscape() throws Exception {
        Assert.assertThat((Object)this.impl.parse("cn=blah\\, blah, ou=yada, o=booh"), (Matcher)CoreMatchers.equalTo(Arrays.asList(new BasicNameValuePair("cn", "blah, blah"), new BasicNameValuePair("ou", "yada"), new BasicNameValuePair("o", "booh"))));
    }

    @Test
    public void testParseUnescapedEqual() throws Exception {
        Assert.assertThat((Object)this.impl.parse("c = cn=uuh, cn=blah, ou=yada, o=booh"), (Matcher)CoreMatchers.equalTo(Arrays.asList(new BasicNameValuePair("c", "cn=uuh"), new BasicNameValuePair("cn", "blah"), new BasicNameValuePair("ou", "yada"), new BasicNameValuePair("o", "booh"))));
    }

    @Test
    public void testParseInvalid() throws Exception {
        Assert.assertThat((Object)this.impl.parse("blah,blah"), (Matcher)CoreMatchers.equalTo(Arrays.asList(new BasicNameValuePair("blah", null), new BasicNameValuePair("blah", null))));
    }

    @Test
    public void testParseInvalid2() throws Exception {
        Assert.assertThat((Object)this.impl.parse("cn,o=blah"), (Matcher)CoreMatchers.equalTo(Arrays.asList(new BasicNameValuePair("cn", null), new BasicNameValuePair("o", "blah"))));
    }
}

