/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.utils;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import org.apache.hc.client5.http.utils.URIUtils;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.net.URIBuilder;
import org.junit.Assert;
import org.junit.Test;

public class TestURIUtils {
    private final URI baseURI = URI.create("http://a/b/c/d;p?q");

    @Test
    public void testNormalization() {
        Assert.assertEquals((Object)"example://a/b/c/%7Bfoo%7D", (Object)URIUtils.resolve((URI)this.baseURI, (String)"eXAMPLE://a/./b/../b/%63/%7bfoo%7d").toString());
        Assert.assertEquals((Object)"http://www.example.com/%3C", (Object)URIUtils.resolve((URI)this.baseURI, (String)"http://www.example.com/%3c").toString());
        Assert.assertEquals((Object)"http://www.example.com/", (Object)URIUtils.resolve((URI)this.baseURI, (String)"HTTP://www.EXAMPLE.com/").toString());
        Assert.assertEquals((Object)"http://www.example.com/a%2F", (Object)URIUtils.resolve((URI)this.baseURI, (String)"http://www.example.com/a%2f").toString());
        Assert.assertEquals((Object)"http://www.example.com/?q=%26", (Object)URIUtils.resolve((URI)this.baseURI, (String)"http://www.example.com/?q=%26").toString());
        Assert.assertEquals((Object)"http://www.example.com/%23?q=%26", (Object)URIUtils.resolve((URI)this.baseURI, (String)"http://www.example.com/%23?q=%26").toString());
        Assert.assertEquals((Object)"http://www.example.com/blah-%28%20-blah-%20%26%20-blah-%20%29-blah/", (Object)URIUtils.resolve((URI)this.baseURI, (String)"http://www.example.com/blah-%28%20-blah-%20&%20-blah-%20)-blah/").toString());
    }

    @Test
    public void testResolve() {
        Assert.assertEquals((Object)"g:h", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g:h").toString());
        Assert.assertEquals((Object)"http://a/b/c/g", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g").toString());
        Assert.assertEquals((Object)"http://a/b/c/g", (Object)URIUtils.resolve((URI)this.baseURI, (String)"./g").toString());
        Assert.assertEquals((Object)"http://a/b/c/g/", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g/").toString());
        Assert.assertEquals((Object)"http://a/g", (Object)URIUtils.resolve((URI)this.baseURI, (String)"/g").toString());
        Assert.assertEquals((Object)"http://g/", (Object)URIUtils.resolve((URI)this.baseURI, (String)"//g").toString());
        Assert.assertEquals((Object)"http://a/b/c/d;p?y", (Object)URIUtils.resolve((URI)this.baseURI, (String)"?y").toString());
        Assert.assertEquals((Object)"http://a/b/c/d;p?y#f", (Object)URIUtils.resolve((URI)this.baseURI, (String)"?y#f").toString());
        Assert.assertEquals((Object)"http://a/b/c/g?y", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g?y").toString());
        Assert.assertEquals((Object)"http://a/b/c/d%3Bp?q#s", (Object)URIUtils.resolve((URI)this.baseURI, (String)"#s").toString());
        Assert.assertEquals((Object)"http://a/b/c/g#s", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g#s").toString());
        Assert.assertEquals((Object)"http://a/b/c/g?y#s", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g?y#s").toString());
        Assert.assertEquals((Object)"http://a/b/c/%3Bx", (Object)URIUtils.resolve((URI)this.baseURI, (String)";x").toString());
        Assert.assertEquals((Object)"http://a/b/c/g%3Bx", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g;x").toString());
        Assert.assertEquals((Object)"http://a/b/c/g%3Bx?y#s", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g;x?y#s").toString());
        Assert.assertEquals((Object)"http://a/b/c/d%3Bp?q", (Object)URIUtils.resolve((URI)this.baseURI, (String)"").toString());
        Assert.assertEquals((Object)"http://a/b/c/", (Object)URIUtils.resolve((URI)this.baseURI, (String)".").toString());
        Assert.assertEquals((Object)"http://a/b/c/", (Object)URIUtils.resolve((URI)this.baseURI, (String)"./").toString());
        Assert.assertEquals((Object)"http://a/b/", (Object)URIUtils.resolve((URI)this.baseURI, (String)"..").toString());
        Assert.assertEquals((Object)"http://a/b/", (Object)URIUtils.resolve((URI)this.baseURI, (String)"../").toString());
        Assert.assertEquals((Object)"http://a/b/g", (Object)URIUtils.resolve((URI)this.baseURI, (String)"../g").toString());
        Assert.assertEquals((Object)"http://a/", (Object)URIUtils.resolve((URI)this.baseURI, (String)"../..").toString());
        Assert.assertEquals((Object)"http://a/", (Object)URIUtils.resolve((URI)this.baseURI, (String)"../../").toString());
        Assert.assertEquals((Object)"http://a/g", (Object)URIUtils.resolve((URI)this.baseURI, (String)"../../g").toString());
        Assert.assertEquals((Object)"http://a/g", (Object)URIUtils.resolve((URI)this.baseURI, (String)"../../../g").toString());
        Assert.assertEquals((Object)"http://a/g", (Object)URIUtils.resolve((URI)this.baseURI, (String)"../../../../g").toString());
        Assert.assertEquals((Object)"http://a/g", (Object)URIUtils.resolve((URI)this.baseURI, (String)"/./g").toString());
        Assert.assertEquals((Object)"http://a/g", (Object)URIUtils.resolve((URI)this.baseURI, (String)"/../g").toString());
        Assert.assertEquals((Object)"http://a/b/c/g.", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g.").toString());
        Assert.assertEquals((Object)"http://a/b/c/.g", (Object)URIUtils.resolve((URI)this.baseURI, (String)".g").toString());
        Assert.assertEquals((Object)"http://a/b/c/g..", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g..").toString());
        Assert.assertEquals((Object)"http://a/b/c/..g", (Object)URIUtils.resolve((URI)this.baseURI, (String)"..g").toString());
        Assert.assertEquals((Object)"http://a/b/g", (Object)URIUtils.resolve((URI)this.baseURI, (String)"./../g").toString());
        Assert.assertEquals((Object)"http://a/b/c/g/", (Object)URIUtils.resolve((URI)this.baseURI, (String)"./g/.").toString());
        Assert.assertEquals((Object)"http://a/b/c/g/h", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g/./h").toString());
        Assert.assertEquals((Object)"http://a/b/c/h", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g/../h").toString());
        Assert.assertEquals((Object)"http://a/b/c/g%3Bx%3D1/y", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g;x=1/./y").toString());
        Assert.assertEquals((Object)"http://a/b/c/y", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g;x=1/../y").toString());
        Assert.assertEquals((Object)"http://a/b/c/g?y%2F.%2Fx", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g?y/./x").toString());
        Assert.assertEquals((Object)"http://a/b/c/g?y%2F..%2Fx", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g?y/../x").toString());
        Assert.assertEquals((Object)"http://a/b/c/g#s%2F.%2Fx", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g#s/./x").toString());
        Assert.assertEquals((Object)"http://a/b/c/g#s%2F..%2Fx", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g#s/../x").toString());
        Assert.assertEquals((Object)"http:g", (Object)URIUtils.resolve((URI)this.baseURI, (String)"http:g").toString());
        Assert.assertEquals((Object)"http://s/a/g", (Object)URIUtils.resolve((URI)this.baseURI, (String)"http://s/a/b/c/./../../g").toString());
        Assert.assertEquals((Object)"http://s/mid/6", (Object)URIUtils.resolve((URI)this.baseURI, (String)"http://s/mid/content=5/../6").toString());
    }

    @Test
    public void testResolveOpaque() {
        Assert.assertEquals((Object)"example://a/b/c/%7Bfoo%7D", (Object)URIUtils.resolve((URI)this.baseURI, (String)"eXAMPLE://a/./b/../b/%63/%7bfoo%7d").toString());
        Assert.assertEquals((Object)"file://localhost/etc/fstab", (Object)URIUtils.resolve((URI)this.baseURI, (String)"file://localhost/etc/fstab").toString());
        Assert.assertEquals((Object)"file:///etc/fstab", (Object)URIUtils.resolve((URI)this.baseURI, (String)"file:///etc/fstab").toString());
        Assert.assertEquals((Object)"file://localhost/c%3A/WINDOWS/clock.avi", (Object)URIUtils.resolve((URI)this.baseURI, (String)"file://localhost/c:/WINDOWS/clock.avi").toString());
        Assert.assertEquals((Object)"file:///c:/WINDOWS/clock.avi", (Object)URIUtils.resolve((URI)this.baseURI, (String)"file:///c:/WINDOWS/clock.avi").toString());
        Assert.assertEquals((Object)"file://hostname/path/to/the%20file.txt", (Object)URIUtils.resolve((URI)this.baseURI, (String)"file://hostname/path/to/the%20file.txt").toString());
        Assert.assertEquals((Object)"file:///c:/path/to/the%20file.txt", (Object)URIUtils.resolve((URI)this.baseURI, (String)"file:///c:/path/to/the%20file.txt").toString());
        Assert.assertEquals((Object)"urn:issn:1535-3613", (Object)URIUtils.resolve((URI)this.baseURI, (String)"urn:issn:1535-3613").toString());
        Assert.assertEquals((Object)"mailto:user@example.com", (Object)URIUtils.resolve((URI)this.baseURI, (String)"mailto:user@example.com").toString());
        Assert.assertEquals((Object)"ftp://example.org/resource.txt", (Object)URIUtils.resolve((URI)this.baseURI, (String)"ftp://example.org/resource.txt").toString());
    }

    @Test
    public void testExtractHost() throws Exception {
        Assert.assertEquals((Object)new HttpHost("localhost"), (Object)URIUtils.extractHost((URI)new URI("http://localhost/abcd")));
        Assert.assertEquals((Object)new HttpHost("localhost"), (Object)URIUtils.extractHost((URI)new URI("http://localhost/abcd%3A")));
        Assert.assertEquals((Object)new HttpHost("local_host"), (Object)URIUtils.extractHost((URI)new URI("http://local_host/abcd")));
        Assert.assertEquals((Object)new HttpHost("local_host"), (Object)URIUtils.extractHost((URI)new URI("http://local_host/abcd%3A")));
        Assert.assertEquals((Object)new HttpHost("localhost", 8), (Object)URIUtils.extractHost((URI)new URI("http://localhost:8/abcd")));
        Assert.assertEquals((Object)new HttpHost("local_host", 8), (Object)URIUtils.extractHost((URI)new URI("http://local_host:8/abcd")));
        Assert.assertEquals((Object)new HttpHost("localhost", -1), (Object)URIUtils.extractHost((URI)new URI("http://localhost:/abcd")));
        Assert.assertEquals((Object)new HttpHost("local_host", -1), (Object)URIUtils.extractHost((URI)new URI("http://local_host:/abcd")));
        Assert.assertEquals((Object)new HttpHost("localhost", 8080), (Object)URIUtils.extractHost((URI)new URI("http://user:pass@localhost:8080/abcd")));
        Assert.assertEquals((Object)new HttpHost("local_host", 8080), (Object)URIUtils.extractHost((URI)new URI("http://user:pass@local_host:8080/abcd")));
        Assert.assertEquals((Object)new HttpHost("localhost", 8080), (Object)URIUtils.extractHost((URI)new URI("http://@localhost:8080/abcd")));
        Assert.assertEquals((Object)new HttpHost("local_host", 8080), (Object)URIUtils.extractHost((URI)new URI("http://@local_host:8080/abcd")));
        Assert.assertEquals((Object)new HttpHost("2a00:1450:400c:c01::69", 8080), (Object)URIUtils.extractHost((URI)new URI("http://[2a00:1450:400c:c01::69]:8080/")));
        Assert.assertEquals((Object)new HttpHost("localhost", 8080), (Object)URIUtils.extractHost((URI)new URI("http://localhost:8080/;sessionid=stuff/abcd")));
        Assert.assertEquals(null, (Object)URIUtils.extractHost((URI)new URI("http://localhost:8080;sessionid=stuff/abcd")));
        Assert.assertEquals(null, (Object)URIUtils.extractHost((URI)new URI("http://localhost:;sessionid=stuff/abcd")));
        Assert.assertEquals(null, (Object)URIUtils.extractHost((URI)new URI("http://:80/robots.txt")));
        Assert.assertEquals(null, (Object)URIUtils.extractHost((URI)new URI("http://some%20domain:80/robots.txt")));
    }

    @Test
    public void testHttpLocationWithRelativeFragment() throws Exception {
        HttpHost target = new HttpHost("http", "localhost", -1);
        URI requestURI = new URI("/stuff#blahblah");
        URI location = URIUtils.resolve((URI)requestURI, (HttpHost)target, null);
        URI expectedURI = new URIBuilder(requestURI).setHost(target.getHostName()).setScheme(target.getSchemeName()).build();
        Assert.assertEquals((Object)expectedURI, (Object)location);
    }

    @Test
    public void testHttpLocationWithAbsoluteFragment() throws Exception {
        HttpHost target = new HttpHost("http", "localhost", 80);
        URI requestURI = new URIBuilder().setHost(target.getHostName()).setScheme(target.getSchemeName()).setPath("/stuff").setFragment("blahblah").build();
        URI location = URIUtils.resolve((URI)requestURI, (HttpHost)target, null);
        URI expectedURI = requestURI;
        Assert.assertEquals((Object)expectedURI, (Object)location);
    }

    @Test
    public void testHttpLocationRedirect() throws Exception {
        HttpHost target = new HttpHost("http", "localhost", -1);
        URI requestURI = new URI("/People.htm#tim");
        URI redirect = new URI("http://localhost/people.html");
        URI location = URIUtils.resolve((URI)requestURI, (HttpHost)target, Collections.singletonList(redirect));
        URI expectedURI = new URIBuilder().setHost(target.getHostName()).setScheme(target.getSchemeName()).setPath("/people.html").setFragment("tim").build();
        Assert.assertEquals((Object)expectedURI, (Object)location);
    }

    @Test
    public void testHttpLocationWithRedirectFragment() throws Exception {
        HttpHost target = new HttpHost("http", "localhost", -1);
        URI requestURI = new URI("/~tim");
        URI redirect1 = new URI("http://localhost/People.htm#tim");
        URI redirect2 = new URI("http://localhost/people.html");
        URI location = URIUtils.resolve((URI)requestURI, (HttpHost)target, Arrays.asList(redirect1, redirect2));
        URI expectedURI = new URIBuilder().setHost(target.getHostName()).setScheme(target.getSchemeName()).setPath("/people.html").setFragment("tim").build();
        Assert.assertEquals((Object)expectedURI, (Object)location);
    }
}

