/*
 * $Id$
 */

package org.apache.maven.mercury.repository.cache.md;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Collection;
import java.util.Date;

/**
 * metadata element.
 * 
 * @version $Revision$ $Date$
 */
public class Element implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * name of this element.
     */
    private String name;

    /**
     * Field attributes.
     */
    private java.util.List attributes;

    /**
     * Field elements.
     */
    private java.util.List elements;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addAttribute.
     * 
     * @param attribute
     */
    public void addAttribute(Attribute attribute)
    {
        if ( !(attribute instanceof Attribute) )
        {
            throw new ClassCastException( "Element.addAttributes(attribute) parameter must be instanceof " + Attribute.class.getName() );
        }
        getAttributes().add( attribute );
    } //-- void addAttribute(Attribute) 

    /**
     * Method addElement.
     * 
     * @param element
     */
    public void addElement(Element element)
    {
        if ( !(element instanceof Element) )
        {
            throw new ClassCastException( "Element.addElements(element) parameter must be instanceof " + Element.class.getName() );
        }
        getElements().add( element );
        element.createElementAssociation( this );
    } //-- void addElement(Element) 

    /**
     * Method breakElementAssociation.
     * 
     * @param element
     */
    public void breakElementAssociation(Element element)
    {
        if ( ! getElements().contains( element ) )
        {
            throw new IllegalStateException( "element isn't associated." );
        }
        
        getElements().remove( element );
    } //-- void breakElementAssociation(Element) 

    /**
     * Method createElementAssociation.
     * 
     * @param element
     */
    public void createElementAssociation(Element element)
    {
        Collection elements = getElements();
        
        if ( getElements().contains(element) )
        {
            throw new IllegalStateException( "element is already assigned." );
        }
        
        elements.add( element );
    } //-- void createElementAssociation(Element) 

    /**
     * Method getAttributes.
     * 
     * @return java.util.List
     */
    public java.util.List getAttributes()
    {
        if ( this.attributes == null )
        {
            this.attributes = new java.util.ArrayList();
        }
        
        return this.attributes;
    } //-- java.util.List getAttributes() 

    /**
     * Method getElements.
     * 
     * @return java.util.List
     */
    public java.util.List getElements()
    {
        if ( this.elements == null )
        {
            this.elements = new java.util.ArrayList();
        }
        
        return this.elements;
    } //-- java.util.List getElements() 

    /**
     * Get name of this element.
     * 
     * @return String
     */
    public String getName()
    {
        return this.name;
    } //-- String getName() 

    /**
     * Method removeAttribute.
     * 
     * @param attribute
     */
    public void removeAttribute(Attribute attribute)
    {
        if ( !(attribute instanceof Attribute) )
        {
            throw new ClassCastException( "Element.removeAttributes(attribute) parameter must be instanceof " + Attribute.class.getName() );
        }
        getAttributes().remove( attribute );
    } //-- void removeAttribute(Attribute) 

    /**
     * Method removeElement.
     * 
     * @param element
     */
    public void removeElement(Element element)
    {
        if ( !(element instanceof Element) )
        {
            throw new ClassCastException( "Element.removeElements(element) parameter must be instanceof " + Element.class.getName() );
        }
        element.breakElementAssociation( this );
        getElements().remove( element );
    } //-- void removeElement(Element) 

    /**
     * Set group of metadata element attributes.
     * 
     * @param attributes
     */
    public void setAttributes(java.util.List attributes)
    {
        this.attributes = attributes;
    } //-- void setAttributes(java.util.List) 

    /**
     * Set group of metadata element elements.
     * 
     * @param elements
     */
    public void setElements(java.util.List elements)
    {
        this.elements = elements;
    } //-- void setElements(java.util.List) 

    /**
     * Set name of this element.
     * 
     * @param name
     */
    public void setName(String name)
    {
        this.name = name;
    } //-- void setName(String) 


    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
