/*
 * $Id$
 */

package org.apache.maven.mercury.repository.cache.md.io.xpp3;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.io.Writer;
import java.text.DateFormat;
import java.util.Iterator;
import java.util.Locale;
import org.apache.maven.mercury.repository.cache.md.Attribute;
import org.apache.maven.mercury.repository.cache.md.CachedRawMetadata;
import org.apache.maven.mercury.repository.cache.md.Element;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

/**
 * Class CachedMetadataXpp3Writer.
 * 
 * @version $Revision$ $Date$
 */
public class CachedMetadataXpp3Writer {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field NAMESPACE.
     */
    private String NAMESPACE;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method write.
     * 
     * @param writer
     * @param cachedRawMetadata
     * @throws java.io.IOException
     */
    public void write(Writer writer, CachedRawMetadata cachedRawMetadata)
        throws java.io.IOException
    {
        XmlSerializer serializer = new MXSerializer();
        serializer.setProperty( "http://xmlpull.org/v1/doc/properties.html#serializer-indentation", "  " );
        serializer.setProperty( "http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", "\n" );
        serializer.setOutput( writer );
        serializer.startDocument( cachedRawMetadata.getModelEncoding(), null );
        writeCachedRawMetadata( cachedRawMetadata, "cachedRawMetadata", serializer );
        serializer.endDocument();
    } //-- void write(Writer, CachedRawMetadata) 

    /**
     * Method writeAttribute.
     * 
     * @param attribute
     * @param serializer
     * @param tagName
     * @throws java.io.IOException
     */
    private void writeAttribute(Attribute attribute, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( attribute != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( attribute.getName() != null )
            {
                serializer.startTag( NAMESPACE, "name" ).text( attribute.getName() ).endTag( NAMESPACE, "name" );
            }
            if ( attribute.getValue() != null )
            {
                serializer.startTag( NAMESPACE, "value" ).text( attribute.getValue() ).endTag( NAMESPACE, "value" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeAttribute(Attribute, String, XmlSerializer) 

    /**
     * Method writeCachedRawMetadata.
     * 
     * @param cachedRawMetadata
     * @param serializer
     * @param tagName
     * @throws java.io.IOException
     */
    private void writeCachedRawMetadata(CachedRawMetadata cachedRawMetadata, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( cachedRawMetadata != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( cachedRawMetadata.getLastUpdated() != null )
            {
                serializer.startTag( NAMESPACE, "lastUpdated" ).text( cachedRawMetadata.getLastUpdated() ).endTag( NAMESPACE, "lastUpdated" );
            }
            if ( cachedRawMetadata.getElements() != null && cachedRawMetadata.getElements().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "elements" );
                for ( Iterator iter = cachedRawMetadata.getElements().iterator(); iter.hasNext(); )
                {
                    Element o = (Element) iter.next();
                    writeElement( o, "element", serializer );
                }
                serializer.endTag( NAMESPACE, "elements" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeCachedRawMetadata(CachedRawMetadata, String, XmlSerializer) 

    /**
     * Method writeElement.
     * 
     * @param element
     * @param serializer
     * @param tagName
     * @throws java.io.IOException
     */
    private void writeElement(Element element, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( element != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( element.getName() != null )
            {
                serializer.startTag( NAMESPACE, "name" ).text( element.getName() ).endTag( NAMESPACE, "name" );
            }
            if ( element.getAttributes() != null && element.getAttributes().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "attributes" );
                for ( Iterator iter = element.getAttributes().iterator(); iter.hasNext(); )
                {
                    Attribute o = (Attribute) iter.next();
                    writeAttribute( o, "attribute", serializer );
                }
                serializer.endTag( NAMESPACE, "attributes" );
            }
            if ( element.getElements() != null && element.getElements().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "elements" );
                for ( Iterator iter = element.getElements().iterator(); iter.hasNext(); )
                {
                    Element o = (Element) iter.next();
                    writeElement( o, "element", serializer );
                }
                serializer.endTag( NAMESPACE, "elements" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeElement(Element, String, XmlSerializer) 


}
