/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.compiler;

import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.lang.model.SourceVersion;
import javax.tools.JavaFileObject;

final class SourceDirectory {
    static final String MODULE_INFO = "module-info";
    static final String JAVA_FILE_SUFFIX = ".java";
    static final String CLASS_FILE_SUFFIX = ".class";
    final Path root;
    final JavaFileObject.Kind fileKind;
    final String moduleName;
    private Path moduleInfo;
    final SourceVersion release;
    final Path outputDirectory;
    final JavaFileObject.Kind outputFileKind;

    private SourceDirectory(Path root, JavaFileObject.Kind fileKind, String moduleName, SourceVersion release, Path outputDirectory, JavaFileObject.Kind outputFileKind) {
        this.root = Objects.requireNonNull(root);
        this.fileKind = Objects.requireNonNull(fileKind);
        this.moduleName = moduleName;
        this.release = release;
        if (release != null) {
            String version = release.name();
            version = version.substring(version.lastIndexOf(95) + 1);
            FileSystem fs = outputDirectory.getFileSystem();
            Path subdir = moduleName != null ? fs.getPath(moduleName, "META-INF", "versions", version) : fs.getPath("META-INF", "versions", version);
            outputDirectory = outputDirectory.resolve(subdir);
        } else if (moduleName != null) {
            outputDirectory = outputDirectory.resolve(moduleName);
        }
        this.outputDirectory = outputDirectory;
        this.outputFileKind = outputFileKind;
    }

    static List<SourceDirectory> fromPaths(List<Path> compileSourceRoots, Path outputDirectory) {
        ArrayList<SourceDirectory> roots = new ArrayList<SourceDirectory>(compileSourceRoots.size());
        for (Path p : compileSourceRoots) {
            if (!Files.exists(p, new LinkOption[0])) continue;
            roots.add(new SourceDirectory(p, JavaFileObject.Kind.SOURCE, null, null, outputDirectory, JavaFileObject.Kind.CLASS));
        }
        return roots;
    }

    static boolean isModuleInfoSource(Path file) {
        return "module-info.java".equals(file.getFileName().toString());
    }

    void visit(Path sourceFile) {
        if (SourceDirectory.isModuleInfoSource(sourceFile) && (this.moduleInfo == null || this.moduleInfo.getNameCount() >= sourceFile.getNameCount())) {
            this.moduleInfo = sourceFile;
        }
    }

    public Optional<Path> getModuleInfo() {
        return Optional.ofNullable(this.moduleInfo);
    }

    public boolean equals(Object obj) {
        if (obj instanceof SourceDirectory) {
            SourceDirectory other = (SourceDirectory)obj;
            return this.release == other.release && Objects.equals(this.moduleName, other.moduleName) && this.root.equals(other.root) && this.outputDirectory.equals(other.outputDirectory);
        }
        return false;
    }

    public int hashCode() {
        return this.root.hashCode() + 7 * Objects.hash(new Object[]{this.moduleName, this.release});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(100).append('\"').append(this.root).append('\"');
        if (this.moduleName != null) {
            sb.append(" for module \"").append(this.moduleName).append('\"');
        }
        if (this.release != null) {
            sb.append(" on Java release ").append((Object)this.release);
        }
        return sb.toString();
    }
}

