/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency.tree;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Exclusion;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.traversal.DependencyNodeVisitor;

public class BuildingDependencyNodeVisitor
implements DependencyNodeVisitor {
    private final DependencyNodeVisitor visitor;
    private final Stack<DependencyNode> parentNodes;
    private DependencyNode rootNode;

    public BuildingDependencyNodeVisitor() {
        this(null);
    }

    public BuildingDependencyNodeVisitor(DependencyNodeVisitor visitor) {
        this.visitor = visitor;
        this.parentNodes = new Stack();
    }

    public boolean visit(DependencyNode node) {
        WrapperNode newNode = new WrapperNode(this.parentNodes.isEmpty() ? null : this.parentNodes.peek(), node.getArtifact(), node.getPremanagedVersion(), node.getPremanagedScope(), node.getVersionConstraint(), node.getOptional(), node.getExclusions(), node.toNodeString());
        newNode.setChildren(new ArrayList<DependencyNode>());
        if (this.parentNodes.empty()) {
            this.rootNode = newNode;
        } else {
            DependencyNode parentNode = this.parentNodes.peek();
            parentNode.getChildren().add(newNode);
        }
        this.parentNodes.push(newNode);
        return true;
    }

    public boolean endVisit(DependencyNode node) {
        this.parentNodes.pop();
        if (this.parentNodes.empty() && this.visitor != null) {
            this.rootNode.accept(this.visitor);
        }
        return true;
    }

    public DependencyNodeVisitor getDependencyNodeVisitor() {
        return this.visitor;
    }

    public DependencyNode getDependencyTree() {
        return this.rootNode;
    }

    private static class WrapperNode
    implements DependencyNode {
        private final Artifact artifact;
        private final DependencyNode parent;
        private final String premanagedVersion;
        private final String premanagedScope;
        private final String versionConstraint;
        private List<DependencyNode> children;
        private final Boolean optional;
        private final List<Exclusion> exclusions;
        private final String nodeString;

        private WrapperNode(DependencyNode parent, Artifact artifact, String premanagedVersion, String premanagedScope, String versionConstraint, Boolean optional, List<Exclusion> exclusions, String nodeString) {
            this.artifact = artifact;
            this.parent = parent;
            this.premanagedVersion = premanagedVersion;
            this.premanagedScope = premanagedScope;
            this.versionConstraint = versionConstraint;
            this.optional = optional;
            this.exclusions = exclusions;
            this.nodeString = nodeString;
        }

        public Artifact getArtifact() {
            return this.artifact;
        }

        public List<DependencyNode> getChildren() {
            return this.children;
        }

        public boolean accept(DependencyNodeVisitor visitor) {
            block1: {
                if (!visitor.visit((DependencyNode)this)) break block1;
                for (DependencyNode child : this.getChildren()) {
                    if (!child.accept(visitor)) break;
                }
            }
            return visitor.endVisit((DependencyNode)this);
        }

        public DependencyNode getParent() {
            return this.parent;
        }

        public String getPremanagedVersion() {
            return this.premanagedVersion;
        }

        public String getPremanagedScope() {
            return this.premanagedScope;
        }

        public String getVersionConstraint() {
            return this.versionConstraint;
        }

        public String toNodeString() {
            return this.nodeString;
        }

        public Boolean getOptional() {
            return this.optional;
        }

        public List<Exclusion> getExclusions() {
            return this.exclusions;
        }

        public void setChildren(List<DependencyNode> children) {
            this.children = children;
        }
    }
}

