/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginContainer;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.Reporting;
import org.apache.maven.plugins.dependency.utils.ParamArtifact;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactType;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.util.graph.visitor.PreorderNodeListGenerator;

@Named
@Singleton
public class ResolverUtil {
    private final RepositorySystem repositorySystem;
    private final Provider<MavenSession> mavenSessionProvider;

    @Inject
    public ResolverUtil(RepositorySystem repositorySystem, Provider<MavenSession> mavenSessionProvider) {
        this.repositorySystem = repositorySystem;
        this.mavenSessionProvider = mavenSessionProvider;
    }

    public Collection<Dependency> collectDependencies(Dependency root) throws DependencyCollectionException {
        MavenSession session = (MavenSession)this.mavenSessionProvider.get();
        CollectRequest request = new CollectRequest(root, session.getCurrentProject().getRemoteProjectRepositories());
        CollectResult result = this.repositorySystem.collectDependencies(session.getRepositorySession(), request);
        PreorderNodeListGenerator nodeListGenerator = new PreorderNodeListGenerator();
        result.getRoot().accept((DependencyVisitor)nodeListGenerator);
        return nodeListGenerator.getDependencies(true);
    }

    public Artifact resolveArtifact(Artifact artifact, List<RemoteRepository> repositories) throws ArtifactResolutionException {
        MavenSession session = (MavenSession)this.mavenSessionProvider.get();
        ArtifactRequest request = new ArtifactRequest(artifact, repositories, null);
        ArtifactResult result = this.repositorySystem.resolveArtifact(session.getRepositorySession(), request);
        return result.getArtifact();
    }

    public Artifact resolvePlugin(Plugin plugin) throws ArtifactResolutionException {
        MavenSession session = (MavenSession)this.mavenSessionProvider.get();
        Artifact artifact = this.toArtifact(plugin);
        return this.resolveArtifact(artifact, session.getCurrentProject().getRemotePluginRepositories());
    }

    public List<Artifact> resolveDependencies(Artifact artifact, List<RemoteRepository> repositories) throws DependencyResolutionException {
        return this.resolveDependencies(artifact, null, repositories);
    }

    public List<Artifact> resolveDependencies(Artifact artifact, List<Dependency> dependencies, List<RemoteRepository> repositories) throws DependencyResolutionException {
        MavenSession session = (MavenSession)this.mavenSessionProvider.get();
        CollectRequest collectRequest = new CollectRequest(new Dependency(artifact, null), dependencies, repositories);
        DependencyRequest request = new DependencyRequest(collectRequest, null);
        DependencyResult result = this.repositorySystem.resolveDependencies(session.getRepositorySession(), request);
        return result.getArtifactResults().stream().map(ArtifactResult::getArtifact).collect(Collectors.toList());
    }

    public List<Artifact> resolveDependenciesForArtifact(Artifact rootArtifact, List<Dependency> dependencies, List<Dependency> managedDependencies, List<RemoteRepository> remoteProjectRepositories) throws DependencyResolutionException {
        MavenSession session = (MavenSession)this.mavenSessionProvider.get();
        CollectRequest collectRequest = new CollectRequest(dependencies, managedDependencies, remoteProjectRepositories);
        collectRequest.setRootArtifact(rootArtifact);
        DependencyRequest request = new DependencyRequest(collectRequest, null);
        DependencyResult result = this.repositorySystem.resolveDependencies(session.getRepositorySession(), request);
        return result.getArtifactResults().stream().map(ArtifactResult::getArtifact).collect(Collectors.toList());
    }

    public List<Artifact> resolveDependencies(Plugin plugin, Predicate<org.apache.maven.model.Dependency> dependencyFilter) throws DependencyResolutionException {
        MavenSession session = (MavenSession)this.mavenSessionProvider.get();
        Artifact artifact = this.toArtifact(plugin);
        List<Dependency> pluginDependencies = plugin.getDependencies().stream().filter(dependencyFilter).map(d -> RepositoryUtils.toDependency((org.apache.maven.model.Dependency)d, (ArtifactTypeRegistry)session.getRepositorySession().getArtifactTypeRegistry())).collect(Collectors.toList());
        return this.resolveDependencies(artifact, pluginDependencies, session.getCurrentProject().getRemoteProjectRepositories());
    }

    private Artifact toArtifact(Plugin plugin) {
        MavenSession session = (MavenSession)this.mavenSessionProvider.get();
        return new DefaultArtifact(plugin.getGroupId(), plugin.getArtifactId(), null, "jar", plugin.getVersion(), session.getRepositorySession().getArtifactTypeRegistry().get("maven-plugin"));
    }

    public List<RemoteRepository> remoteRepositories(List<String> repositories) {
        MavenSession mavenSession = (MavenSession)this.mavenSessionProvider.get();
        List projectRepositories = mavenSession.getCurrentProject().getRemoteProjectRepositories();
        if (repositories == null || repositories.isEmpty()) {
            return projectRepositories;
        }
        List repositoriesList = repositories.stream().map(this::prepareRemoteRepository).collect(Collectors.toList());
        repositoriesList = this.repositorySystem.newResolutionRepositories(mavenSession.getRepositorySession(), repositoriesList);
        ArrayList<RemoteRepository> result = new ArrayList<RemoteRepository>(projectRepositories);
        result.addAll(repositoriesList);
        return result;
    }

    protected RemoteRepository prepareRemoteRepository(String repository) {
        MavenSession mavenSession;
        RepositorySystemSession repositorySession;
        String checksumPolicy;
        String url;
        String[] items = Objects.requireNonNull(repository, "repository must be not null").split("::");
        String id = "temp";
        String type = null;
        switch (items.length) {
            case 3: {
                id = items[0];
                type = items[1];
                url = items[2];
                break;
            }
            case 2: {
                id = items[0];
                url = items[1];
                break;
            }
            case 1: {
                url = items[0];
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid repository: " + repository);
            }
        }
        if (type == null || type.isEmpty()) {
            type = "default";
        }
        if ((checksumPolicy = (repositorySession = (mavenSession = (MavenSession)this.mavenSessionProvider.get()).getRepositorySession()).getChecksumPolicy()) == null) {
            checksumPolicy = "warn";
        }
        String updatePolicy = mavenSession.getRequest().isUpdateSnapshots() ? "always" : null;
        RepositoryPolicy repositoryPolicy = new RepositoryPolicy(true, updatePolicy, checksumPolicy);
        RemoteRepository.Builder builder = new RemoteRepository.Builder(id, type, url);
        builder.setReleasePolicy(repositoryPolicy);
        builder.setSnapshotPolicy(repositoryPolicy);
        return builder.build();
    }

    public Artifact createArtifactFromParams(ParamArtifact paramArtifact) {
        Objects.requireNonNull(paramArtifact);
        if (paramArtifact.getArtifact() != null) {
            return this.createArtifactFromString(paramArtifact.getArtifact());
        }
        ArtifactType artifactType = this.getArtifactType(paramArtifact.getPackaging());
        return new DefaultArtifact(paramArtifact.getGroupId(), paramArtifact.getArtifactId(), paramArtifact.getClassifier(), artifactType.getExtension(), paramArtifact.getVersion(), artifactType);
    }

    private Artifact createArtifactFromString(String artifact) {
        String[] items = artifact.split(":");
        if (items.length < 3) {
            throw new IllegalArgumentException("Invalid artifact format: " + artifact);
        }
        ArtifactType artifactType = this.getArtifactType(items.length > 3 ? items[3] : null);
        String classifier = items.length > 4 ? items[4] : null;
        return new DefaultArtifact(items[0], items[1], classifier, artifactType.getExtension(), items[2], artifactType);
    }

    private ArtifactType getArtifactType(String packaging) {
        ArtifactTypeRegistry artifactTypeRegistry = ((MavenSession)this.mavenSessionProvider.get()).getRepositorySession().getArtifactTypeRegistry();
        return artifactTypeRegistry.get(packaging != null ? packaging : "jar");
    }

    public Collection<Plugin> getProjectPlugins(MavenProject project) {
        List reportPlugins = Optional.ofNullable(project.getModel()).map(ModelBase::getReporting).map(Reporting::getPlugins).orElse(Collections.emptyList()).stream().map(p -> this.toPlugin((ReportPlugin)p, project)).collect(Collectors.toList());
        List projectPlugins = project.getBuild().getPlugins();
        LinkedHashSet<Plugin> result = new LinkedHashSet<Plugin>(reportPlugins.size() + projectPlugins.size());
        result.addAll(reportPlugins);
        result.addAll(projectPlugins);
        return result;
    }

    private Plugin toPlugin(ReportPlugin reportPlugin, MavenProject project) {
        Plugin plugin = (Plugin)Optional.ofNullable(project.getBuild().getPluginManagement()).map(PluginContainer::getPluginsAsMap).orElseGet(Collections::emptyMap).get(reportPlugin.getKey());
        if (plugin == null) {
            plugin = (Plugin)project.getBuild().getPluginsAsMap().get(reportPlugin.getKey());
        }
        if (plugin == null) {
            plugin = new Plugin();
            plugin.setGroupId(reportPlugin.getGroupId());
            plugin.setArtifactId(reportPlugin.getArtifactId());
            plugin.setVersion(reportPlugin.getVersion());
        } else if (reportPlugin.getVersion() != null) {
            plugin.setVersion(reportPlugin.getVersion());
        }
        if (plugin.getVersion() == null) {
            plugin.setVersion("RELEASE");
        }
        return plugin;
    }
}

