/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.phase;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.status.StatusScmResult;
import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseFailureException;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.env.ReleaseEnvironment;
import org.apache.maven.shared.release.phase.AbstractReleasePhase;
import org.apache.maven.shared.release.scm.ReleaseScmCommandException;
import org.apache.maven.shared.release.scm.ReleaseScmRepositoryException;
import org.apache.maven.shared.release.scm.ScmRepositoryConfigurator;
import org.apache.maven.shared.release.scm.ScmTranslator;
import org.codehaus.plexus.util.SelectorUtils;
import org.codehaus.plexus.util.StringUtils;

@Singleton
@Named(value="scm-check-modifications")
public class ScmCheckModificationsPhase
extends AbstractReleasePhase {
    private final ScmRepositoryConfigurator scmRepositoryConfigurator;
    private final Map<String, ScmTranslator> scmTranslators;
    private final Set<String> exclusionPatterns = new HashSet<String>(Arrays.asList("**" + File.separator + "pom.xml.backup", "**" + File.separator + "pom.xml.tag", "**" + File.separator + "pom.xml.next", "**" + File.separator + "pom.xml.branch", "**" + File.separator + "release.properties", "**" + File.separator + "pom.xml.releaseBackup"));

    @Inject
    public ScmCheckModificationsPhase(ScmRepositoryConfigurator scmRepositoryConfigurator, Map<String, ScmTranslator> scmTranslators) {
        this.scmRepositoryConfigurator = Objects.requireNonNull(scmRepositoryConfigurator);
        this.scmTranslators = Objects.requireNonNull(scmTranslators);
    }

    public ReleaseResult execute(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        StatusScmResult result;
        ScmProvider provider;
        ScmRepository repository;
        ReleaseResult relResult = new ReleaseResult();
        List additionalExcludes = releaseDescriptor.getCheckModificationExcludes();
        if (additionalExcludes != null) {
            for (String additionalExclude : additionalExcludes) {
                this.exclusionPatterns.add(additionalExclude.replace("\\", File.separator).replace("/", File.separator));
            }
        }
        this.logInfo(relResult, "Verifying that there are no local modifications...");
        this.logInfo(relResult, "  ignoring changes on: " + StringUtils.join((Object[])this.exclusionPatterns.toArray(), (String)", "));
        try {
            repository = this.scmRepositoryConfigurator.getConfiguredRepository(releaseDescriptor, releaseEnvironment.getSettings());
            provider = this.scmRepositoryConfigurator.getRepositoryProvider(repository);
        }
        catch (ScmRepositoryException e) {
            throw new ReleaseScmRepositoryException(e.getMessage() + " for URL: " + releaseDescriptor.getScmSourceUrl(), e.getValidationMessages());
        }
        catch (NoSuchScmProviderException e) {
            throw new ReleaseExecutionException("Unable to configure SCM repository: " + e.getMessage(), (Throwable)e);
        }
        try {
            result = provider.status(repository, new ScmFileSet(new File(releaseDescriptor.getWorkingDirectory())));
        }
        catch (ScmException e) {
            throw new ReleaseExecutionException("An error occurred during the status check process: " + e.getMessage(), (Throwable)e);
        }
        if (!result.isSuccess()) {
            throw new ReleaseScmCommandException("Unable to check for local modifications", (ScmResult)result);
        }
        List changedFiles = result.getChangedFiles();
        if (!changedFiles.isEmpty()) {
            ScmTranslator scmTranslator = this.scmTranslators.get(repository.getProvider());
            Iterator i = changedFiles.iterator();
            block6: while (i.hasNext()) {
                ScmFile f = (ScmFile)i.next();
                String path = scmTranslator != null ? scmTranslator.toRelativePath(f.getPath()) : f.getPath();
                String fileName = path.replace("\\", File.separator).replace("/", File.separator);
                for (String exclusionPattern : this.exclusionPatterns) {
                    if (!SelectorUtils.matchPath((String)exclusionPattern, (String)fileName)) continue;
                    this.logDebug(relResult, "Ignoring changed file: " + fileName);
                    i.remove();
                    continue block6;
                }
            }
        }
        if (!changedFiles.isEmpty()) {
            StringBuilder message = new StringBuilder();
            for (ScmFile file : changedFiles) {
                message.append(file.toString());
                message.append("\n");
            }
            throw new ReleaseFailureException("Cannot prepare the release because you have local modifications : \n" + message);
        }
        relResult.setResultCode(0);
        return relResult;
    }

    public ReleaseResult simulate(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        return this.execute(releaseDescriptor, releaseEnvironment, reactorProjects);
    }
}

