/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependency.analyzer.dependencyclasses;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.analyzer.ClassesPatterns;
import org.apache.maven.shared.dependency.analyzer.DependencyUsage;
import org.apache.maven.shared.dependency.analyzer.MainDependencyClassesProvider;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Named
@Singleton
class WarMainDependencyClassesProvider
implements MainDependencyClassesProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(WarMainDependencyClassesProvider.class);
    private static final List<String> WEB_XML_NAMESPACES = Arrays.asList("https://jakarta.ee/xml/ns/jakartaee", "http://xmlns.jcp.org/xml/ns/javaee", "http://java.sun.com/xml/ns/javaee");

    WarMainDependencyClassesProvider() {
    }

    @Override
    public Set<DependencyUsage> getDependencyClasses(MavenProject project, ClassesPatterns excludedClasses) throws IOException {
        if (!"war".equals(project.getPackaging())) {
            return Collections.emptySet();
        }
        File webXml = this.findWebXml(project);
        if (webXml == null) {
            LOGGER.debug("No web.xml found for project {}", (Object)project);
            return Collections.emptySet();
        }
        if (!webXml.isFile()) {
            LOGGER.debug("{} is not a file in project {}", (Object)webXml, (Object)project);
            return Collections.emptySet();
        }
        try {
            return this.processWebXml(webXml, excludedClasses);
        }
        catch (ParserConfigurationException | SAXException e) {
            LOGGER.warn("Error parsing web.xml file {}: {}", (Object)webXml, (Object)e.getMessage());
            return Collections.emptySet();
        }
    }

    private File findWebXml(MavenProject project) {
        File webXmlFile = new File(project.getBasedir(), "src/main/webapp/WEB-INF/web.xml");
        if (webXmlFile.isFile()) {
            return webXmlFile;
        }
        Plugin plugin = (Plugin)project.getBuild().getPluginsAsMap().get("org.apache.maven.plugins:maven-war-plugin");
        if (plugin == null) {
            LOGGER.debug("No war plugin found for project {}", (Object)project);
            return null;
        }
        return Optional.ofNullable(plugin.getConfiguration()).map(Xpp3Dom.class::cast).map(config -> config.getChild("webXml")).map(Xpp3Dom::getValue).map(path -> new File(project.getBasedir(), (String)path)).orElse(null);
    }

    private Set<DependencyUsage> processWebXml(File webXml, ClassesPatterns excludedClasses) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        documentBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        documentBuilderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        documentBuilderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        documentBuilderFactory.setExpandEntityReferences(false);
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document doc = documentBuilder.parse(webXml);
        ArrayList<String> classes = new ArrayList<String>();
        this.processClassesFromTags(doc, classes, "filter-class");
        this.processClassesFromTags(doc, classes, "listener-class");
        this.processClassesFromTags(doc, classes, "servlet-class");
        return classes.stream().filter(className -> !excludedClasses.isMatch((String)className)).map(className -> new DependencyUsage((String)className, webXml.toString())).collect(Collectors.toSet());
    }

    private void processClassesFromTags(Document doc, List<String> classes, String tagName) {
        for (String namespace : WEB_XML_NAMESPACES) {
            NodeList tags = doc.getElementsByTagNameNS(namespace, tagName);
            for (int i = 0; i < tags.getLength(); ++i) {
                Node node = tags.item(i);
                Optional.ofNullable(node.getTextContent()).map(String::trim).filter(s -> !s.isEmpty()).ifPresent(classes::add);
            }
            if (tags.getLength() <= 0) continue;
            return;
        }
    }
}

