/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.cert.Certificate;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletContext;
import javax.servlet.jsp.JspFactory;
import org.apache.jasper.Constants;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.runtime.JspFactoryImpl;
import org.apache.jasper.security.SecurityClassLoad;
import org.apache.jasper.servlet.JspCServletContext;
import org.apache.jasper.servlet.JspServletWrapper;
import org.apache.jasper.util.Entry;
import org.apache.jasper.util.JspQueue;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public final class JspRuntimeContext {
    private final Log log = LogFactory.getLog(JspRuntimeContext.class);
    private AtomicInteger jspReloadCount = new AtomicInteger(0);
    private final ServletContext context;
    private final Options options;
    private final ClassLoader parentClassLoader;
    private final PermissionCollection permissionCollection;
    private final CodeSource codeSource;
    private final String classpath;
    private volatile long lastCheck = -1L;
    private Map<String, JspServletWrapper> jsps = new ConcurrentHashMap<String, JspServletWrapper>();
    private JspQueue<JspServletWrapper> jspQueue = new JspQueue();

    public JspRuntimeContext(ServletContext context, Options options) {
        this.context = context;
        this.options = options;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = this.getClass().getClassLoader();
        }
        if (this.log.isDebugEnabled()) {
            if (loader != null) {
                this.log.debug((Object)Localizer.getMessage("jsp.message.parent_class_loader_is", loader.toString()));
            } else {
                this.log.debug((Object)Localizer.getMessage("jsp.message.parent_class_loader_is", "<none>"));
            }
        }
        this.parentClassLoader = loader;
        this.classpath = this.initClassPath();
        if (context instanceof JspCServletContext) {
            this.codeSource = null;
            this.permissionCollection = null;
            return;
        }
        if (Constants.IS_SECURITY_ENABLED) {
            SecurityHolder holder = this.initSecurity();
            this.codeSource = holder.cs;
            this.permissionCollection = holder.pc;
        } else {
            this.codeSource = null;
            this.permissionCollection = null;
        }
        String appBase = context.getRealPath("/");
        if (!options.getDevelopment() && appBase != null && options.getCheckInterval() > 0) {
            this.lastCheck = System.currentTimeMillis();
        }
    }

    public void addWrapper(String jspUri, JspServletWrapper jsw) {
        this.jsps.put(jspUri, jsw);
    }

    public JspServletWrapper getWrapper(String jspUri) {
        return this.jsps.get(jspUri);
    }

    public void removeWrapper(String jspUri) {
        this.jsps.remove(jspUri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry<JspServletWrapper> push(JspServletWrapper jsw) {
        JspQueue<JspServletWrapper> jspQueue = this.jspQueue;
        synchronized (jspQueue) {
            return this.jspQueue.push(jsw);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeFirst(Entry<JspServletWrapper> ticket) {
        JspQueue<JspServletWrapper> jspQueue = this.jspQueue;
        synchronized (jspQueue) {
            this.jspQueue.makeYoungest(ticket);
        }
    }

    public int getJspCount() {
        return this.jsps.size();
    }

    public CodeSource getCodeSource() {
        return this.codeSource;
    }

    public ClassLoader getParentClassLoader() {
        return this.parentClassLoader;
    }

    public PermissionCollection getPermissionCollection() {
        return this.permissionCollection;
    }

    public void destroy() {
        Iterator<JspServletWrapper> servlets = this.jsps.values().iterator();
        while (servlets.hasNext()) {
            servlets.next().destroy();
        }
    }

    public void incrementJspReloadCount() {
        this.jspReloadCount.incrementAndGet();
    }

    public void setJspReloadCount(int count) {
        this.jspReloadCount.set(count);
    }

    public int getJspReloadCount() {
        return this.jspReloadCount.intValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkCompile() {
        if (this.lastCheck < 0L) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now <= this.lastCheck + (long)this.options.getCheckInterval() * 1000L) {
            return;
        }
        this.lastCheck = now;
        Object[] wrappers = this.jsps.values().toArray();
        for (int i = 0; i < wrappers.length; ++i) {
            JspServletWrapper jsw = (JspServletWrapper)wrappers[i];
            JspCompilationContext ctxt = jsw.getJspEngineContext();
            JspServletWrapper jspServletWrapper = jsw;
            synchronized (jspServletWrapper) {
                try {
                    ctxt.compile();
                }
                catch (FileNotFoundException ex) {
                    ctxt.incrementRemoved();
                }
                catch (Throwable t) {
                    jsw.getServletContext().log("Background compile failed", t);
                }
                continue;
            }
        }
    }

    public String getClassPath() {
        return this.classpath;
    }

    private String initClassPath() {
        StringBuilder cpath = new StringBuilder();
        String sep = System.getProperty("path.separator");
        if (this.parentClassLoader instanceof URLClassLoader) {
            URL[] urls = ((URLClassLoader)this.parentClassLoader).getURLs();
            for (int i = 0; i < urls.length; ++i) {
                if (!urls[i].getProtocol().equals("file")) continue;
                cpath.append(urls[i].getFile() + sep);
            }
        }
        cpath.append(this.options.getScratchDir() + sep);
        String cp = (String)this.context.getAttribute(Constants.SERVLET_CLASSPATH);
        if (cp == null || cp.equals("")) {
            cp = this.options.getClassPath();
        }
        String path = cpath.toString() + cp;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Compilation classpath initialized: " + path));
        }
        return path;
    }

    private SecurityHolder initSecurity() {
        Policy policy = Policy.getPolicy();
        CodeSource source = null;
        PermissionCollection permissions = null;
        if (policy != null) {
            try {
                String codeBase;
                String docBase = this.context.getRealPath("/");
                if (docBase == null) {
                    docBase = this.options.getScratchDir().toString();
                }
                if (!(codeBase = docBase).endsWith(File.separator)) {
                    codeBase = codeBase + File.separator;
                }
                File contextDir = new File(codeBase);
                URL url = contextDir.getCanonicalFile().toURI().toURL();
                source = new CodeSource(url, (Certificate[])null);
                permissions = policy.getPermissions(source);
                if (!docBase.endsWith(File.separator)) {
                    permissions.add(new FilePermission(docBase, "read"));
                    docBase = docBase + File.separator;
                } else {
                    permissions.add(new FilePermission(docBase.substring(0, docBase.length() - 1), "read"));
                }
                docBase = docBase + "-";
                permissions.add(new FilePermission(docBase, "read"));
                String workDir = this.options.getScratchDir().toString();
                if (!workDir.endsWith(File.separator)) {
                    permissions.add(new FilePermission(workDir, "read,write"));
                    workDir = workDir + File.separator;
                }
                workDir = workDir + "-";
                permissions.add(new FilePermission(workDir, "read,write,delete"));
                permissions.add(new RuntimePermission("accessClassInPackage.org.apache.jasper.runtime"));
                if (this.parentClassLoader instanceof URLClassLoader) {
                    URL[] urls = ((URLClassLoader)this.parentClassLoader).getURLs();
                    String jarUrl = null;
                    String jndiUrl = null;
                    for (int i = 0; i < urls.length; ++i) {
                        if (jndiUrl == null && urls[i].toString().startsWith("jndi:")) {
                            jndiUrl = urls[i].toString() + "-";
                        }
                        if (jarUrl != null || !urls[i].toString().startsWith("jar:jndi:")) continue;
                        jarUrl = urls[i].toString();
                        jarUrl = jarUrl.substring(0, jarUrl.length() - 2);
                        jarUrl = jarUrl.substring(0, jarUrl.lastIndexOf(47)) + "/-";
                    }
                    if (jarUrl != null) {
                        permissions.add(new FilePermission(jarUrl, "read"));
                        permissions.add(new FilePermission(jarUrl.substring(4), "read"));
                    }
                    if (jndiUrl != null) {
                        permissions.add(new FilePermission(jndiUrl, "read"));
                    }
                }
            }
            catch (Exception e) {
                this.context.log("Security Init for context failed", (Throwable)e);
            }
        }
        return new SecurityHolder(source, permissions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JspServletWrapper getJspForUnload(int maxLoadedJsps) {
        if (this.jsps.size() > maxLoadedJsps) {
            Map<String, JspServletWrapper> map = this.jsps;
            synchronized (map) {
                JspServletWrapper oldest;
                JspQueue<JspServletWrapper> jspQueue = this.jspQueue;
                synchronized (jspQueue) {
                    oldest = this.jspQueue.pop();
                }
                if (oldest != null) {
                    this.removeWrapper(oldest.getJspUri());
                    return oldest;
                }
            }
        }
        return null;
    }

    public void checkUnload() {
        long now;
        if (this.options.getMaxLoadedJsps() > 0 && (now = System.currentTimeMillis()) > this.lastCheck + (long)this.options.getCheckInterval() * 1000L) {
            while (this.unloadJsp()) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unloadJsp() {
        JspServletWrapper jsw = this.getJspForUnload(this.options.getMaxLoadedJsps());
        if (null != jsw) {
            JspServletWrapper jspServletWrapper = jsw;
            synchronized (jspServletWrapper) {
                jsw.destroy();
                return true;
            }
        }
        return false;
    }

    static {
        JspFactoryImpl factory = new JspFactoryImpl();
        SecurityClassLoad.securityClassLoad(factory.getClass().getClassLoader());
        if (System.getSecurityManager() != null) {
            String basePackage = "org.apache.jasper.";
            try {
                factory.getClass().getClassLoader().loadClass(basePackage + "runtime.JspFactoryImpl$PrivilegedGetPageContext");
                factory.getClass().getClassLoader().loadClass(basePackage + "runtime.JspFactoryImpl$PrivilegedReleasePageContext");
                factory.getClass().getClassLoader().loadClass(basePackage + "runtime.JspRuntimeLibrary");
                factory.getClass().getClassLoader().loadClass(basePackage + "runtime.JspRuntimeLibrary$PrivilegedIntrospectHelper");
                factory.getClass().getClassLoader().loadClass(basePackage + "runtime.ServletResponseWrapperInclude");
                factory.getClass().getClassLoader().loadClass(basePackage + "servlet.JspServletWrapper");
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalStateException(ex);
            }
        }
        JspFactory.setDefaultFactory(factory);
    }

    private static class SecurityHolder {
        private final CodeSource cs;
        private final PermissionCollection pc;

        private SecurityHolder(CodeSource cs, PermissionCollection pc) {
            this.cs = cs;
            this.pc = pc;
        }
    }
}

