/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.uri;

import java.net.URI;
import java.net.URISyntaxException;
import org.asynchttpclient.uri.UriParser;
import org.asynchttpclient.util.Assertions;
import org.asynchttpclient.util.MiscUtils;
import org.asynchttpclient.util.StringBuilderPool;

public class Uri {
    public static final String HTTP = "http";
    public static final String HTTPS = "https";
    public static final String WS = "ws";
    public static final String WSS = "wss";
    private final String scheme;
    private final String userInfo;
    private final String host;
    private final int port;
    private final String query;
    private final String path;
    private String url;
    private boolean secured;
    private boolean webSocket;

    public Uri(String scheme, String userInfo, String host, int port, String path, String query) {
        this.scheme = Assertions.assertNotEmpty(scheme, "scheme");
        this.userInfo = userInfo;
        this.host = Assertions.assertNotEmpty(host, "host");
        this.port = port;
        this.path = path;
        this.query = query;
        this.secured = HTTPS.equals(scheme) || WSS.equals(scheme);
        this.webSocket = WS.equals(scheme) || WSS.equalsIgnoreCase(scheme);
    }

    public static Uri create(String originalUrl) {
        return Uri.create(null, originalUrl);
    }

    public static Uri create(Uri context, String originalUrl) {
        UriParser parser = new UriParser();
        parser.parse(context, originalUrl);
        if (MiscUtils.isEmpty(parser.scheme)) {
            throw new IllegalArgumentException(originalUrl + " could not be parsed into a proper Uri, missing scheme");
        }
        if (MiscUtils.isEmpty(parser.host)) {
            throw new IllegalArgumentException(originalUrl + " could not be parsed into a proper Uri, missing host");
        }
        return new Uri(parser.scheme, parser.userInfo, parser.host, parser.port, parser.path, parser.query);
    }

    public String getQuery() {
        return this.query;
    }

    public String getPath() {
        return this.path;
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public int getPort() {
        return this.port;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public boolean isSecured() {
        return this.secured;
    }

    public boolean isWebSocket() {
        return this.webSocket;
    }

    public URI toJavaNetURI() throws URISyntaxException {
        return new URI(this.toUrl());
    }

    public int getExplicitPort() {
        return this.port == -1 ? this.getSchemeDefaultPort() : this.port;
    }

    public int getSchemeDefaultPort() {
        return this.isSecured() ? 443 : 80;
    }

    public String toUrl() {
        if (this.url == null) {
            StringBuilder sb = StringBuilderPool.DEFAULT.stringBuilder();
            sb.append(this.scheme).append("://");
            if (this.userInfo != null) {
                sb.append(this.userInfo).append('@');
            }
            sb.append(this.host);
            if (this.port != -1) {
                sb.append(':').append(this.port);
            }
            if (this.path != null) {
                sb.append(this.path);
            }
            if (this.query != null) {
                sb.append('?').append(this.query);
            }
            this.url = sb.toString();
            sb.setLength(0);
        }
        return this.url;
    }

    public String toBaseUrl() {
        StringBuilder sb = StringBuilderPool.DEFAULT.stringBuilder();
        sb.append(this.scheme).append("://").append(this.host);
        if (this.port != -1 && this.port != this.getSchemeDefaultPort()) {
            sb.append(':').append(this.port);
        }
        if (MiscUtils.isNonEmpty(this.path)) {
            sb.append(this.path);
        }
        return sb.toString();
    }

    public String toRelativeUrl() {
        StringBuilder sb = StringBuilderPool.DEFAULT.stringBuilder();
        if (MiscUtils.isNonEmpty(this.path)) {
            sb.append(this.path);
        } else {
            sb.append('/');
        }
        if (this.query != null) {
            sb.append('?').append(this.query);
        }
        return sb.toString();
    }

    public String getBaseUrl() {
        return this.scheme + "://" + this.host + ":" + this.getExplicitPort();
    }

    public String getAuthority() {
        return this.host + ":" + this.getExplicitPort();
    }

    public boolean isSameBase(Uri other) {
        return this.scheme.equals(other.getScheme()) && this.host.equals(other.getHost()) && this.getExplicitPort() == other.getExplicitPort();
    }

    public String getNonEmptyPath() {
        return MiscUtils.isNonEmpty(this.path) ? this.path : "/";
    }

    public String toString() {
        return this.toUrl();
    }

    public Uri withNewScheme(String newScheme) {
        return new Uri(newScheme, this.userInfo, this.host, this.port, this.path, this.query);
    }

    public Uri withNewQuery(String newQuery) {
        return new Uri(this.scheme, this.userInfo, this.host, this.port, this.path, newQuery);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + this.port;
        result = 31 * result + (this.query == null ? 0 : this.query.hashCode());
        result = 31 * result + (this.scheme == null ? 0 : this.scheme.hashCode());
        result = 31 * result + (this.userInfo == null ? 0 : this.userInfo.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Uri other = (Uri)obj;
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        if (this.query == null ? other.query != null : !this.query.equals(other.query)) {
            return false;
        }
        if (this.scheme == null ? other.scheme != null : !this.scheme.equals(other.scheme)) {
            return false;
        }
        return !(this.userInfo == null ? other.userInfo != null : !this.userInfo.equals(other.userInfo));
    }

    public static void validateSupportedScheme(Uri uri) {
        String scheme = uri.getScheme();
        if (scheme == null || !scheme.equalsIgnoreCase(HTTP) && !scheme.equalsIgnoreCase(HTTPS) && !scheme.equalsIgnoreCase(WS) && !scheme.equalsIgnoreCase(WSS)) {
            throw new IllegalArgumentException("The URI scheme, of the URI " + uri + ", must be equal (ignoring case) to 'http', 'https', 'ws', or 'wss'");
        }
    }
}

