/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.sizeof;

import org.ehcache.core.spi.store.Store;
import org.ehcache.core.spi.store.heap.LimitExceededException;
import org.ehcache.core.spi.store.heap.SizeOfEngine;
import org.ehcache.impl.copy.IdentityCopier;
import org.ehcache.impl.internal.concurrent.ConcurrentHashMap;
import org.ehcache.impl.internal.sizeof.listeners.EhcacheVisitorListener;
import org.ehcache.impl.internal.sizeof.listeners.exceptions.VisitorListenerException;
import org.ehcache.impl.internal.store.heap.holders.CopiedOnHeapKey;
import org.ehcache.sizeof.SizeOf;
import org.ehcache.sizeof.SizeOfFilterSource;
import org.ehcache.sizeof.VisitorListener;
import org.ehcache.sizeof.filters.SizeOfFilter;

public class DefaultSizeOfEngine
implements SizeOfEngine {
    private final long maxObjectGraphSize;
    private final long maxObjectSize;
    private final SizeOf sizeOf;
    private final long chmTreeBinOffset;
    private final long onHeapKeyOffset;

    public DefaultSizeOfEngine(long maxObjectGraphSize, long maxObjectSize) {
        this.maxObjectGraphSize = maxObjectGraphSize;
        this.maxObjectSize = maxObjectSize;
        this.sizeOf = SizeOf.newInstance((SizeOfFilter[])new SizeOfFilterSource(true).getFilters());
        this.onHeapKeyOffset = this.sizeOf.deepSizeOf(new Object[]{new CopiedOnHeapKey<Object>(new Object(), new IdentityCopier())});
        this.chmTreeBinOffset = this.sizeOf.deepSizeOf(new Object[]{ConcurrentHashMap.FAKE_TREE_BIN});
    }

    public <K, V> long sizeof(K key, Store.ValueHolder<V> holder) throws LimitExceededException {
        try {
            return this.sizeOf.deepSizeOf((VisitorListener)new EhcacheVisitorListener(this.maxObjectGraphSize, this.maxObjectSize), new Object[]{key, holder}) + this.chmTreeBinOffset + this.onHeapKeyOffset;
        }
        catch (VisitorListenerException e) {
            throw new LimitExceededException(e.getMessage());
        }
    }
}

