/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.convert.imf;

import java.time.YearMonth;
import java.util.Objects;

enum IMFHistoricalType {
    SDR_Currency("SDRCV"),
    Currency_SDR("CVSDR");

    private final String type;

    private IMFHistoricalType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public String getUrl(YearMonth yearMonth) {
        return String.format("https://www.imf.org/external/np/fin/data/rms_mth.aspx?SelectDate=%s&reportType=%s&tsvflag=Y", Objects.requireNonNull(yearMonth), this.type);
    }
}

