/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.kuali.common.jdbc.ExecutionResult;
import org.kuali.common.jdbc.ExecutionStats;
import org.kuali.common.jdbc.JdbcMetaData;
import org.kuali.common.jdbc.JdbcService;
import org.kuali.common.jdbc.JdbcUtils;
import org.kuali.common.jdbc.context.JdbcContext;
import org.kuali.common.jdbc.listener.BucketEvent;
import org.kuali.common.jdbc.listener.LogSqlListener;
import org.kuali.common.jdbc.listener.MultiThreadedExecutionListener;
import org.kuali.common.jdbc.listener.NotifyingListener;
import org.kuali.common.jdbc.listener.SqlEvent;
import org.kuali.common.jdbc.listener.SqlExecutionEvent;
import org.kuali.common.jdbc.listener.SqlListener;
import org.kuali.common.jdbc.listener.SqlMetaDataEvent;
import org.kuali.common.jdbc.supplier.SimpleStringSupplier;
import org.kuali.common.jdbc.supplier.SqlSupplier;
import org.kuali.common.jdbc.threads.SqlBucket;
import org.kuali.common.jdbc.threads.SqlBucketContext;
import org.kuali.common.jdbc.threads.SqlBucketHandler;
import org.kuali.common.threads.ElementHandler;
import org.kuali.common.threads.ExecutionStatistics;
import org.kuali.common.threads.ThreadHandlerContext;
import org.kuali.common.threads.ThreadInvoker;
import org.kuali.common.util.CollectionUtils;
import org.kuali.common.util.FormatUtils;
import org.kuali.common.util.PercentCompleteInformer;
import org.kuali.common.util.Str;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.DataSourceUtils;

@Deprecated
public class DefaultJdbcService
implements JdbcService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultJdbcService.class);

    @Override
    public ExecutionResult executeSql(JdbcContext context) {
        ExecutionStats stats = new ExecutionStats();
        long start = System.currentTimeMillis();
        if (!StringUtils.isBlank((CharSequence)context.getMessage())) {
            logger.info(context.getMessage());
        }
        if (CollectionUtils.isEmpty(context.getSuppliers())) {
            logger.info("Skipping execution.  No suppliers");
            return new ExecutionResult(0L, start, System.currentTimeMillis(), 0L);
        }
        if (!context.isSkipMetaData()) {
            this.doMetaData(context);
        }
        long sqlStart = System.currentTimeMillis();
        context.getListener().beforeExecution(new SqlExecutionEvent(context, start, -1L));
        stats = context.isMultithreaded() ? this.executeMultiThreaded(context) : this.executeSequentially(context);
        context.getListener().afterExecution(new SqlExecutionEvent(context, sqlStart, System.currentTimeMillis()));
        return new ExecutionResult(stats.getUpdateCount(), start, System.currentTimeMillis(), stats.getStatementCount());
    }

    protected void doMetaData(JdbcContext context) {
        logger.debug("doMetaData()");
        long start = System.currentTimeMillis();
        context.getListener().beforeMetaData(new SqlMetaDataEvent(context, start, -1L));
        for (SqlSupplier supplier : context.getSuppliers()) {
            supplier.fillInMetaData();
        }
        context.getListener().afterMetaData(new SqlMetaDataEvent(context, start, System.currentTimeMillis()));
    }

    protected ExecutionStats executeMultiThreaded(JdbcContext context) {
        List<SqlBucket> buckets = this.getSqlBuckets(context);
        context.getListener().bucketsCreated(new BucketEvent(context, buckets));
        Collections.sort(buckets);
        Collections.reverse(buckets);
        long total = JdbcUtils.getSqlCount(context.getSuppliers());
        PercentCompleteInformer informer = new PercentCompleteInformer(total);
        MultiThreadedExecutionListener etl = new MultiThreadedExecutionListener();
        etl.setTrackProgressByUpdateCount(context.isTrackProgressByUpdateCount());
        etl.setInformer(informer);
        ArrayList<SqlListener> listeners = new ArrayList<SqlListener>();
        listeners.add(new LogSqlListener());
        listeners.add(etl);
        NotifyingListener nl = new NotifyingListener(listeners);
        List<SqlBucketContext> sbcs = this.getSqlBucketContexts(buckets, context, nl);
        ThreadHandlerContext thc = new ThreadHandlerContext();
        thc.setList(sbcs);
        thc.setHandler((ElementHandler)new SqlBucketHandler());
        thc.setMax(buckets.size());
        thc.setMin(buckets.size());
        thc.setDivisor(1);
        ThreadInvoker invoker = new ThreadInvoker();
        informer.start();
        ExecutionStatistics stats = invoker.invokeThreads(thc);
        informer.stop();
        long aggregateTime = etl.getAggregateTime();
        long wallTime = stats.getExecutionTime();
        String avgMillis = FormatUtils.getTime((long)(aggregateTime / (long)buckets.size()));
        String aTime = FormatUtils.getTime((long)aggregateTime);
        String wTime = FormatUtils.getTime((long)wallTime);
        String sqlCount = FormatUtils.getCount((long)etl.getAggregateSqlCount());
        String sqlSize = FormatUtils.getSize((long)etl.getAggregateSqlSize());
        Object[] args = new Object[]{buckets.size(), wTime, aTime, avgMillis, sqlCount, sqlSize};
        logger.debug("Threads - [count: {}  time: {}  aggregate: {}  avg: {}  sql: {} - {}]", args);
        return new ExecutionStats(etl.getAggregateUpdateCount(), etl.getAggregateSqlCount());
    }

    @Override
    public ExecutionResult executeSql(DataSource dataSource, String sql) {
        return this.executeSql(dataSource, Arrays.asList(sql));
    }

    @Override
    public ExecutionResult executeSql(DataSource dataSource, List<String> sql) {
        SimpleStringSupplier supplier = new SimpleStringSupplier(sql);
        JdbcContext context = new JdbcContext();
        context.setDataSource(dataSource);
        context.setSuppliers(Arrays.asList(supplier));
        return this.executeSql(context);
    }

    protected List<SqlBucketContext> getSqlBucketContexts(List<SqlBucket> buckets, JdbcContext context, SqlListener listener) {
        ArrayList<SqlBucketContext> sbcs = new ArrayList<SqlBucketContext>();
        for (SqlBucket bucket : buckets) {
            JdbcContext newJdbcContext = this.getJdbcContext(context, bucket, listener);
            SqlBucketContext sbc = new SqlBucketContext();
            sbc.setService(this);
            sbc.setBucket(bucket);
            sbc.setContext(newJdbcContext);
            sbcs.add(sbc);
        }
        return sbcs;
    }

    protected JdbcContext getJdbcContext(JdbcContext original, SqlBucket bucket, SqlListener listener) {
        JdbcContext context = new JdbcContext();
        context.setSuppliers(bucket.getSuppliers());
        context.setDataSource(original.getDataSource());
        context.setCommitMode(original.getCommitMode());
        context.setThreads(1);
        context.setSkip(original.isSkip());
        context.setListener(listener);
        context.setSkipMetaData(true);
        return context;
    }

    protected List<SqlBucket> getSqlBuckets(JdbcContext context) {
        List<SqlSupplier> suppliers = context.getSuppliers();
        int bucketCount = Math.min(context.getThreads(), suppliers.size());
        Collections.sort(suppliers);
        Collections.reverse(suppliers);
        List buckets = CollectionUtils.getNewList(SqlBucket.class, (int)bucketCount);
        for (SqlSupplier supplier : suppliers) {
            Collections.sort(buckets);
            SqlBucket smallest = (SqlBucket)buckets.get(0);
            smallest.getSuppliers().add(supplier);
            smallest.setCount(smallest.getCount() + supplier.getMetaData().getCount());
            smallest.setSize(smallest.getSize() + supplier.getMetaData().getSize());
        }
        return buckets;
    }

    protected ExecutionStats executeSequentially(JdbcContext context) {
        ExecutionStats executionStats;
        Connection conn = null;
        Statement statement = null;
        try {
            long updateCount = 0L;
            long statementCount = 0L;
            conn = DataSourceUtils.doGetConnection((DataSource)context.getDataSource());
            boolean originalAutoCommitSetting = conn.getAutoCommit();
            conn.setAutoCommit(false);
            statement = conn.createStatement();
            List<SqlSupplier> suppliers = context.getSuppliers();
            for (SqlSupplier supplier : suppliers) {
                ExecutionStats stats = this.excecuteSupplier(statement, context, supplier);
                updateCount += stats.getUpdateCount();
                statementCount += stats.getStatementCount();
                conn.commit();
            }
            conn.setAutoCommit(originalAutoCommitSetting);
            executionStats = new ExecutionStats(updateCount, statementCount);
        }
        catch (Exception e) {
            try {
                throw new IllegalStateException(e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(context.getDataSource(), conn, statement);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly(context.getDataSource(), conn, statement);
        return executionStats;
    }

    protected ExecutionStats excecuteSupplier(Statement statement, JdbcContext context, SqlSupplier supplier) throws SQLException {
        try {
            long updateCount = 0L;
            long statementCount = 0L;
            supplier.open();
            List<String> sql = supplier.getSql();
            while (sql != null) {
                for (String s : sql) {
                    updateCount += (long)this.executeSql(statement, s, context);
                    ++statementCount;
                }
                sql = supplier.getSql();
            }
            ExecutionStats executionStats = new ExecutionStats(updateCount, statementCount);
            return executionStats;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            supplier.close();
        }
    }

    protected int executeSql(Statement statement, String sql, JdbcContext context) throws SQLException {
        try {
            int updateCount = 0;
            long start = System.currentTimeMillis();
            context.getListener().beforeExecuteSql(new SqlEvent(sql, start));
            if (!context.isSkip()) {
                statement.execute(sql);
                updateCount = statement.getUpdateCount();
                updateCount = updateCount == -1 ? 0 : updateCount;
            }
            context.getListener().afterExecuteSql(new SqlEvent(sql, updateCount, start, System.currentTimeMillis()));
            return updateCount;
        }
        catch (SQLException e) {
            throw new SQLException("Error executing SQL [" + Str.flatten((String)sql) + "]", e);
        }
    }

    @Override
    public JdbcMetaData getJdbcMetaData(DataSource dataSource) {
        Connection conn = null;
        try {
            conn = DataSourceUtils.doGetConnection((DataSource)dataSource);
            DatabaseMetaData dbmd = conn.getMetaData();
            JdbcMetaData jdbcMetaData = this.getJdbcMetaData(dbmd);
            return jdbcMetaData;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        finally {
            logger.trace("closing connection");
            JdbcUtils.closeQuietly(dataSource, conn);
        }
    }

    protected JdbcMetaData getJdbcMetaData(DatabaseMetaData dbmd) throws SQLException {
        JdbcMetaData md = new JdbcMetaData();
        md.setDatabaseProductName(dbmd.getDatabaseProductName());
        md.setDatabaseProductVersion(dbmd.getDatabaseProductVersion());
        md.setDriverName(dbmd.getDriverName());
        md.setDriverVersion(dbmd.getDriverVersion());
        md.setUrl(dbmd.getURL());
        md.setUsername(dbmd.getUserName());
        return md;
    }
}

