/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jdbc.convert;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.common.jdbc.convert.ConversionContext;
import org.kuali.common.jdbc.convert.ConversionResult;
import org.kuali.common.jdbc.convert.SqlConverter;
import org.kuali.common.jdbc.convert.SqlInsertContext;
import org.kuali.common.jdbc.reader.DefaultSqlReader;
import org.kuali.common.jdbc.reader.SqlReader;
import org.kuali.common.jdbc.sql.model.SqlMetaData;
import org.kuali.common.util.LocationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInsertMergeSqlConverter
implements SqlConverter {
    private static final Logger logger = LoggerFactory.getLogger(AbstractInsertMergeSqlConverter.class);
    private static final String LF = "\n";

    @Override
    public ConversionResult convert(ConversionContext context) {
        ConversionResult conversionResult;
        logger.debug("Converting {}", (Object)LocationUtils.getCanonicalPath((File)context.getOldFile()));
        File newFile = context.getNewFile();
        File oldFile = context.getOldFile();
        DefaultSqlReader reader = new DefaultSqlReader(context.getDelimiter());
        BufferedReader in = null;
        FileOutputStream out = null;
        try {
            in = LocationUtils.getBufferedReader((File)oldFile, (String)context.getEncoding());
            out = FileUtils.openOutputStream((File)newFile);
            conversionResult = this.convert(context, reader, in, out);
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException("Unexpected IO error");
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)in);
        IOUtils.closeQuietly((OutputStream)out);
        return conversionResult;
    }

    protected ConversionResult convert(ConversionContext context, SqlReader reader, BufferedReader in, OutputStream out) throws IOException {
        String sql = reader.getSql(in);
        while (sql != null) {
            String outputSql = this.getOutputSql(context, in, sql, reader);
            out.write(outputSql.getBytes(context.getEncoding()));
            sql = reader.getSql(in);
        }
        SqlMetaData before = this.getMetaData(context.getOldFile(), reader, context.getEncoding());
        SqlMetaData after = this.getMetaData(context.getNewFile(), reader, context.getEncoding());
        return new ConversionResult(context.getOldFile(), context.getNewFile(), before, after);
    }

    protected String getOutputSql(ConversionContext context, BufferedReader in, String sql, SqlReader reader) throws IOException {
        boolean insertStatement = this.isInsert(sql);
        if (insertStatement) {
            SqlInsertContext mc = new SqlInsertContext();
            mc.setSql(sql);
            mc.setReader(reader);
            mc.setInput(in);
            return this.combineInserts(context, mc);
        }
        StringBuilder sqlBuilder = new StringBuilder(sql);
        sqlBuilder.append(this.getLineFeed()).append(context.getDelimiter()).append(this.getLineFeed());
        return sqlBuilder.toString();
    }

    protected abstract String combineInserts(ConversionContext var1, SqlInsertContext var2) throws IOException;

    protected boolean isInsert(String sql) {
        String trimmed = StringUtils.trim((String)sql);
        return StringUtils.startsWith((CharSequence)trimmed, (CharSequence)this.getInsertPrefix());
    }

    public abstract String getInsertPrefix();

    protected SqlMetaData getMetaData(File file, SqlReader reader, String encoding) {
        BufferedReader in = null;
        try {
            in = LocationUtils.getBufferedReader((File)file, (String)encoding);
            SqlMetaData sqlMetaData = reader.getMetaData(in);
            return sqlMetaData;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected IO error");
        }
        finally {
            IOUtils.closeQuietly((Reader)in);
        }
    }

    public String getLineFeed() {
        return LF;
    }

    protected boolean continueBatch(String sql, int count, int length, ConversionContext context) {
        if (sql == null) {
            return false;
        }
        if (!this.isInsert(sql)) {
            return false;
        }
        if (count >= context.getMaxCount()) {
            return false;
        }
        return length < context.getMaxLength();
    }
}

