/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jdbc.listener;

import org.kuali.common.jdbc.JdbcUtils;
import org.kuali.common.jdbc.listener.NoOpSqlListener;
import org.kuali.common.jdbc.listener.SqlExecutionEvent;
import org.kuali.common.jdbc.listener.SqlMetaDataEvent;
import org.kuali.common.util.FormatUtils;
import org.kuali.common.util.LoggerLevel;
import org.kuali.common.util.LoggerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class DataSummaryListener
extends NoOpSqlListener {
    private static final Logger logger = LoggerFactory.getLogger(DataSummaryListener.class);
    long count;
    long size;
    LoggerLevel loggerLevel = LoggerLevel.INFO;
    boolean showRate = true;
    String label = "Rows";
    String throughputLabel = "rows/s";

    public DataSummaryListener() {
        this(true);
    }

    public DataSummaryListener(boolean showRate) {
        this.showRate = showRate;
    }

    @Override
    public void afterMetaData(SqlMetaDataEvent event) {
        this.count = JdbcUtils.getSqlCount(event.getContext().getSuppliers());
        this.size = JdbcUtils.getSqlSize(event.getContext().getSuppliers());
        String count = FormatUtils.getCount((long)this.count);
        String sources = FormatUtils.getCount((long)event.getContext().getSuppliers().size());
        String size = FormatUtils.getSize((long)this.size);
        Object[] args = new Object[]{this.label, count, sources, size};
        LoggerUtils.logMsg((String)"Executing - [{}: {}  Sources: {}  Size: {}]", (Object[])args, (Logger)logger, (LoggerLevel)this.loggerLevel);
    }

    @Override
    public void afterExecution(SqlExecutionEvent event) {
        long elapsed = event.getStopTimeMillis() - event.getStartTimeMillis();
        String count = FormatUtils.getCount((long)this.count);
        String sources = FormatUtils.getCount((long)event.getContext().getSuppliers().size());
        String size = FormatUtils.getSize((long)this.size);
        String time = FormatUtils.getTime((long)elapsed);
        String rate = FormatUtils.getRate((long)elapsed, (long)this.size);
        String throughput = FormatUtils.getThroughputInSeconds((long)elapsed, (long)this.count, (String)this.throughputLabel);
        Object[] args = new Object[]{this.label, count, sources, size, time, throughput, rate};
        if (this.showRate) {
            LoggerUtils.logMsg((String)"Completed - [{}: {}  Sources: {}  Size: {}  Time: {}  Throughput: {}  Rate: {}]", (Object[])args, (Logger)logger, (LoggerLevel)this.loggerLevel);
        } else {
            LoggerUtils.logMsg((String)"Completed - [{}: {}  Sources: {}  Size: {}  Time: {}  Throughput: {}]", (Object[])args, (Logger)logger, (LoggerLevel)this.loggerLevel);
        }
    }

    public boolean isShowRate() {
        return this.showRate;
    }

    public void setShowRate(boolean showRate) {
        this.showRate = showRate;
    }

    public LoggerLevel getLoggerLevel() {
        return this.loggerLevel;
    }

    public void setLoggerLevel(LoggerLevel loggerLevel) {
        this.loggerLevel = loggerLevel;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getThroughputLabel() {
        return this.throughputLabel;
    }

    public void setThroughputLabel(String throughputLabel) {
        this.throughputLabel = throughputLabel;
    }
}

