/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jdbc.listeners;

import org.kuali.common.jdbc.listeners.NoOpSqlListener;
import org.kuali.common.jdbc.model.LogSqlMode;
import org.kuali.common.jdbc.model.event.SqlEvent;
import org.kuali.common.util.Assert;
import org.kuali.common.util.FormatUtils;
import org.kuali.common.util.Str;
import org.kuali.common.util.log.LoggerLevel;
import org.kuali.common.util.log.LoggerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LogSqlListener
extends NoOpSqlListener {
    private static final Logger logger = LoggerFactory.getLogger(LogSqlListener.class);
    public static final LoggerLevel DEFAULT_LOGGER_LEVEL = LoggerLevel.DEBUG;
    public static final LogSqlMode DEFAULT_MODE = LogSqlMode.AFTER;
    public static final boolean DEFAULT_FLATTEN = true;
    private final LoggerLevel level;
    private final boolean flatten;
    private final LogSqlMode mode;

    public LogSqlListener() {
        this(DEFAULT_LOGGER_LEVEL, DEFAULT_MODE, true);
    }

    public LogSqlListener(LoggerLevel level, LogSqlMode mode) {
        this(level, mode, true);
    }

    public LogSqlListener(LoggerLevel level, LogSqlMode mode, boolean flatten) {
        Assert.noNulls((Object[])new Object[]{level, mode});
        this.level = level;
        this.mode = mode;
        this.flatten = flatten;
    }

    @Override
    public void beforeExecuteSql(SqlEvent event) {
        switch (this.mode) {
            case BEFORE: 
            case BOTH: {
                String sql = this.getSql(event.getSql(), this.flatten);
                LoggerUtils.logMsg((String)sql, (Logger)logger, (LoggerLevel)this.level);
                return;
            }
            case AFTER: {
                return;
            }
        }
        throw new IllegalArgumentException("Mode [" + (Object)((Object)this.mode) + "] is unknown");
    }

    @Override
    public void afterExecuteSql(SqlEvent event) {
        switch (this.mode) {
            case BEFORE: {
                return;
            }
            case BOTH: 
            case AFTER: {
                String sql = this.getSql(event.getSql(), this.flatten);
                String elapsed = FormatUtils.getTime((long)(event.getStopTimeMillis() - event.getStartTimeMillis()));
                Object[] args = new Object[]{sql, elapsed};
                LoggerUtils.logMsg((String)"{} - {}", (Object[])args, (Logger)logger, (LoggerLevel)this.level);
                return;
            }
        }
        throw new IllegalArgumentException("Mode [" + (Object)((Object)this.mode) + "] is unknown");
    }

    protected String getSql(String sql, boolean flatten) {
        if (flatten) {
            return "[" + Str.flatten((String)sql) + "]";
        }
        return sql;
    }

    public static Logger getLogger() {
        return logger;
    }

    public LoggerLevel getLevel() {
        return this.level;
    }

    public boolean isFlatten() {
        return this.flatten;
    }

    public LogSqlMode getMode() {
        return this.mode;
    }
}

