/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jdbc.listeners;

import java.util.List;
import org.kuali.common.jdbc.listeners.SqlListener;
import org.kuali.common.jdbc.model.event.SqlEvent;
import org.kuali.common.jdbc.model.event.SqlExecutionEvent;
import org.kuali.common.util.Assert;
import org.kuali.common.util.ListUtils;

public final class NotifyingListener
implements SqlListener {
    private final List<SqlListener> listeners;

    public NotifyingListener(List<SqlListener> listeners) {
        Assert.noNulls((Object[])new Object[]{listeners});
        this.listeners = ListUtils.newImmutableArrayList(listeners);
    }

    @Override
    public void beforeExecution(SqlExecutionEvent event) {
        for (SqlListener listener : this.listeners) {
            listener.beforeExecution(event);
        }
    }

    @Override
    public void beforeExecuteSql(SqlEvent event) {
        for (SqlListener listener : this.listeners) {
            listener.beforeExecuteSql(event);
        }
    }

    @Override
    public void afterExecuteSql(SqlEvent event) {
        for (SqlListener listener : this.listeners) {
            listener.afterExecuteSql(event);
        }
    }

    @Override
    public void afterExecution(SqlExecutionEvent event) {
        for (SqlListener listener : this.listeners) {
            listener.afterExecution(event);
        }
    }

    public List<SqlListener> getListeners() {
        return this.listeners;
    }
}

