/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jdbc.model;

import java.util.Collections;
import java.util.List;
import org.kuali.common.jdbc.suppliers.SqlSupplier;
import org.kuali.common.util.Assert;
import org.kuali.common.util.ListUtils;

public final class SqlBucket
implements Comparable<SqlBucket> {
    public static final long DEFAULT_COUNT = 0L;
    public static final long DEFAULT_SIZE = 0L;
    public static List<SqlSupplier> DEFAULT_SUPPLIERS = Collections.emptyList();
    private final long count;
    private final long size;
    private final List<SqlSupplier> suppliers;

    public SqlBucket() {
        this(0L, 0L, DEFAULT_SUPPLIERS);
    }

    public SqlBucket(long count, long size, List<SqlSupplier> suppliers) {
        Assert.noNulls((Object[])new Object[]{suppliers});
        this.count = count;
        this.size = size;
        this.suppliers = ListUtils.newImmutableArrayList(suppliers);
    }

    @Override
    public int compareTo(SqlBucket other) {
        return Double.compare(this.size, other.getSize());
    }

    public long getCount() {
        return this.count;
    }

    public long getSize() {
        return this.size;
    }

    public List<SqlSupplier> getSuppliers() {
        return this.suppliers;
    }
}

