/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jdbc.model.context;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.sql.DataSource;
import org.kuali.common.jdbc.listeners.LogSqlListener;
import org.kuali.common.jdbc.listeners.SqlListener;
import org.kuali.common.jdbc.model.enums.CommitMode;
import org.kuali.common.jdbc.suppliers.SqlSupplier;
import org.kuali.common.util.Assert;

public final class JdbcContext {
    private final DataSource dataSource;
    private final List<SqlSupplier> suppliers;
    private final boolean skipSqlExecution;
    private final int threads;
    private final boolean multithreaded;
    private final SqlListener listener;
    private final CommitMode commitMode;
    private final Optional<String> message;
    private final boolean trackProgressByUpdateCount;

    public boolean isSkipSqlExecution() {
        return this.skipSqlExecution;
    }

    public int getThreads() {
        return this.threads;
    }

    public boolean isMultithreaded() {
        return this.multithreaded;
    }

    public SqlListener getListener() {
        return this.listener;
    }

    public CommitMode getCommitMode() {
        return this.commitMode;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public List<SqlSupplier> getSuppliers() {
        return this.suppliers;
    }

    public Optional<String> getMessage() {
        return this.message;
    }

    public boolean isTrackProgressByUpdateCount() {
        return this.trackProgressByUpdateCount;
    }

    private JdbcContext(Builder builder) {
        this.dataSource = builder.dataSource;
        this.suppliers = builder.suppliers;
        this.skipSqlExecution = builder.skipSqlExecution;
        this.threads = builder.threads;
        this.multithreaded = builder.multithreaded;
        this.listener = builder.listener;
        this.commitMode = builder.commitMode;
        this.message = builder.message;
        this.trackProgressByUpdateCount = builder.trackProgressByUpdateCount;
    }

    public static class Builder {
        private final DataSource dataSource;
        private final List<SqlSupplier> suppliers;
        private boolean skipSqlExecution = false;
        private int threads = 8;
        private boolean multithreaded = false;
        private SqlListener listener = new LogSqlListener();
        private CommitMode commitMode = CommitMode.PER_SUPPLIER;
        private Optional<String> message = Optional.absent();
        private boolean trackProgressByUpdateCount = false;

        public JdbcContext build() {
            Assert.noNulls((Object[])new Object[]{this.dataSource, this.suppliers, this.listener, this.commitMode, this.message});
            if (this.multithreaded) {
                Assert.isTrue((this.threads > 0 ? 1 : 0) != 0, (String)"threads must be a positive integer");
            }
            return new JdbcContext(this);
        }

        public Builder(DataSource dataSource, SqlSupplier supplier) {
            this(dataSource, (List<SqlSupplier>)ImmutableList.of((Object)supplier));
        }

        public Builder(DataSource dataSource, List<SqlSupplier> suppliers) {
            this.dataSource = dataSource;
            this.suppliers = suppliers;
        }

        public Builder skipSqlExecution(boolean skipSqlExecution) {
            this.skipSqlExecution = skipSqlExecution;
            return this;
        }

        public Builder multithreaded(boolean multithreaded) {
            this.multithreaded = multithreaded;
            return this;
        }

        public Builder listener(SqlListener listener) {
            this.listener = listener;
            return this;
        }

        public Builder commitMode(CommitMode commitMode) {
            this.commitMode = commitMode;
            return this;
        }

        public Builder trackProgressByUpdateCount(boolean trackProgressByUpdateCount) {
            this.trackProgressByUpdateCount = trackProgressByUpdateCount;
            return this;
        }

        public Builder message(String message) {
            this.message = Optional.fromNullable((Object)message);
            return this;
        }

        public Builder threads(int threads) {
            this.threads = threads;
            return this;
        }
    }
}

