/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jdbc.project.spring;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.kuali.common.jdbc.project.JdbcProjectConstants;
import org.kuali.common.util.project.model.ProjectIdentifier;
import org.kuali.common.util.properties.Location;
import org.kuali.common.util.properties.PropertiesLocationService;
import org.kuali.common.util.properties.spring.PropertiesLocationServiceConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={PropertiesLocationServiceConfig.class})
public class JdbcPropertyLocationsConfig {
    private static final ProjectIdentifier SQL = JdbcProjectConstants.KUALI_SQL;
    private static final ProjectIdentifier JDBC = JdbcProjectConstants.PROJECT_ID;
    @Autowired
    PropertiesLocationService service;

    @Bean
    public List<Location> jdbcPropertyLocations() {
        ArrayList locations = new ArrayList();
        locations.addAll(this.service.getLocations(SQL, this.getSqlFilenames()));
        locations.addAll(this.service.getLocations(JDBC, new String[]{"config.properties"}));
        return ImmutableList.copyOf(locations);
    }

    protected List<String> getSqlFilenames() {
        ArrayList<String> filenames = new ArrayList<String>();
        filenames.add("derby.xml");
        filenames.add("h2.xml");
        filenames.add("mysql.xml");
        filenames.add("oracle.xml");
        filenames.add("sql.xml");
        return filenames;
    }
}

