/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jdbc.reader;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.common.jdbc.reader.SqlReader;
import org.kuali.common.jdbc.reader.model.Comments;
import org.kuali.common.jdbc.reader.model.Delimiter;
import org.kuali.common.jdbc.reader.model.DelimiterMode;
import org.kuali.common.jdbc.reader.model.LineSeparator;
import org.kuali.common.jdbc.sql.model.SqlMetaData;
import org.kuali.common.util.Assert;

public final class DefaultSqlReader
implements SqlReader {
    public static final boolean DEFAULT_TRIM = true;
    private final Delimiter delimiter;
    private final LineSeparator lineSeparator;
    private final boolean trim;
    private final Comments comments;
    private final int lineSeparatorLength;
    private final int delimiterLength;

    public DefaultSqlReader() {
        this(Delimiter.DEFAULT_DELIMITER, LineSeparator.DEFAULT_VALUE, true, Comments.DEFAULT_COMMENTS);
    }

    public DefaultSqlReader(String delimiter) {
        this(new Delimiter(delimiter), LineSeparator.DEFAULT_VALUE, true, Comments.DEFAULT_COMMENTS);
    }

    public DefaultSqlReader(DelimiterMode delimiterMode) {
        this(new Delimiter(delimiterMode), LineSeparator.DEFAULT_VALUE, true, Comments.DEFAULT_COMMENTS);
    }

    public DefaultSqlReader(String delimiter, DelimiterMode delimiterMode) {
        this(new Delimiter(delimiter, delimiterMode), LineSeparator.DEFAULT_VALUE, true, Comments.DEFAULT_COMMENTS);
    }

    public DefaultSqlReader(Delimiter delimiter, LineSeparator lineSeparator, boolean trim, Comments comments) {
        Assert.noNulls((Object[])new Object[]{delimiter, lineSeparator, comments});
        this.delimiter = delimiter;
        this.lineSeparator = lineSeparator;
        this.trim = trim;
        this.comments = comments;
        this.lineSeparatorLength = this.lineSeparator.getValue().length();
        this.delimiterLength = delimiter.getValue().length();
    }

    @Override
    public String getSql(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        String trimmedLine = StringUtils.trimToNull((String)line);
        StringBuilder sb = new StringBuilder();
        while (line != null) {
            if (this.isEndOfSqlStatement(trimmedLine, this.delimiter)) {
                return this.getReturnValue(sb.toString() + trimmedLine, this.trim, this.lineSeparator);
            }
            if (!this.ignore(this.comments, sb, trimmedLine)) {
                sb.append(line + this.lineSeparator.getValue());
            }
            line = reader.readLine();
            trimmedLine = StringUtils.trimToNull((String)line);
        }
        String result = this.getReturnValue(sb.toString(), this.trim, this.lineSeparator);
        if (result == null) {
            return null;
        }
        return result;
    }

    @Override
    public SqlMetaData getMetaData(BufferedReader reader) throws IOException {
        long count = 0L;
        long size = 0L;
        String line = reader.readLine();
        String trimmedLine = StringUtils.trimToNull((String)line);
        while (line != null) {
            size += (long)line.length();
            if (this.isEndOfSqlStatement(trimmedLine, this.delimiter)) {
                ++count;
            }
            line = reader.readLine();
            trimmedLine = StringUtils.trimToNull((String)line);
        }
        return new SqlMetaData(count, size);
    }

    protected String getReturnValue(String sql, boolean trim, LineSeparator lineSeparator) {
        int endIndex;
        if (StringUtils.endsWith((CharSequence)sql, (CharSequence)this.delimiter.getValue())) {
            endIndex = sql.length() - this.delimiterLength;
            sql = StringUtils.substring((String)sql, (int)0, (int)endIndex);
        }
        if (trim) {
            sql = StringUtils.trimToNull((String)sql);
        }
        if (sql == null) {
            return null;
        }
        if (StringUtils.endsWith((CharSequence)sql, (CharSequence)lineSeparator.getValue())) {
            endIndex = sql.length() - this.lineSeparatorLength;
            return StringUtils.substring((String)sql, (int)0, (int)endIndex);
        }
        return sql;
    }

    protected boolean isEndOfSqlStatement(String trimmedLine, Delimiter delimiter) {
        switch (delimiter.getMode()) {
            case END_OF_LINE: {
                return StringUtils.endsWith((CharSequence)trimmedLine, (CharSequence)delimiter.getValue());
            }
            case OWN_LINE: {
                return StringUtils.equals((CharSequence)trimmedLine, (CharSequence)delimiter.getValue());
            }
        }
        throw new IllegalArgumentException("Delimiter mode [" + (Object)((Object)delimiter.getMode()) + "] is unknown");
    }

    protected boolean proceed(String line, String trimmedLine, Delimiter delimiter) {
        if (line == null) {
            return false;
        }
        boolean endOfSqlStatement = this.isEndOfSqlStatement(trimmedLine, delimiter);
        return !endOfSqlStatement;
    }

    protected boolean ignore(Comments comments, StringBuilder sql, String trimmedLine) {
        if (!comments.isIgnore()) {
            return false;
        }
        if (!StringUtils.isBlank((CharSequence)sql.toString())) {
            return false;
        }
        return this.isSqlComment(trimmedLine, comments.getTokens());
    }

    protected boolean isSqlComment(String trimmedLine, List<String> commentTokens) {
        for (String commentToken : commentTokens) {
            if (!StringUtils.startsWith((CharSequence)trimmedLine, (CharSequence)commentToken)) continue;
            return true;
        }
        return false;
    }

    public Delimiter getDelimiter() {
        return this.delimiter;
    }

    public LineSeparator getLineSeparator() {
        return this.lineSeparator;
    }

    public boolean isTrim() {
        return this.trim;
    }

    public Comments getComments() {
        return this.comments;
    }
}

