/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jdbc.service;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.kuali.common.jdbc.listeners.NotifyingListener;
import org.kuali.common.jdbc.listeners.SqlListener;
import org.kuali.common.jdbc.listeners.ThreadSafeListener;
import org.kuali.common.jdbc.model.ExecutionResult;
import org.kuali.common.jdbc.model.ExecutionStats;
import org.kuali.common.jdbc.model.SqlBucket;
import org.kuali.common.jdbc.model.context.JdbcContext;
import org.kuali.common.jdbc.model.context.SqlBucketContext;
import org.kuali.common.jdbc.model.enums.CommitMode;
import org.kuali.common.jdbc.model.event.SqlEvent;
import org.kuali.common.jdbc.model.event.SqlExecutionEvent;
import org.kuali.common.jdbc.model.meta.Driver;
import org.kuali.common.jdbc.model.meta.JdbcMetaData;
import org.kuali.common.jdbc.model.meta.Product;
import org.kuali.common.jdbc.service.JdbcService;
import org.kuali.common.jdbc.service.JdbcUtils;
import org.kuali.common.jdbc.service.MetaDataUtils;
import org.kuali.common.jdbc.service.SqlBucketHandler;
import org.kuali.common.jdbc.service.ThreadsContext;
import org.kuali.common.jdbc.sql.model.SqlMetaData;
import org.kuali.common.jdbc.suppliers.SimpleStringSupplier;
import org.kuali.common.jdbc.suppliers.SqlSupplier;
import org.kuali.common.threads.ElementHandler;
import org.kuali.common.threads.ExecutionStatistics;
import org.kuali.common.threads.ThreadHandlerContext;
import org.kuali.common.threads.ThreadInvoker;
import org.kuali.common.util.Assert;
import org.kuali.common.util.CollectionUtils;
import org.kuali.common.util.FormatUtils;
import org.kuali.common.util.Str;
import org.kuali.common.util.inform.PercentCompleteInformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.DataSourceUtils;

public class DefaultJdbcService
implements JdbcService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultJdbcService.class);

    @Override
    public ExecutionResult executeSql(JdbcContext context) {
        long start = System.currentTimeMillis();
        if (context.getMessage().isPresent()) {
            logger.info((String)context.getMessage().get());
        }
        if (CollectionUtils.isEmpty(context.getSuppliers())) {
            logger.info("Skipping execution.  No suppliers");
            return new ExecutionResult(0L, start, System.currentTimeMillis(), 0L);
        }
        long sqlStart = System.currentTimeMillis();
        context.getListener().beforeExecution(new SqlExecutionEvent(context, start, -1L));
        ExecutionStats stats = null;
        stats = context.isMultithreaded() ? this.executeMultiThreaded(context) : this.executeSequentially(context);
        context.getListener().afterExecution(new SqlExecutionEvent(context, sqlStart, System.currentTimeMillis()));
        return new ExecutionResult(stats.getUpdateCount(), start, System.currentTimeMillis(), stats.getStatementCount());
    }

    protected ThreadsContext getThreadsContext(JdbcContext context) {
        long total = MetaDataUtils.getSqlCount(context.getSuppliers());
        PercentCompleteInformer informer = new PercentCompleteInformer(total);
        ThreadSafeListener threadSafeListener = new ThreadSafeListener(informer, context.isTrackProgressByUpdateCount());
        ArrayList<SqlListener> listeners = new ArrayList<SqlListener>(Arrays.asList(context.getListener(), threadSafeListener));
        NotifyingListener listener = new NotifyingListener(listeners);
        return new ThreadsContext(informer, threadSafeListener, listener);
    }

    protected ExecutionStats executeMultiThreaded(JdbcContext context) {
        List<SqlBucket> buckets = this.getSqlBuckets(context);
        Collections.sort(buckets);
        Collections.reverse(buckets);
        ThreadsContext threadsContext = this.getThreadsContext(context);
        List<SqlBucketContext> sbcs = this.getSqlBucketContexts(buckets, context, threadsContext.getListener());
        ThreadHandlerContext thc = new ThreadHandlerContext();
        thc.setList(sbcs);
        thc.setHandler((ElementHandler)new SqlBucketHandler());
        thc.setMax(buckets.size());
        thc.setMin(buckets.size());
        thc.setDivisor(1);
        ThreadInvoker invoker = new ThreadInvoker();
        threadsContext.getInformer().start();
        ExecutionStatistics stats = invoker.invokeThreads(thc);
        threadsContext.getInformer().stop();
        ThreadSafeListener listener = threadsContext.getThreadSafeListener();
        this.logStats(listener, stats, buckets);
        return new ExecutionStats(listener.getAggregateUpdateCount(), listener.getAggregateSqlCount());
    }

    protected void logStats(ThreadSafeListener listener, ExecutionStatistics stats, List<SqlBucket> buckets) {
        long aggregateTime = listener.getAggregateTime();
        long wallTime = stats.getExecutionTime();
        String avgMillis = FormatUtils.getTime((long)(aggregateTime / (long)buckets.size()));
        String aTime = FormatUtils.getTime((long)aggregateTime);
        String wTime = FormatUtils.getTime((long)wallTime);
        String sqlCount = FormatUtils.getCount((long)listener.getAggregateSqlCount());
        String sqlSize = FormatUtils.getSize((long)listener.getAggregateSqlSize());
        Object[] args = new Object[]{buckets.size(), wTime, aTime, avgMillis, sqlCount, sqlSize};
        logger.debug("Threads - [count: {}  time: {}  aggregate: {}  avg: {}  sql: {} - {}]", args);
    }

    @Override
    public ExecutionResult executeSql(DataSource dataSource, String sql) {
        return this.executeSql(dataSource, CollectionUtils.singletonList((Object)sql));
    }

    @Override
    public ExecutionResult executeSql(DataSource dataSource, List<String> sql) {
        SimpleStringSupplier supplier = new SimpleStringSupplier(sql);
        JdbcContext context = new JdbcContext.Builder(dataSource, supplier).build();
        return this.executeSql(context);
    }

    protected List<SqlBucketContext> getSqlBucketContexts(List<SqlBucket> buckets, JdbcContext context, SqlListener listener) {
        ArrayList<SqlBucketContext> sbcs = new ArrayList<SqlBucketContext>();
        for (SqlBucket bucket : buckets) {
            JdbcContext newJdbcContext = this.getJdbcContext(context, bucket, listener);
            SqlBucketContext sbc = new SqlBucketContext(bucket, newJdbcContext, this);
            sbcs.add(sbc);
        }
        return sbcs;
    }

    protected JdbcContext getJdbcContext(JdbcContext original, SqlBucket bucket, SqlListener listener) {
        boolean skip = original.isSkipSqlExecution();
        DataSource dataSource = original.getDataSource();
        List<SqlSupplier> suppliers = bucket.getSuppliers();
        CommitMode commitMode = original.getCommitMode();
        return new JdbcContext.Builder(dataSource, suppliers).listener(listener).commitMode(commitMode).skipSqlExecution(skip).build();
    }

    protected List<SqlBucket> getSqlBuckets(JdbcContext context) {
        ArrayList<SqlSupplier> suppliers = new ArrayList<SqlSupplier>(context.getSuppliers());
        int bucketCount = Math.min(context.getThreads(), suppliers.size());
        Assert.isTrue((bucketCount > 0 ? 1 : 0) != 0, (String)"bucket count must be a positive integer");
        Collections.sort(suppliers);
        Collections.reverse(suppliers);
        List buckets = CollectionUtils.getNewList(SqlBucket.class, (int)bucketCount);
        for (SqlSupplier supplier : suppliers) {
            Collections.sort(buckets);
            SqlBucket smallest = (SqlBucket)buckets.get(0);
            SqlBucket newBucket = this.getNewBucket(smallest, supplier);
            buckets.remove(0);
            buckets.add(newBucket);
        }
        return buckets;
    }

    protected SqlBucket getNewBucket(SqlBucket bucket, SqlSupplier supplier) {
        ArrayList<SqlSupplier> list = new ArrayList<SqlSupplier>(bucket.getSuppliers());
        list.add(supplier);
        SqlMetaData smd = supplier.getMetaData();
        long count = bucket.getCount() + smd.getCount();
        long size = bucket.getSize() + smd.getSize();
        return new SqlBucket(count, size, list);
    }

    protected ExecutionStats executeSequentially(JdbcContext context) {
        ExecutionStats executionStats;
        Connection conn = null;
        Statement statement = null;
        try {
            long updateCount = 0L;
            long statementCount = 0L;
            conn = DataSourceUtils.doGetConnection((DataSource)context.getDataSource());
            boolean originalAutoCommitSetting = conn.getAutoCommit();
            conn.setAutoCommit(false);
            statement = conn.createStatement();
            List<SqlSupplier> suppliers = context.getSuppliers();
            for (SqlSupplier supplier : suppliers) {
                ExecutionStats stats = this.excecuteSupplier(statement, context, supplier);
                updateCount += stats.getUpdateCount();
                statementCount += stats.getStatementCount();
                conn.commit();
            }
            conn.setAutoCommit(originalAutoCommitSetting);
            executionStats = new ExecutionStats(updateCount, statementCount);
        }
        catch (Exception e) {
            try {
                throw new IllegalStateException(e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(context.getDataSource(), conn, statement);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly(context.getDataSource(), conn, statement);
        return executionStats;
    }

    protected ExecutionStats excecuteSupplier(Statement statement, JdbcContext context, SqlSupplier supplier) throws SQLException {
        try {
            long updateCount = 0L;
            long statementCount = 0L;
            supplier.open();
            List<String> sql = supplier.getSql();
            while (sql != null) {
                for (String s : sql) {
                    updateCount += (long)this.executeSql(statement, s, context);
                    ++statementCount;
                }
                sql = supplier.getSql();
            }
            ExecutionStats executionStats = new ExecutionStats(updateCount, statementCount);
            return executionStats;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            supplier.close();
        }
    }

    protected int executeSql(Statement statement, String sql, JdbcContext context) throws SQLException {
        try {
            int updateCount = 0;
            long start = System.currentTimeMillis();
            context.getListener().beforeExecuteSql(new SqlEvent(sql, start));
            if (!context.isSkipSqlExecution()) {
                statement.execute(sql);
                updateCount = statement.getUpdateCount();
                updateCount = updateCount == -1 ? 0 : updateCount;
            }
            context.getListener().afterExecuteSql(new SqlEvent(sql, updateCount, start, System.currentTimeMillis()));
            return updateCount;
        }
        catch (SQLException e) {
            throw new SQLException("Error executing SQL [" + Str.flatten((String)sql) + "]", e);
        }
    }

    @Override
    public JdbcMetaData getJdbcMetaData(DataSource dataSource) {
        Connection conn = null;
        try {
            conn = DataSourceUtils.doGetConnection((DataSource)dataSource);
            DatabaseMetaData dbmd = conn.getMetaData();
            JdbcMetaData jdbcMetaData = this.getJdbcMetaData(dbmd);
            return jdbcMetaData;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        finally {
            logger.trace("closing connection");
            JdbcUtils.closeQuietly(dataSource, conn);
        }
    }

    protected JdbcMetaData getJdbcMetaData(DatabaseMetaData dbmd) throws SQLException {
        Product product = this.getProduct(dbmd);
        Driver driver = this.getDriver(dbmd);
        String url = dbmd.getURL();
        String username = dbmd.getUserName();
        if (username == null) {
            username = "NULL";
        } else if (StringUtils.isBlank((CharSequence)username)) {
            username = "NONE";
        }
        return new JdbcMetaData(product, driver, url, username);
    }

    protected Product getProduct(DatabaseMetaData dbmd) throws SQLException {
        String name = dbmd.getDatabaseProductName();
        String version = dbmd.getDatabaseProductVersion();
        return new Product(name, version);
    }

    protected Driver getDriver(DatabaseMetaData dbmd) throws SQLException {
        String name = dbmd.getDriverName();
        String version = dbmd.getDriverVersion();
        return new Driver(name, version);
    }
}

