/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jdbc.service;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.util.Assert;

public class JdbcUtils {
    private static final Logger logger = LoggerFactory.getLogger(JdbcUtils.class);

    public static final void closeQuietly(DataSource dataSource, Connection conn, Statement statement) {
        JdbcUtils.closeQuietly(statement);
        JdbcUtils.closeQuietly(dataSource, conn);
    }

    public static final void closeQuietly(Statement statement) {
        if (statement == null) {
            return;
        }
        try {
            statement.close();
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    public static final void closeQuietly(ResultSet rs) {
        if (rs == null) {
            return;
        }
        try {
            rs.close();
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    public static final void closeQuietly(DataSource dataSource, Connection conn) {
        if (conn == null && dataSource == null) {
            return;
        }
        Assert.notNull((Object)dataSource, (String)"dataSource is null but conn is not");
        try {
            logger.debug("releasing connection");
            DataSourceUtils.doReleaseConnection((Connection)conn, (DataSource)dataSource);
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }
}

