/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jdbc.service;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.kuali.common.jdbc.reader.SqlReader;
import org.kuali.common.jdbc.sql.model.SqlMetaData;
import org.kuali.common.jdbc.suppliers.ComplexStringSupplier;
import org.kuali.common.jdbc.suppliers.SimpleStringSupplier;
import org.kuali.common.jdbc.suppliers.SqlLocationContext;
import org.kuali.common.jdbc.suppliers.SqlSupplier;
import org.kuali.common.util.LocationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaDataUtils {
    private static final Logger logger = LoggerFactory.getLogger(MetaDataUtils.class);

    public static SqlMetaData getSqlMetaData(String location, SqlLocationContext context) {
        SqlMetaData sqlMetaData;
        BufferedReader in = null;
        try {
            logger.debug("Getting metadata for [{}] - encoding {}", (Object)location, (Object)context.getEncoding());
            in = LocationUtils.getBufferedReader((String)location, (String)context.getEncoding());
            sqlMetaData = MetaDataUtils.getSqlMetaData(in, context.getReader());
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)in);
        return sqlMetaData;
    }

    public static SqlMetaData getSqlMetaData(ComplexStringSupplier supplier) {
        long count = 0L;
        long size = 0L;
        for (String string : supplier.getStrings()) {
            SqlMetaData smd = MetaDataUtils.getSqlMetaData(string, supplier.getReader());
            count += smd.getCount();
            size += smd.getSize();
        }
        return new SqlMetaData(count, size);
    }

    public static SqlMetaData getSqlMetaData(String sql, SqlReader reader) {
        BufferedReader in = null;
        try {
            in = LocationUtils.getBufferedReaderFromString((String)sql);
            SqlMetaData sqlMetaData = MetaDataUtils.getSqlMetaData(in, reader);
            return sqlMetaData;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            IOUtils.closeQuietly((Reader)in);
        }
    }

    public static SqlMetaData getSqlMetaData(BufferedReader in, SqlReader reader) throws IOException {
        long count = 0L;
        long size = 0L;
        String sql = reader.getSql(in);
        while (sql != null) {
            ++count;
            size += (long)sql.length();
            sql = reader.getSql(in);
        }
        return new SqlMetaData(count, size);
    }

    public static SqlMetaData getSqlMetaData(SimpleStringSupplier supplier) {
        List<String> strings = supplier.getStrings();
        int count = strings.size();
        long size = 0L;
        for (String string : strings) {
            size += (long)string.length();
        }
        return new SqlMetaData(count, size);
    }

    public static long getSqlCount(List<SqlSupplier> suppliers) {
        long count = 0L;
        for (SqlSupplier supplier : suppliers) {
            SqlMetaData smd = supplier.getMetaData();
            count += smd.getCount();
        }
        return count;
    }
}

