/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jdbc.spring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kuali.common.jdbc.DefaultJdbcService;
import org.kuali.common.jdbc.DefaultSqlReader;
import org.kuali.common.jdbc.JdbcService;
import org.kuali.common.jdbc.SqlReader;
import org.kuali.common.jdbc.config.JdbcProjectConstants;
import org.kuali.common.jdbc.supplier.LocationSupplierContext;
import org.kuali.common.jdbc.supplier.LocationSupplierSourceBean;
import org.kuali.common.jdbc.supplier.LocationSuppliersFactoryBean;
import org.kuali.common.jdbc.supplier.SqlLocationSupplier;
import org.kuali.common.jdbc.supplier.SqlSupplier;
import org.kuali.common.util.project.ProjectService;
import org.kuali.common.util.project.ProjectUtils;
import org.kuali.common.util.project.model.Project;
import org.kuali.common.util.project.spring.ProjectServiceConfig;
import org.kuali.common.util.spring.SpringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;

@Configuration
@Import(value={ProjectServiceConfig.class})
@Deprecated
public class JdbcCommonConfig {
    protected static final String CONTEXT_KEY_SUFFIX = ".context";
    @Autowired
    ConfigurableEnvironment env;
    @Autowired
    ProjectServiceConfig projectServiceConfig;

    @Bean
    public SqlReader jdbcSqlReader() {
        return new DefaultSqlReader();
    }

    @Bean
    public JdbcService jdbcService() {
        return new DefaultJdbcService();
    }

    @Bean
    public Map<String, LocationSupplierSourceBean> jdbcExtensionMappings() {
        ProjectService service = this.projectServiceConfig.projectService();
        Project project = service.getProject(JdbcProjectConstants.PROJECT_IDENTIFIER);
        SqlLocationSupplier sls = new SqlLocationSupplier();
        sls.setReader(this.jdbcSqlReader());
        sls.setEncoding(ProjectUtils.getEncoding((Project)project));
        LocationSupplierSourceBean lssb = new LocationSupplierSourceBean();
        lssb.setSupplierClass(SqlLocationSupplier.class);
        lssb.setSupplierInstance(sls);
        HashMap<String, LocationSupplierSourceBean> map = new HashMap<String, LocationSupplierSourceBean>();
        map.put("sql", lssb);
        return map;
    }

    public List<SqlSupplier> getSqlSuppliers(String propertyKey) {
        String contextValue = SpringUtils.getProperty((Environment)this.env, (String)(propertyKey + CONTEXT_KEY_SUFFIX), (String)"NONE");
        LocationSupplierContext context = new LocationSupplierContext();
        context.setValue(contextValue);
        LocationSuppliersFactoryBean factory = new LocationSuppliersFactoryBean();
        factory.setPropertyKey(propertyKey);
        factory.setEnv((Environment)this.env);
        factory.setExtensionMappings(this.jdbcExtensionMappings());
        factory.setContext(context);
        Object list = factory.getObject();
        return new ArrayList<SqlSupplier>((Collection<SqlSupplier>)list);
    }
}

